/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.serialization;

import static org.apache.commons.lang3.StringUtils.join;
import static org.junit.rules.ExpectedException.none;
import static org.mule.runtime.ast.AllureConstants.ArtifactAstSerialization.AST_SERIALIZATION;

import io.qameta.allure.Feature;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@Feature(AST_SERIALIZATION)
public class ArtifactAstSerializerFactoryTestCase {

  @Rule
  public ExpectedException exception = none();

  private ArtifactAstSerializerFactory artifactAstSerializerFactory;

  @Before
  public void setUp() {
    artifactAstSerializerFactory = new ArtifactAstSerializerFactory();
  }

  @Test
  public void testGetSerializerThrowsIllegalArgumentExceptionUnexistingFormat_WhenGettingSerializerForUnexistingFormat() {
    // Given

    // Then
    exception.expect(IllegalArgumentException.class);
    exception.expectMessage("No serializer named 'UNEXISTING' is available. Available serializers are: ["
        + join(artifactAstSerializerFactory.getAvailableSerializers(), ", ") + "]");

    // When
    artifactAstSerializerFactory.getSerializer("UNEXISTING");
  }

  @Test
  public void testGetDeserializerThrowsIllegalArgumentExceptionUnexisting2Format_WhenGettingDeserializerForUnexisting2Format() {
    // Given

    // Then
    exception.expect(IllegalArgumentException.class);
    exception.expectMessage("No deserializer named 'UNEXISTING2' is available. Available deserializers are: ["
        + join(artifactAstSerializerFactory.getAvailableSerializers(), ", ") + "]");

    // When
    artifactAstSerializerFactory.getDeserializer("UNEXISTING2");
  }
}
