/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.serialization;

/**
 * This class represents the information related to the serialization such as format and serializer version
 */
public class ArtifactAstSerializerMetadata {

  private final String serializerId;
  private final String serializerVersion;

  /**
   * This class represents the information related to the serialization such as format and serializer version
   * 
   * @param serializerId      the id or format of the serializer
   * @param serializerVersion the version of the implementation of the
   *                          {@link org.mule.runtime.ast.api.serialization.ArtifactAstSerializer} involved
   */
  public ArtifactAstSerializerMetadata(String serializerId, String serializerVersion) {
    this.serializerId = serializerId;
    this.serializerVersion = serializerVersion;
  }

  /**
   * The serializer id is the format of the serialization
   * 
   * @return a string identifying a format of serialization
   */
  public String getSerializerId() {
    return serializerId;
  }

  /**
   * The serializer version represents the version of the implementation of a given serializer
   * 
   * @return a version string
   */
  public String getSerializerVersion() {
    return serializerVersion;
  }

}
