/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.serialization.dto.factory;

import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.ast.internal.serialization.dto.ErrorTypeRepositoryDTO;

public class ErrorTypeRepositoryDTOFactory {

  public ErrorTypeRepositoryDTO from(ErrorTypeRepository errorTypeRepository) {
    return new ErrorTypeRepositoryDTO(errorTypeRepository.getAnyErrorType(), errorTypeRepository.getSourceErrorType(),
                                      errorTypeRepository.getSourceResponseErrorType(),
                                      errorTypeRepository.getCriticalErrorType(), errorTypeRepository.getErrorTypes(),
                                      errorTypeRepository.getInternalErrorTypes());
  }
}
