/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.serialization.json.gson;

import org.mule.runtime.api.component.TypedComponentIdentifier;
import java.lang.reflect.Type;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;

/**
 * This class implements a Gson JsonSerializer and it can be registered to Gson as a Type Adapter in order to serialize
 * {@link TypedComponentIdentifier}s
 */
public class TypedComponentIdentifierJsonSerializer implements JsonSerializer<TypedComponentIdentifier> {

  @Override
  public JsonElement serialize(TypedComponentIdentifier typedComponentIdentifier, Type type,
                               JsonSerializationContext jsonSerializationContext) {
    ComponentIdentifierJsonSerializer componentIdentifierJsonSerializer = new ComponentIdentifierJsonSerializer();
    ComponentTypeJsonSerializer componentTypeJsonSerializer = new ComponentTypeJsonSerializer();
    JsonObject jsonComponentIdentifier = new JsonObject();

    jsonComponentIdentifier.add("identifier", componentIdentifierJsonSerializer
        .serialize(typedComponentIdentifier.getIdentifier(), type, jsonSerializationContext));
    jsonComponentIdentifier
        .add("type", componentTypeJsonSerializer.serialize(typedComponentIdentifier.getType(), type, jsonSerializationContext));

    return jsonComponentIdentifier;
  }
}
