/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.dto;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.serialization.dto.ImportedResourceDTO;
import org.mule.runtime.ast.internal.serialization.dto.ParserAttributesDTO;

public class ComponentMetadataAstDTO
implements ComponentMetadataAst {
    private final Map<String, String> docAttributes;
    private final Integer endColumn;
    private final Integer endLine;
    private final String fileName;
    private final URI fileUri;
    private final List<String> importLocationChain;
    private final ParserAttributesDTO parserAttributes;
    private final String sourceCode;
    private final Integer startColumn;
    private final Integer startLine;
    private transient List<ImportedResourceDTO> importChain;

    public ComponentMetadataAstDTO(Map<String, String> docAttributes, Integer endColumn, Integer endLine, String fileName, URI fileUri, List<String> importLocationChain, Map<String, Object> parserAttributes, String sourceCode, Integer startColumn, Integer startLine) {
        this.docAttributes = docAttributes;
        this.endColumn = endColumn;
        this.endLine = endLine;
        this.fileName = fileName;
        this.fileUri = fileUri;
        this.importLocationChain = importLocationChain;
        this.parserAttributes = new ParserAttributesDTO(parserAttributes);
        this.sourceCode = sourceCode;
        this.startColumn = startColumn;
        this.startLine = startLine;
    }

    ComponentMetadataAstDTO() {
        this(null, null, null, null, null, Collections.emptyList(), null, null, null, null);
    }

    public Optional<String> getFileName() {
        return Optional.ofNullable(this.fileName);
    }

    public Optional<URI> getFileUri() {
        return Optional.ofNullable(this.fileUri);
    }

    public List<ImportedResource> getImportChain() {
        return Collections.unmodifiableList(this.importChain);
    }

    public OptionalInt getStartLine() {
        return this.getOptionalInt(this.startLine);
    }

    public OptionalInt getStartColumn() {
        return this.getOptionalInt(this.startColumn);
    }

    public OptionalInt getEndLine() {
        return this.getOptionalInt(this.endLine);
    }

    public OptionalInt getEndColumn() {
        return this.getOptionalInt(this.endColumn);
    }

    public Optional<String> getSourceCode() {
        return Optional.ofNullable(this.sourceCode);
    }

    public Map<String, String> getDocAttributes() {
        return this.docAttributes;
    }

    public Map<String, Object> getParserAttributes() {
        return this.parserAttributes.get();
    }

    private OptionalInt getOptionalInt(Integer integer) {
        return integer != null ? OptionalInt.of(integer) : OptionalInt.empty();
    }

    public void enrich(Map<String, ImportedResourceDTO> importResourcesByRawLocation) {
        this.importChain = this.importLocationChain.stream().map(importResourcesByRawLocation::get).collect(Collectors.toList());
    }

    public void setPropertiesResolver(PropertiesResolver propertiesResolver) {
        this.importChain.forEach(imp -> imp.setPropertiesResolver(propertiesResolver));
    }
}

