/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.serialization.dto.factory;

import static java.util.Collections.unmodifiableCollection;
import static java.util.Collections.unmodifiableList;
import static java.util.Collections.unmodifiableSet;
import static java.util.stream.Collectors.toList;
import static java.util.stream.Collectors.toSet;

import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.internal.serialization.dto.ArtifactAstDTO;

public class ArtifactAstDTOFactory {

  private final AstDTOFactoryProvider astDTOFactoryProvider;

  public ArtifactAstDTOFactory(AstDTOFactoryProvider astDTOFactoryProvider) {
    this.astDTOFactoryProvider = astDTOFactoryProvider;
  }

  public ArtifactAstDTO from(ArtifactAst artifactAst) {
    return new ArtifactAstDTO(
                              artifactAst.getArtifactName(),
                              artifactAst.getArtifactType(),
                              unmodifiableSet(artifactAst
                                  .dependencies()
                                  .stream()
                                  .map(extensionModel -> astDTOFactoryProvider.getExtensionModelDTOFactory()
                                      .from(extensionModel))
                                  .collect(toSet())),
                              unmodifiableList(artifactAst
                                  .topLevelComponentsStream()
                                  .map(componentAst -> astDTOFactoryProvider.getComponentAstDTOFactory()
                                      .from(componentAst))
                                  .collect(toList())),
                              astDTOFactoryProvider
                                  .getErrorRepositoryDTOFactory()
                                  .from(artifactAst.getErrorTypeRepository()),
                              unmodifiableCollection(artifactAst
                                  .getImportedResources()
                                  .stream()
                                  .map(importedResource -> astDTOFactoryProvider.getImportedResourceDTOFactory()
                                      .from(importedResource))
                                  .collect(toList())));
  }
}
