/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.serialization.json.gson;

import org.mule.runtime.api.component.TypedComponentIdentifier.ComponentType;
import java.lang.reflect.Type;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;

/**
 * This class implements a Gson JsonSerializer and it can be registered to Gson as a Type Adapter in order to serialize
 * {@link org.mule.runtime.api.component.location.ComponentLocation}s
 */
public class ComponentTypeJsonSerializer implements JsonSerializer<ComponentType> {

  @Override
  public JsonElement serialize(ComponentType componentType, Type type, JsonSerializationContext jsonSerializationContext) {
    JsonObject jsonComponentType = new JsonObject();
    jsonComponentType.addProperty("name", componentType.name());

    return jsonComponentType;
  }
}
