/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.serialization.json.gson;

import static org.mule.runtime.api.component.ComponentIdentifier.builder;

import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.ComponentIdentifier.Builder;
import java.lang.reflect.Type;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;

/**
 * This class implements a Gson {@link JsonDeserializer} and it can be registered to Gson as a Type Adapter in order to
 * deserialize {@link ComponentIdentifier}s
 */
public class ComponentIdentifierJsonDeserializer implements JsonDeserializer<ComponentIdentifier> {

  @Override
  public ComponentIdentifier deserialize(JsonElement jsonElement, Type type,
                                         JsonDeserializationContext jsonDeserializationContext)
      throws JsonParseException {
    JsonObject jsonObject = jsonElement.getAsJsonObject();

    Builder builder = builder();
    JsonElement name = jsonObject.get("name");
    builder.name(name.getAsString());

    JsonElement namespace = jsonObject.get("namespace");
    builder.namespace(namespace.getAsString());

    JsonElement namespaceUri = jsonObject.get("namespaceUri");
    if (namespaceUri != null) {
      builder.namespaceUri(namespaceUri.getAsString()).build();
    }

    return builder.build();
  }
}
