/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.serialization.resolver;

import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.ast.internal.model.ExtensionModelHelper;
import org.mule.runtime.ast.internal.serialization.dto.ComponentAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentGenerationInformationDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentParameterAstDTO;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;

/**
 * Resolves the {@link ComponentGenerationInformationDTO}
 */
public class NoOpGenerationInformationResolver implements GenerationInformationResolver {

  /**
   * Resolves the {@link ComponentGenerationInformationDTO} of a {@link ComponentAstDTO}
   *
   *
   * @param ownerComponentParameterAst
   * @param componentAstDTO            the {@link ComponentAstDTO} whose {@link ComponentGenerationInformationDTO} needs to be
   *                                   resolved
   * @param extensionModelHelper
   * @return the resolved {@link ComponentGenerationInformationDTO}
   */
  @Override
  public ComponentGenerationInformationDTO resolveComponentAstGenerationInformation(ComponentParameterAstDTO ownerComponentParameterAst,
                                                                                    ComponentAstDTO componentAstDTO,
                                                                                    ExtensionModelHelper extensionModelHelper) {
    return null;
  }

  /**
   * Resolves the {@link ComponentGenerationInformationDTO} of a {@link ComponentParameterAstDTO}
   *
   * @param componentParameterAstDTO the {@link ComponentParameterAstDTO} whose {@link ComponentGenerationInformationDTO} needs to
   *                                 be resolved
   * @param ownerComponent           the owner {@link ComponentAstDTO}
   * @param extensionModelHelper
   * @return the resolved {@link ComponentGenerationInformationDTO}
   */
  @Override
  public ComponentGenerationInformationDTO resolveComponentParameterAstGenerationInformation(ComponentParameterAstDTO componentParameterAstDTO,
                                                                                             ComponentAstDTO ownerComponent,
                                                                                             ExtensionModelHelper extensionModelHelper) {
    return null;
  }

  @Override
  public ComponentGenerationInformationDTO resolveWrappedComponentParameterAstGenerationInformation(ComponentParameterAstDTO componentParameterAstDTO,
                                                                                                    ComponentAstDTO ownerComponent,
                                                                                                    ExtensionModelHelper extensionModelHelper) {
    return null;
  }

  @Override
  public ComponentGenerationInformationDTO resolveGenerationInformationThroughParent(String parameterName,
                                                                                     ComponentAstDTO component,
                                                                                     ParameterModel ownerParameterModel,
                                                                                     DslElementSyntax ownerComponentSyntax) {
    return null;
  }

  @Override
  public ComponentGenerationInformationDTO crateComponentGenerationInformationFromParent(ComponentAstDTO componentAstDTO,
                                                                                         ComponentParameterAstDTO componentParameterAstDTO) {
    return null;
  }

  @Override
  public ComponentGenerationInformationDTO resolveRegularComponentParameterAstGenerationInformation(ComponentParameterAstDTO componentParameterAstDTO,
                                                                                                    ComponentAstDTO ownerComponentAstDTO,
                                                                                                    ExtensionModelHelper extensionModelHelper) {
    return null;
  }

}
