/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.serialization.visitor;

import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.ast.api.serialization.ExtensionModelResolver;
import org.mule.runtime.ast.internal.model.ExtensionModelHelper;
import org.mule.runtime.ast.internal.serialization.dto.ComponentAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentParameterAstDTO;
import org.mule.runtime.ast.internal.serialization.resolver.GenerationInformationResolver;

import java.util.List;

/**
 * Visits SimpleTypes and uses them to resolve the models of a list of {@link ComponentAstDTO}s
 */
public class SimpleTypeComponentMetadataTypeVisitor extends MetadataTypeVisitor {

  private final ExtensionModelHelper extensionModelHelper;
  private final GenerationInformationResolver generationInformationResolver;
  private final ExtensionModelResolver extensionModelResolver;
  private final ComponentParameterAstDTO ownerComponentParameterAst;

  public SimpleTypeComponentMetadataTypeVisitor(ComponentParameterAstDTO componentParameterAstDTO,
                                                ExtensionModelHelper extensionModelHelper,
                                                GenerationInformationResolver generationInformationResolver,
                                                ExtensionModelResolver extensionModelResolver) {
    this.extensionModelHelper = extensionModelHelper;
    this.ownerComponentParameterAst = componentParameterAstDTO;
    this.generationInformationResolver = generationInformationResolver;
    this.extensionModelResolver = extensionModelResolver;
  }

  @Override
  public void visitSimpleType(SimpleType simpleType) {
    List<ComponentAstDTO> componentAstDTOList = (List<ComponentAstDTO>) ownerComponentParameterAst.getValue().getRight();

    componentAstDTOList.forEach(componentAstDTO -> componentAstDTO
        .resolveSimpleTypeComponentModel(this.ownerComponentParameterAst, simpleType, this.extensionModelResolver,
                                         this.extensionModelHelper, this.generationInformationResolver));
  }

}
