/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.testobjects;

import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class DummyConnectionProviderModel implements ConnectionProviderModel {

  private final String name;
  private final List<ParameterGroupModel> parameterGroupModels;

  public DummyConnectionProviderModel(String name, List<ParameterGroupModel> parameterGroupModels) {
    this.name = name;
    this.parameterGroupModels = parameterGroupModels;
  }

  @Override
  public ConnectionManagementType getConnectionManagementType() {
    return null;
  }

  @Override
  public boolean supportsConnectivityTesting() {
    return false;
  }

  @Override
  public List<ParameterGroupModel> getParameterGroupModels() {
    return parameterGroupModels;
  }

  @Override
  public String getDescription() {
    return "Dummy connection provider";
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public <T extends ModelProperty> Optional<T> getModelProperty(Class<T> aClass) {
    return Optional.empty();
  }

  @Override
  public Set<ModelProperty> getModelProperties() {
    return new HashSet<>();
  }

  @Override
  public Set<ExternalLibraryModel> getExternalLibraryModels() {
    return new HashSet<>();
  }

  @Override
  public Optional<DeprecationModel> getDeprecationModel() {
    return Optional.empty();
  }

  @Override
  public Optional<DisplayModel> getDisplayModel() {
    return Optional.empty();
  }

  @Override
  public StereotypeModel getStereotype() {
    return null;
  }
}
