/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.testobjects;

import static java.util.Collections.emptyList;
import static java.util.Collections.emptySet;
import static java.util.Optional.empty;

import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;

import java.util.List;
import java.util.Optional;
import java.util.Set;

public class DummyExtensionModel implements ExtensionModel {

  private final List<SourceModel> sourceModels;
  private final List<ConstructModel> constructModels;
  private final XmlDslModel dslModel;
  private final String name;
  private final List<OperationModel> operationModels;
  private final List<ConfigurationModel> configurationModels;
  private final List<ConnectionProviderModel> connectionProviderModels;

  public DummyExtensionModel() {
    this("extension model default name");
  }

  public DummyExtensionModel(String name) {
    this(name, emptyList(), emptyList(), emptyList(), emptyList(), emptyList());
  }

  public DummyExtensionModel(String name, List<OperationModel> operationModels, List<ConfigurationModel> configurationModels,
                             List<SourceModel> sourceModels, List<ConstructModel> constructModels,
                             List<ConnectionProviderModel> connectionProviderModels) {
    this.name = name;
    this.dslModel = XmlDslModel.builder().setPrefix(name).build();
    this.operationModels = operationModels;
    this.configurationModels = configurationModels;
    this.sourceModels = sourceModels;
    this.constructModels = constructModels;
    this.connectionProviderModels = connectionProviderModels;
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public String getVersion() {
    return null;
  }

  @Override
  public List<ConfigurationModel> getConfigurationModels() {
    return configurationModels;
  }

  @Override
  public Optional<ConfigurationModel> getConfigurationModel(String name) {
    return configurationModels.stream().filter(x -> x.getName().equals(name)).findFirst();
  }

  @Override
  public List<OperationModel> getOperationModels() {
    return operationModels;
  }

  @Override
  public List<ConnectionProviderModel> getConnectionProviders() {
    return connectionProviderModels;
  }

  @Override
  public List<SourceModel> getSourceModels() {
    return sourceModels;
  }

  @Override
  public Set<ObjectType> getTypes() {
    return emptySet();
  }

  @Override
  public Set<String> getResources() {
    return emptySet();
  }

  @Override
  public Set<String> getPrivilegedPackages() {
    return emptySet();
  }

  @Override
  public Set<String> getPrivilegedArtifacts() {
    return emptySet();
  }

  @Override
  public String getVendor() {
    return "dummy vendor";
  }

  @Override
  public Category getCategory() {
    return null;
  }

  @Override
  public XmlDslModel getXmlDslModel() {
    return dslModel;
  }

  @Override
  public Set<SubTypesModel> getSubTypes() {
    return emptySet();
  }

  @Override
  public Set<ImportedTypeModel> getImportedTypes() {
    return emptySet();
  }

  @Override
  public Set<ErrorModel> getErrorModels() {
    return emptySet();
  }

  @Override
  public Set<NotificationModel> getNotificationModels() {
    return emptySet();
  }

  @Override
  public Optional<ComponentModel> findComponentModel(String componentName) {
    return empty();
  }

  @Override
  public Optional<ArtifactCoordinates> getArtifactCoordinates() {
    return empty();
  }

  @Override
  public String getDescription() {
    return "A dummy extension model for testing";
  }

  @Override
  public <T extends ModelProperty> Optional<T> getModelProperty(Class<T> propertyType) {
    return empty();
  }

  @Override
  public Set<ModelProperty> getModelProperties() {
    return emptySet();
  }

  @Override
  public Set<ExternalLibraryModel> getExternalLibraryModels() {
    return emptySet();
  }

  @Override
  public Optional<ConnectionProviderModel> getConnectionProviderModel(String name) {
    return this.getConnectionProviders().stream().filter(x -> x.getName().equals(name)).findFirst();
  }

  @Override
  public List<ConstructModel> getConstructModels() {
    return constructModels;
  }

  @Override
  public Optional<ConstructModel> getConstructModel(String name) {
    return this.getConstructModels().stream().filter(x -> x.getName().equals(name)).findFirst();
  }

  @Override
  public Optional<DeprecationModel> getDeprecationModel() {
    return empty();
  }

  @Override
  public Optional<DisplayModel> getDisplayModel() {
    return empty();
  }

  @Override
  public List<FunctionModel> getFunctionModels() {
    return emptyList();
  }

  @Override
  public Optional<FunctionModel> getFunctionModel(String name) {
    return empty();
  }

  @Override
  public Optional<OperationModel> getOperationModel(String name) {
    return this.getOperationModels().stream().filter(x -> x.getName().equals(name)).findFirst();
  }

  @Override
  public Optional<SourceModel> getSourceModel(String name) {
    return this.getSourceModels().stream().filter(x -> x.getName().equals(name)).findFirst();
  }

}
