/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.testobjects;

import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ExclusiveParametersModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class DummyParameterGroupModel implements ParameterGroupModel {

  private final List<ParameterModel> parameterModels;
  private final String name;

  public DummyParameterGroupModel() {
    this("parameter group default name", new ArrayList<>());
  }

  public DummyParameterGroupModel(String name, List<ParameterModel> parameterModels) {
    this.name = name;
    this.parameterModels = parameterModels;
  }

  @Override
  public List<ParameterModel> getParameterModels() {
    return parameterModels;
  }

  @Override
  public List<ExclusiveParametersModel> getExclusiveParametersModels() {
    return new ArrayList<>();
  }

  @Override
  public Optional<ParameterModel> getParameter(String s) {
    return Optional.empty();
  }

  @Override
  public boolean isShowInDsl() {
    return false;
  }

  @Override
  public String getDescription() {
    return "Dummy group model description";
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public <T extends ModelProperty> Optional<T> getModelProperty(Class<T> aClass) {
    return Optional.empty();
  }

  @Override
  public Set<ModelProperty> getModelProperties() {
    return new HashSet<>();
  }

  @Override
  public Optional<DisplayModel> getDisplayModel() {
    return Optional.empty();
  }

  @Override
  public Optional<LayoutModel> getLayoutModel() {
    return Optional.empty();
  }
}
