/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.testobjects;

import static java.lang.String.format;

import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.serialization.ExtensionModelResolver;
import java.util.Set;

public class TestExtensionModelResolver implements ExtensionModelResolver {

  private final Set<ExtensionModel> extensionModels;

  public TestExtensionModelResolver(Set<ExtensionModel> extensionModels) {
    this.extensionModels = extensionModels;
  }

  @Override
  public ExtensionModel resolve(String name) throws IllegalArgumentException {
    return this.extensionModels.stream().filter(em -> em.getName().equals(name)).findFirst()
        .orElseThrow(() -> new IllegalArgumentException(format("Extension model '%s' could not be resolved", name)));
  }
}
