/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.serialization.dto;

import java.util.Map;

/**
 * Wrapper over parser attributes for customizable serialization/deserialization.
 */
public class ParserAttributesDTO {

  private final Map<String, Object> parserAttributes;

  public ParserAttributesDTO(Map<String, Object> parserAttributes) {
    this.parserAttributes = parserAttributes;
  }

  public Map<String, Object> get() {
    return parserAttributes;
  }
}
