/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.api.serialization;

import org.mule.runtime.api.meta.model.ExtensionModel;

/**
 * Implementations define the way that {@link ExtensionModel}s must be resolved when deserializing.
 */
public interface ExtensionModelResolver {

  /**
   * Given an {@link ExtensionModel} name, this method returns an instance
   * 
   * @param name the name identifying an {@link ExtensionModel}
   * @return the {@link ExtensionModel}
   * @throws IllegalArgumentException if an {@link ExtensionModel} with the provided name cannot be resolved
   */
  ExtensionModel resolve(String name) throws IllegalArgumentException;

}
