/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.serialization.dto.factory;

import static java.util.Collections.unmodifiableList;
import static java.util.Collections.unmodifiableMap;
import static java.util.stream.Collectors.toList;

import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.internal.serialization.dto.ComponentMetadataAstDTO;

public class ComponentMetadataAstDTOFactory {

  private final AstDTOFactoryProvider astDTOFactoryProvider;

  public ComponentMetadataAstDTOFactory(AstDTOFactoryProvider astDTOFactoryProvider) {
    this.astDTOFactoryProvider = astDTOFactoryProvider;
  }

  public ComponentMetadataAstDTO from(ComponentMetadataAst metadata) {
    return new ComponentMetadataAstDTO(
                                       metadata.getDocAttributes() != null
                                           ? unmodifiableMap(metadata.getDocAttributes())
                                           : null,
                                       metadata.getEndColumn().isPresent()
                                           ? metadata.getEndColumn().getAsInt()
                                           : null,
                                       metadata.getEndLine().isPresent()
                                           ? metadata.getEndLine().getAsInt()
                                           : null,
                                       metadata.getFileName().orElse(null),
                                       metadata.getFileUri().orElse(null),
                                       unmodifiableList(metadata
                                           .getImportChain()
                                           .stream()
                                           .map(ImportedResource::getRawResourceLocation)
                                           .collect(toList())),
                                       metadata.getParserAttributes() != null
                                           ? unmodifiableMap(metadata.getParserAttributes())
                                           : null,
                                       metadata.getSourceCode().orElse(null),
                                       metadata.getStartColumn().isPresent()
                                           ? metadata.getStartColumn().getAsInt()
                                           : null,
                                       metadata.getStartLine().isPresent()
                                           ? metadata.getStartLine().getAsInt()
                                           : null);
  }
}
