/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.serialization.dto;

import static java.util.Optional.ofNullable;

import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import java.util.Optional;

/**
 * This is a serializable form of a {@link ComponentGenerationInformation}
 */
public class ComponentGenerationInformationDTO implements ComponentGenerationInformation {

  private transient final DslElementSyntax syntax;

  public ComponentGenerationInformationDTO(DslElementSyntax syntax) {
    this.syntax = syntax;
  }

  @Override
  public Optional<DslElementSyntax> getSyntax() {
    return ofNullable(this.syntax);
  }

}
