/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.serialization.dto.factory;

import static org.mule.runtime.ast.AllureConstants.ArtifactAstSerialization.AST_DTO;
import static org.mule.runtime.ast.AllureConstants.ArtifactAstSerialization.AST_SERIALIZATION;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;

import org.mule.runtime.ast.testobjects.DummyExtensionModel;
import org.mule.runtime.ast.internal.serialization.dto.ExtensionModelDTO;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.junit.Before;
import org.junit.Test;

@Feature(AST_SERIALIZATION)
@Story(AST_DTO)
public class ExtensionModelDTOFactoryTestCase {

  private ExtensionModelDTOFactory extensionModelDTOFactory;

  @Before
  public void setUp() throws Exception {
    extensionModelDTOFactory = new ExtensionModelDTOFactory();
  }

  @Test
  public void testBuildFromExtensionModelSetsNameRick_WhenBuildingDTOForRickExtensionModel() {
    // Given
    DummyExtensionModel extensionModel = new DummyExtensionModel() {

      @Override
      public String getName() {
        return "Rick";
      }
    };

    // When
    ExtensionModelDTO extensionModelDTO = extensionModelDTOFactory.from(extensionModel);

    // Then
    assertThat(extensionModelDTO.getName(), is(extensionModel.getName()));
  }

  @Test
  public void testBuildFromExtensionModelSetsNameRobert_WhenBuildingDTOForRobertExtensionModel() {
    // Given
    DummyExtensionModel extensionModel = new DummyExtensionModel() {

      @Override
      public String getName() {
        return "Robert";
      }
    };

    // When
    ExtensionModelDTO extensionModelDTO = extensionModelDTOFactory.from(extensionModel);

    // Then
    assertThat(extensionModelDTO.getName(), is(extensionModel.getName()));
  }

}
