/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.testobjects;

import static org.mule.runtime.api.meta.model.ComponentVisibility.PUBLIC;

import org.mule.runtime.api.meta.model.ComponentVisibility;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class DummyOperationModel implements OperationModel {

  private final String name;
  private final List<ParameterGroupModel> parameterGroupModels;

  public DummyOperationModel() {
    this("operation model default name", new ArrayList<>());
  }

  public DummyOperationModel(String name, List<ParameterGroupModel> parameterGroupModels) {
    this.name = name;
    this.parameterGroupModels = parameterGroupModels;
  }

  @Override
  public boolean isBlocking() {
    return false;
  }

  @Override
  public ExecutionType getExecutionType() {
    return null;
  }

  @Override
  public boolean isTransactional() {
    return false;
  }

  @Override
  public boolean requiresConnection() {
    return false;
  }

  @Override
  public boolean supportsStreaming() {
    return false;
  }

  @Override
  public List<? extends NestableElementModel> getNestedComponents() {
    return new ArrayList<>();
  }

  @Override
  public <T extends ModelProperty> Optional<T> getModelProperty(Class<T> aClass) {
    return Optional.empty();
  }

  @Override
  public Set<ModelProperty> getModelProperties() {
    return null;
  }

  @Override
  public OutputModel getOutput() {
    return null;
  }

  @Override
  public OutputModel getOutputAttributes() {
    return null;
  }

  @Override
  public Optional<DeprecationModel> getDeprecationModel() {
    return Optional.empty();
  }

  @Override
  public Optional<DisplayModel> getDisplayModel() {
    return Optional.empty();
  }

  @Override
  public Set<ErrorModel> getErrorModels() {
    return new HashSet<>();
  }

  @Override
  public Set<NotificationModel> getNotificationModels() {
    return new HashSet<>();
  }

  @Override
  public List<ParameterGroupModel> getParameterGroupModels() {
    return parameterGroupModels;
  }

  @Override
  public String getDescription() {
    return "Dummy operation model description";
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public StereotypeModel getStereotype() {
    return null;
  }

  @Override
  public ComponentVisibility getVisibility() {
    return PUBLIC;
  }
}
