/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast;

import com.google.common.collect.Streams;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.DependencyResolutionMode;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.api.serialization.ArtifactAstDeserializer;
import org.mule.runtime.ast.api.serialization.ArtifactAstSerializer;
import org.mule.runtime.ast.api.serialization.ArtifactAstSerializerProvider;
import org.mule.runtime.ast.api.serialization.ExtensionModelResolver;
import org.mule.runtime.ast.testobjects.TestArtifactAstFactory;
import org.mule.runtime.ast.testobjects.TestExtensionModelResolver;

@Feature(value="AST serialization")
@Story(value="AST serialization end to end tests")
public class ArtifactAstSerializationTestCase {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private ArtifactAstSerializerProvider artifactAstSerializerProvider;
    private TestArtifactAstFactory testArtifactAstFactory;
    private ExtensionModelResolver extensionModelResolver;
    private Set<ExtensionModel> extensionModels;

    @Before
    public void setUp() throws Exception {
        this.artifactAstSerializerProvider = new ArtifactAstSerializerProvider();
        this.testArtifactAstFactory = new TestArtifactAstFactory();
        this.extensionModels = this.testArtifactAstFactory.extensionModelsSetForTests();
        this.extensionModelResolver = new TestExtensionModelResolver(this.extensionModels);
    }

    @After
    public void tearDown() {
        System.clearProperty("mule." + DependencyResolutionMode.class.getName());
    }

    @Test
    public void testSerializationOfTrivialAppJsonImplementation() throws IOException {
        ArtifactAstSerializer artifactAstSerializer = this.artifactAstSerializerProvider.getSerializer("JSON", "1.0");
        ArtifactAst trivialArtifactAst = this.testArtifactAstFactory.createArtifactFromXmlFile("test-apps/trivial.xml", this.extensionModels);
        InputStream serializedArtifactAst = artifactAstSerializer.serialize(trivialArtifactAst);
        String jsonString = IOUtils.toString((Reader)new InputStreamReader(serializedArtifactAst));
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.containsString((String)"JSON#1.0"));
    }

    @Test
    public void testSerializationOfSimpleHttpAppJsonImplementation() throws IOException {
        ArtifactAstSerializer artifactAstSerializer = this.artifactAstSerializerProvider.getSerializer("JSON", "1.0");
        ArtifactAst simpleHttpArtifactAst = this.testArtifactAstFactory.createArtifactFromXmlFile("test-apps/http-listener-with-logger.xml", this.extensionModels);
        InputStream serializedArtifactAst = artifactAstSerializer.serialize(simpleHttpArtifactAst);
        String jsonString = IOUtils.toString((Reader)new InputStreamReader(serializedArtifactAst));
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.containsString((String)"JSON#1.0"));
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.containsString((String)"/test"));
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.containsString((String)"HTTP_Listener_config"));
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.containsString((String)"8081"));
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.containsString((String)"INFO"));
    }

    @Test
    public void testSerializationOfImportedSimpleHttpAppJsonImplementation() throws IOException {
        ArtifactAstSerializer artifactAstSerializer = this.artifactAstSerializerProvider.getSerializer("JSON", "1.0");
        ArtifactAst simpleHttpArtifactAst = this.testArtifactAstFactory.createArtifactFromXmlFile("test-apps/imports-http-listener-with-logger.xml", this.extensionModels);
        InputStream serializedArtifactAst = artifactAstSerializer.serialize(simpleHttpArtifactAst);
        String jsonString = IOUtils.toString((Reader)new InputStreamReader(serializedArtifactAst));
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.containsString((String)"JSON#1.0"));
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.containsString((String)"/test"));
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.containsString((String)"HTTP_Listener_config"));
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.containsString((String)"8081"));
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.containsString((String)"INFO"));
    }

    @Test
    public void testSerializationOfUnresolvableImportJsonImplementation() throws IOException {
        ArtifactAstSerializer artifactAstSerializer = this.artifactAstSerializerProvider.getSerializer("JSON", "1.0");
        ArtifactAst simpleHttpArtifactAst = this.testArtifactAstFactory.createArtifactFromXmlFile("test-apps/failing-imports.xml", this.extensionModels);
        InputStream serializedArtifactAst = artifactAstSerializer.serialize(simpleHttpArtifactAst);
        String jsonString = IOUtils.toString((Reader)new InputStreamReader(serializedArtifactAst));
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.containsString((String)"JSON#1.0"));
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.containsString((String)"Could not find imported resource \\u0027unresolvable.xml\\u0027"));
    }

    @Test
    public void testSerializationDeserializationOfTrivialAppJsonImplementation() throws IOException {
        ArtifactAstSerializer artifactAstSerializer = this.artifactAstSerializerProvider.getSerializer("JSON", "1.0");
        ArtifactAst trivialArtifactAst = this.testArtifactAstFactory.createArtifactFromXmlFile("test-apps/trivial.xml", this.extensionModels);
        InputStream serializedArtifactAst = artifactAstSerializer.serialize(trivialArtifactAst);
        ArtifactAst artifactAst = this.artifactAstSerializerProvider.getDeserializer().deserialize(serializedArtifactAst, this.extensionModelResolver);
        MatcherAssert.assertThat((Object)artifactAst.topLevelComponentsStream().count(), (Matcher)Matchers.is((Object)trivialArtifactAst.topLevelComponentsStream().count()));
        MatcherAssert.assertThat((Object)artifactAst.dependencies().size(), (Matcher)Matchers.is((Object)trivialArtifactAst.dependencies().stream().map(ExtensionModel::getName).collect(Collectors.toSet()).size()));
        MatcherAssert.assertThat((Object)artifactAst.getErrorTypeRepository().getErrorTypes().size(), (Matcher)Matchers.is((Object)trivialArtifactAst.getErrorTypeRepository().getErrorTypes().size()));
    }

    @Test
    public void testSerializationDeserializationOfSimpleHttpAppJsonImplementation() throws IOException {
        ArtifactAstSerializer artifactAstSerializer = this.artifactAstSerializerProvider.getSerializer("JSON", "1.0");
        ArtifactAst simpleHttpArtifactAst = this.testArtifactAstFactory.createArtifactFromXmlFile("test-apps/http-listener-with-logger.xml", this.extensionModels);
        InputStream serializedArtifactAst = artifactAstSerializer.serialize(simpleHttpArtifactAst);
        ArtifactAstDeserializer deserializer = this.artifactAstSerializerProvider.getDeserializer();
        ArtifactAst artifactAst = deserializer.deserialize(serializedArtifactAst, this.extensionModelResolver);
        MatcherAssert.assertThat((Object)artifactAst.topLevelComponentsStream().count(), (Matcher)Matchers.is((Object)simpleHttpArtifactAst.topLevelComponentsStream().count()));
        MatcherAssert.assertThat((Object)artifactAst.dependencies().size(), (Matcher)Matchers.is((Object)simpleHttpArtifactAst.dependencies().stream().map(ExtensionModel::getName).collect(Collectors.toSet()).size()));
        List<ComponentParameterAst> componentParameterAstStream = artifactAst.topLevelComponentsStream().flatMap(componentAst -> componentAst.getParameters().stream()).collect(Collectors.toList());
        MatcherAssert.assertThat(componentParameterAstStream, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        componentParameterAstStream.forEach(componentParameterAst -> MatcherAssert.assertThat((Object)componentParameterAst.getModel(), (Matcher)Matchers.notNullValue(ParameterModel.class)));
    }

    @Test
    public void testSerializationDeserializationOfSimpleHttpAppJsonImplementationKeepsComponentMetadataAstEquivalent() throws IOException {
        ArtifactAstSerializer artifactAstSerializer = this.artifactAstSerializerProvider.getSerializer("JSON", "1.0");
        ArtifactAst simpleHttpArtifactAst = this.testArtifactAstFactory.createArtifactFromXmlFile("test-apps/http-listener-with-logger.xml", this.extensionModels);
        InputStream serializedArtifactAst = artifactAstSerializer.serialize(simpleHttpArtifactAst);
        ArtifactAstDeserializer deserializer = this.artifactAstSerializerProvider.getDeserializer();
        ArtifactAst artifactAst = deserializer.deserialize(serializedArtifactAst, this.extensionModelResolver);
        MatcherAssert.assertThat((Object)artifactAst.topLevelComponentsStream().count(), (Matcher)Matchers.is((Object)simpleHttpArtifactAst.topLevelComponentsStream().count()));
        Streams.forEachPair(artifactAst.recursiveStream().map(ComponentAst::getMetadata), simpleHttpArtifactAst.recursiveStream().map(ComponentAst::getMetadata), this::assertComponentMetadataAstEqual);
    }

    @Test
    @Issue(value="MULE-19775")
    public void testSerializationToFileAndDeserializationOfSimpleHttpAppJsonImplementationKeepsComponentMetadataAstEquivalent() throws IOException {
        ArtifactAstSerializer artifactAstSerializer = this.artifactAstSerializerProvider.getSerializer("JSON", "1.0");
        ArtifactAst simpleHttpArtifactAst = this.testArtifactAstFactory.createArtifactFromXmlFile("test-apps/http-listener-with-logger.xml", this.extensionModels);
        InputStream serializedArtifactAst = artifactAstSerializer.serialize(simpleHttpArtifactAst);
        File file = this.folder.newFile("http-listener-artifact.ast");
        FileUtils.copyInputStreamToFile((InputStream)serializedArtifactAst, (File)file);
        ArtifactAstDeserializer deserializer = this.artifactAstSerializerProvider.getDeserializer();
        FileInputStream targetStream = new FileInputStream(file);
        ArtifactAst artifactAst = deserializer.deserialize((InputStream)targetStream, this.extensionModelResolver);
        MatcherAssert.assertThat((Object)artifactAst.topLevelComponentsStream().count(), (Matcher)Matchers.is((Object)simpleHttpArtifactAst.topLevelComponentsStream().count()));
        Streams.forEachPair(artifactAst.recursiveStream().map(ComponentAst::getMetadata), simpleHttpArtifactAst.recursiveStream().map(ComponentAst::getMetadata), this::assertComponentMetadataAstEqual);
    }

    private void assertComponentMetadataAstEqual(ComponentMetadataAst actual, ComponentMetadataAst expected) {
        MatcherAssert.assertThat((Object)actual.getDocAttributes(), (Matcher)CoreMatchers.equalTo((Object)expected.getDocAttributes()));
        MatcherAssert.assertThat((Object)actual.getParserAttributes(), (Matcher)CoreMatchers.equalTo((Object)expected.getParserAttributes()));
        MatcherAssert.assertThat((Object)actual.getFileName(), (Matcher)CoreMatchers.equalTo((Object)expected.getFileName()));
        MatcherAssert.assertThat((Object)actual.getFileUri(), (Matcher)CoreMatchers.equalTo((Object)expected.getFileUri()));
        MatcherAssert.assertThat((Object)actual.getSourceCode(), (Matcher)CoreMatchers.equalTo((Object)expected.getSourceCode()));
        MatcherAssert.assertThat((Object)actual.getStartColumn(), (Matcher)CoreMatchers.equalTo((Object)expected.getStartColumn()));
        MatcherAssert.assertThat((Object)actual.getStartLine(), (Matcher)CoreMatchers.equalTo((Object)expected.getStartLine()));
        MatcherAssert.assertThat((Object)actual.getEndColumn(), (Matcher)CoreMatchers.equalTo((Object)expected.getEndColumn()));
        MatcherAssert.assertThat((Object)actual.getEndLine(), (Matcher)CoreMatchers.equalTo((Object)expected.getEndLine()));
    }

    @Test
    public void testSerializationDeserializationOfImportChain() throws IOException {
        ArtifactAstSerializer artifactAstSerializer = this.artifactAstSerializerProvider.getSerializer("JSON", "1.0");
        ArtifactAst simpleHttpArtifactAst = this.testArtifactAstFactory.createArtifactFromXmlFile("test-apps/imports-http-listener-with-logger.xml", this.extensionModels);
        InputStream serializedArtifactAst = artifactAstSerializer.serialize(simpleHttpArtifactAst);
        ArtifactAstDeserializer deserializer = this.artifactAstSerializerProvider.getDeserializer();
        ArtifactAst artifactAst = deserializer.deserialize(serializedArtifactAst, this.extensionModelResolver);
        MatcherAssert.assertThat((Object)artifactAst.topLevelComponentsStream().count(), (Matcher)Matchers.is((Object)simpleHttpArtifactAst.topLevelComponentsStream().count()));
        MatcherAssert.assertThat((Object)artifactAst.dependencies().size(), (Matcher)Matchers.is((Object)simpleHttpArtifactAst.dependencies().stream().map(ExtensionModel::getName).collect(Collectors.toSet()).size()));
        List componentAstStream = artifactAst.topLevelComponents();
        componentAstStream.forEach(componentAst -> {
            List componentImportChain = componentAst.getMetadata().getImportChain();
            MatcherAssert.assertThat((Object)componentImportChain, (Matcher)IsCollectionWithSize.hasSize((int)1));
            MatcherAssert.assertThat((Object)((ImportedResource)componentImportChain.get(0)).getResourceLocation(), (Matcher)Matchers.is((Object)"test-apps/http-listener-with-logger.xml"));
            MatcherAssert.assertThat(((ImportedResource)componentImportChain.get(0)).getMetadata().getFileName().get(), (Matcher)Matchers.is((Object)"test-apps/imports-http-listener-with-logger.xml"));
            MatcherAssert.assertThat((Object)((URI)((ImportedResource)componentImportChain.get(0)).getMetadata().getFileUri().get()).toString(), (Matcher)Matchers.allOf((Matcher)Matchers.startsWith((String)"file:/"), (Matcher)Matchers.endsWith((String)"test-apps/imports-http-listener-with-logger.xml")));
        });
    }

    @Test
    public void testSerializationDeserializationOfAppWithDescriptions() throws IOException {
        ArtifactAstSerializer artifactAstSerializer = this.artifactAstSerializerProvider.getSerializer("JSON", "1.0");
        ArtifactAst trivialArtifactAst = this.testArtifactAstFactory.createArtifactFromXmlFile("test-apps/with-descriptions.xml", this.extensionModels);
        InputStream serializedArtifactAst = artifactAstSerializer.serialize(trivialArtifactAst);
        ArtifactAst artifactAst = this.artifactAstSerializerProvider.getDeserializer().deserialize(serializedArtifactAst, this.extensionModelResolver);
        MatcherAssert.assertThat((Object)artifactAst.topLevelComponentsStream().count(), (Matcher)Matchers.is((Object)trivialArtifactAst.topLevelComponentsStream().count()));
        MatcherAssert.assertThat((Object)artifactAst.dependencies().size(), (Matcher)Matchers.is((Object)trivialArtifactAst.dependencies().stream().map(ExtensionModel::getName).collect(Collectors.toSet()).size()));
        MatcherAssert.assertThat((Object)artifactAst.getErrorTypeRepository().getErrorTypes().size(), (Matcher)Matchers.is((Object)trivialArtifactAst.getErrorTypeRepository().getErrorTypes().size()));
    }

    @Test
    @Issue(value="MULE-19818")
    public void testSerializationDeserializationOfLocationFileCoordinates() throws IOException {
        ArtifactAstSerializer artifactAstSerializer = this.artifactAstSerializerProvider.getSerializer("JSON", "1.0");
        ArtifactAst simpleHttpArtifactAst = this.testArtifactAstFactory.createArtifactFromXmlFile("test-apps/imports-http-listener-with-logger.xml", this.extensionModels);
        InputStream serializedArtifactAst = artifactAstSerializer.serialize(simpleHttpArtifactAst);
        ArtifactAstDeserializer deserializer = this.artifactAstSerializerProvider.getDeserializer();
        ArtifactAst artifactAst = deserializer.deserialize(serializedArtifactAst, this.extensionModelResolver);
        ComponentAst httpListenerConfig = (ComponentAst)artifactAst.topLevelComponents().get(0);
        MatcherAssert.assertThat((Object)httpListenerConfig.getLocation().getLine().getAsInt(), (Matcher)Matchers.is((Object)6));
        MatcherAssert.assertThat((Object)httpListenerConfig.getLocation().getColumn().getAsInt(), (Matcher)Matchers.is((Object)5));
        ComponentAst listenerConnection = (ComponentAst)httpListenerConfig.directChildren().get(0);
        MatcherAssert.assertThat((Object)listenerConnection.getLocation().getLine().getAsInt(), (Matcher)Matchers.is((Object)7));
        MatcherAssert.assertThat((Object)listenerConnection.getLocation().getColumn().getAsInt(), (Matcher)Matchers.is((Object)9));
        ComponentAst flow = (ComponentAst)artifactAst.topLevelComponents().get(1);
        MatcherAssert.assertThat((Object)flow.getLocation().getLine().getAsInt(), (Matcher)Matchers.is((Object)9));
        MatcherAssert.assertThat((Object)flow.getLocation().getColumn().getAsInt(), (Matcher)Matchers.is((Object)5));
        ComponentAst listenerSource = (ComponentAst)flow.directChildren().get(0);
        MatcherAssert.assertThat((Object)listenerSource.getLocation().getLine().getAsInt(), (Matcher)Matchers.is((Object)10));
        MatcherAssert.assertThat((Object)listenerSource.getLocation().getColumn().getAsInt(), (Matcher)Matchers.is((Object)9));
        ComponentAst logger = (ComponentAst)flow.directChildren().get(1);
        MatcherAssert.assertThat((Object)logger.getLocation().getLine().getAsInt(), (Matcher)Matchers.is((Object)11));
        MatcherAssert.assertThat((Object)logger.getLocation().getColumn().getAsInt(), (Matcher)Matchers.is((Object)9));
    }

    @Test
    @Issue(value="MULE-19826")
    public void testProcessorsPartPath() throws IOException {
        ArtifactAstSerializer artifactAstSerializer = this.artifactAstSerializerProvider.getSerializer("JSON", "1.0");
        ArtifactAst simpleHttpArtifactAst = this.testArtifactAstFactory.createArtifactFromXmlFile("test-apps/imports-http-listener-with-logger.xml", this.extensionModels);
        InputStream serializedArtifactAst = artifactAstSerializer.serialize(simpleHttpArtifactAst);
        ArtifactAstDeserializer deserializer = this.artifactAstSerializerProvider.getDeserializer();
        ArtifactAst artifactAst = deserializer.deserialize(serializedArtifactAst, this.extensionModelResolver);
        ComponentAst flow = (ComponentAst)artifactAst.topLevelComponents().get(1);
        ComponentAst logger = (ComponentAst)flow.directChildren().get(1);
        LocationPart processorsLocationPart = (LocationPart)logger.getLocation().getParts().get(1);
        MatcherAssert.assertThat((Object)processorsLocationPart.getPartPath(), (Matcher)Matchers.is((Object)"processors"));
        MatcherAssert.assertThat((Object)processorsLocationPart.getPartIdentifier(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)processorsLocationPart.getFileName(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)processorsLocationPart.getLine(), (Matcher)Matchers.is((Object)OptionalInt.empty()));
        MatcherAssert.assertThat((Object)processorsLocationPart.getColumn(), (Matcher)Matchers.is((Object)OptionalInt.empty()));
    }

    @Test
    @Issue(value="MULE-19850")
    public void serializeWithCustomRependencyResolutionModeFails() {
        System.setProperty("mule." + DependencyResolutionMode.class.getName(), DependencyResolutionMode.MINIMAL.name());
        ArtifactAstSerializer artifactAstSerializer = this.artifactAstSerializerProvider.getSerializer("JSON", "1.0");
        ArtifactAst trivialArtifactAst = this.testArtifactAstFactory.createArtifactFromXmlFile("test-apps/trivial.xml", this.extensionModels);
        Assert.assertThrows((String)"Artifact AST serialization with `DependencyResolutionMode != COMPILE` would have limited usability when deserialized.", IllegalStateException.class, () -> artifactAstSerializer.serialize(trivialArtifactAst));
    }
}

