/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.api.serialization;

import io.qameta.allure.Feature;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.ast.api.serialization.ArtifactAstDeserializer;
import org.mule.runtime.ast.api.serialization.ArtifactAstSerializerProvider;
import org.mule.runtime.ast.internal.serialization.ArtifactAstSerializerFactory;
import org.mule.runtime.ast.internal.serialization.DefaultArtifactAstDeserializer;

@Feature(value="AST serialization")
public class ArtifactAstSerializerProviderTestCase {
    private ArtifactAstSerializerProvider artifactAstSerializerProvider;
    private ArtifactAstSerializerFactory artifactAstSerializerFactory;

    @Before
    public void setUp() {
        this.artifactAstSerializerFactory = (ArtifactAstSerializerFactory)Mockito.mock(ArtifactAstSerializerFactory.class);
        this.artifactAstSerializerProvider = new ArtifactAstSerializerProvider(this.artifactAstSerializerFactory);
    }

    @Test
    public void testGetSerializerCallsSerializerFactoryGetSerializerWithJSONParam_WhenGettingAJsonSerializer() {
        String format = "JSON";
        this.artifactAstSerializerProvider.getSerializer(format, "1.0");
        ((ArtifactAstSerializerFactory)Mockito.verify((Object)this.artifactAstSerializerFactory, (VerificationMode)Mockito.times((int)1))).getSerializer(format, "1.0");
    }

    @Test
    public void testGetSerializerCallsSerializerFactoryGetSerializerWithKlingonParam_WhenGettingAKlingonSerializer() {
        String format = "Klingon";
        this.artifactAstSerializerProvider.getSerializer(format, "1.0");
        ((ArtifactAstSerializerFactory)Mockito.verify((Object)this.artifactAstSerializerFactory, (VerificationMode)Mockito.times((int)1))).getSerializer(format, "1.0");
    }

    @Test
    public void testGetDeserializerReturnsDefaultArtifactAstDeserializerInstance_WhenGettingADeserializer() {
        ArtifactAstDeserializer deserializer = this.artifactAstSerializerProvider.getDeserializer();
        MatcherAssert.assertThat((Object)deserializer, (Matcher)Matchers.instanceOf(DefaultArtifactAstDeserializer.class));
    }
}

