/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.serialization.ExtensionModelResolver;
import org.mule.runtime.ast.internal.serialization.ArtifactAstSerializerFactory;
import org.mule.runtime.ast.internal.serialization.ArtifactAstSerializerMetadata;
import org.mule.runtime.ast.internal.serialization.ArtifactAstSerializerMetadataSerializer;
import org.mule.runtime.ast.internal.serialization.DefaultArtifactAstDeserializer;
import org.mule.runtime.ast.internal.serialization.InternalArtifactAstDeserializer;
import org.mule.runtime.ast.testobjects.TestExtensionModelResolver;

@Feature(value="AST serialization")
public class DefaultArtifactAstDeserializerTestCase {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private DefaultArtifactAstDeserializer defaultArtifactAstDeserializer;
    private ArtifactAstSerializerMetadataSerializer artifactAstSerializerMetadataSerializer;
    private ArtifactAstSerializerFactory artifactAstSerializerFactory;
    private InternalArtifactAstDeserializer artifactAstDeserializer;
    private ExtensionModelResolver extensionModelResolver;

    @Before
    public void setUp() {
        this.artifactAstSerializerFactory = (ArtifactAstSerializerFactory)Mockito.mock(ArtifactAstSerializerFactory.class);
        this.artifactAstSerializerMetadataSerializer = (ArtifactAstSerializerMetadataSerializer)Mockito.mock(ArtifactAstSerializerMetadataSerializer.class);
        this.defaultArtifactAstDeserializer = new DefaultArtifactAstDeserializer(this.artifactAstSerializerFactory, this.artifactAstSerializerMetadataSerializer);
        this.artifactAstDeserializer = (InternalArtifactAstDeserializer)Mockito.mock(InternalArtifactAstDeserializer.class);
        this.extensionModelResolver = new TestExtensionModelResolver(new HashSet<ExtensionModel>());
    }

    @Test
    @Description(value="The metadata is read")
    public void testDeserializeCallsMetadataReaderWithParameterArtifactInputStream_WhenDeserializingAnArtifactInputStream() throws IOException {
        Charset charset = StandardCharsets.UTF_8;
        InputStream inputStream = IOUtils.toInputStream((String)"Some artifact ast but serialized", (Charset)charset);
        ArtifactAstSerializerMetadata artifactAstSerializerMetadata = new ArtifactAstSerializerMetadata("SomeId", "SomeVersion", charset);
        Mockito.when((Object)this.artifactAstSerializerMetadataSerializer.readArtifactAstSerializerMetadataFromInputStream(inputStream)).thenReturn((Object)artifactAstSerializerMetadata);
        Mockito.when((Object)this.artifactAstSerializerFactory.getDeserializer(artifactAstSerializerMetadata.getSerializerId(), artifactAstSerializerMetadata.getSerializerVersion())).thenReturn((Object)this.artifactAstDeserializer);
        this.defaultArtifactAstDeserializer.deserialize(inputStream, this.extensionModelResolver);
        ((ArtifactAstSerializerMetadataSerializer)Mockito.verify((Object)this.artifactAstSerializerMetadataSerializer, (VerificationMode)Mockito.times((int)1))).readArtifactAstSerializerMetadataFromInputStream(inputStream);
    }

    @Test
    @Description(value="With the metadata we fetch the deserializer")
    public void testDeserializeCallsSerializerFactoryGetDeserializerWithSerializedMetadataId_WhenDeserializingAnArtifactInputStream() throws IOException {
        Charset charset = StandardCharsets.ISO_8859_1;
        InputStream inputStream = IOUtils.toInputStream((String)"Some artifact ast but serialized", (Charset)charset);
        ArtifactAstSerializerMetadata artifactAstSerializerMetadata = new ArtifactAstSerializerMetadata("SomeOtherId", "SomeOtherVersion", charset);
        Mockito.when((Object)this.artifactAstSerializerMetadataSerializer.readArtifactAstSerializerMetadataFromInputStream(inputStream)).thenReturn((Object)artifactAstSerializerMetadata);
        Mockito.when((Object)this.artifactAstSerializerFactory.getDeserializer(artifactAstSerializerMetadata.getSerializerId(), artifactAstSerializerMetadata.getSerializerVersion())).thenReturn((Object)this.artifactAstDeserializer);
        this.defaultArtifactAstDeserializer.deserialize(inputStream, this.extensionModelResolver);
        ((ArtifactAstSerializerFactory)Mockito.verify((Object)this.artifactAstSerializerFactory, (VerificationMode)Mockito.times((int)1))).getDeserializer(artifactAstSerializerMetadata.getSerializerId(), artifactAstSerializerMetadata.getSerializerVersion());
    }

    @Test
    @Description(value="With the deserializer we deserialize the input")
    public void testDeserializeCallsResolvedArtifactAstDeserializerDeserializeWithInputStreamAndExtensionModels_WhenDeserializingAnArtifactInputStream() throws IOException {
        Charset charset = StandardCharsets.UTF_8;
        InputStream inputStream = IOUtils.toInputStream((String)"Some artifact ast but serialized", (Charset)charset);
        ArtifactAstSerializerMetadata artifactAstSerializerMetadata = new ArtifactAstSerializerMetadata("YetAnotherId", "YetAnotherVersion", charset);
        Mockito.when((Object)this.artifactAstSerializerMetadataSerializer.readArtifactAstSerializerMetadataFromInputStream(inputStream)).thenReturn((Object)artifactAstSerializerMetadata);
        Mockito.when((Object)this.artifactAstSerializerFactory.getDeserializer(artifactAstSerializerMetadata.getSerializerId(), artifactAstSerializerMetadata.getSerializerVersion())).thenReturn((Object)this.artifactAstDeserializer);
        this.defaultArtifactAstDeserializer.deserialize(inputStream, this.extensionModelResolver);
        ((InternalArtifactAstDeserializer)Mockito.verify((Object)this.artifactAstDeserializer, (VerificationMode)Mockito.times((int)1))).deserialize(inputStream, "YetAnotherVersion", charset, this.extensionModelResolver, null);
    }

    @Test
    @Issue(value="MULE-19834")
    @Description(value="With the deserializer we deserialize the input")
    public void testDeserializeCallsResolvedArtifactAstDeserializerDeserializeWithInputStreamExtensionModelsAndParent_WhenDeserializingAnArtifactInputStreamWithParent() throws IOException {
        Charset charset = StandardCharsets.UTF_8;
        InputStream inputStream = IOUtils.toInputStream((String)"Some artifact ast but serialized", (Charset)charset);
        ArtifactAstSerializerMetadata artifactAstSerializerMetadata = new ArtifactAstSerializerMetadata("YetAnotherId", "YetAnotherVersion", charset);
        Mockito.when((Object)this.artifactAstSerializerMetadataSerializer.readArtifactAstSerializerMetadataFromInputStream(inputStream)).thenReturn((Object)artifactAstSerializerMetadata);
        Mockito.when((Object)this.artifactAstSerializerFactory.getDeserializer(artifactAstSerializerMetadata.getSerializerId(), artifactAstSerializerMetadata.getSerializerVersion())).thenReturn((Object)this.artifactAstDeserializer);
        ArtifactAst parent = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        this.defaultArtifactAstDeserializer.deserialize(inputStream, this.extensionModelResolver, parent);
        ((InternalArtifactAstDeserializer)Mockito.verify((Object)this.artifactAstDeserializer, (VerificationMode)Mockito.times((int)1))).deserialize(inputStream, "YetAnotherVersion", charset, this.extensionModelResolver, parent);
    }

    @Test
    public void testDeserializeThrowsNullPointerException_WhenInputStreamIsNull() throws IOException {
        InputStream inputStream = null;
        this.exception.expect(NullPointerException.class);
        this.exception.expectMessage("artifactAstInputStream");
        this.defaultArtifactAstDeserializer.deserialize(inputStream, this.extensionModelResolver);
    }

    @Test
    public void testDeserializeThrowsNullPointerException_WhenExtensionModelSetIsNull() throws IOException {
        InputStream inputStream = IOUtils.toInputStream((String)"Some artifact ast but serialized", (Charset)StandardCharsets.UTF_8);
        this.exception.expect(NullPointerException.class);
        this.exception.expectMessage("extensionModelResolver");
        this.defaultArtifactAstDeserializer.deserialize(inputStream, null);
    }
}

