/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.dto;

import com.google.common.collect.Lists;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.namespace.QName;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComposableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.stereotype.HasStereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.MetadataTypeAdapter;
import org.mule.runtime.ast.api.serialization.ExtensionModelResolver;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.model.ExtensionModelHelper;
import org.mule.runtime.ast.internal.serialization.dto.ComponentAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentAstDTOModelType;
import org.mule.runtime.ast.internal.serialization.dto.ComponentGenerationInformationDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentMetadataAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentParameterAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ExtensionModelDTO;
import org.mule.runtime.ast.internal.serialization.dto.ParameterValueContainer;
import org.mule.runtime.ast.internal.serialization.resolver.GenerationInformationResolver;
import org.mule.runtime.ast.internal.serialization.visitor.DTOMetadataTypeVisitor;
import org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;

@Feature(value="AST serialization")
@Story(value="AST serialization enrichment")
public class ComponentAstDTOTestCase {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private GenerationInformationResolver generationInformationResolver;
    private ComponentAstDTO componentAstDTO;
    private ExtensionModelHelper extensionModelHelper;
    private ObjectType metadataType;
    private ComponentAstDTO parentComponentAstDTO;
    private ExtensionModel extensionModel;
    private ComposableModel composableModel;
    private NestedRouteModel nestableModel;
    private MockClassLoader applicationClassLoader;
    private TypeCatalog typeCatalog;
    private MockClassLoader pluginClassLoader;

    @Before
    public void setUp() {
        this.generationInformationResolver = (GenerationInformationResolver)Mockito.mock(GenerationInformationResolver.class);
        this.componentAstDTO = (ComponentAstDTO)Mockito.mock(ComponentAstDTO.class);
        this.metadataType = (ObjectType)Mockito.mock(ObjectType.class);
        this.typeCatalog = (TypeCatalog)Mockito.mock(TypeCatalog.class);
        this.extensionModelHelper = (ExtensionModelHelper)Mockito.mock(ExtensionModelHelper.class);
        Mockito.when((Object)this.extensionModelHelper.findMetadataType(String.class)).thenReturn(Optional.of(Mockito.mock(StringType.class)));
        Mockito.when((Object)this.extensionModelHelper.getTypeCatalog()).thenReturn((Object)this.typeCatalog);
        this.extensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        this.composableModel = (ComposableModel)Mockito.mock(ComposableModel.class);
        this.nestableModel = (NestedRouteModel)Mockito.mock(NestedRouteModel.class);
        ((ComposableModel)Mockito.doReturn(Collections.singletonList(this.nestableModel)).when((Object)this.composableModel)).getNestedComponents();
        this.parentComponentAstDTO = (ComponentAstDTO)Mockito.mock(ComponentAstDTO.class);
        ClassLoaderModelProperty classLoaderModelProperty = (ClassLoaderModelProperty)Mockito.mock(ClassLoaderModelProperty.class);
        this.pluginClassLoader = new MockClassLoader();
        Mockito.when((Object)classLoaderModelProperty.getClassLoader()).thenReturn((Object)this.pluginClassLoader);
        Mockito.when((Object)this.extensionModel.getModelProperty(ClassLoaderModelProperty.class)).thenReturn(Optional.of(classLoaderModelProperty));
        this.applicationClassLoader = new MockClassLoader();
    }

    @Test
    public void testOnConfigurationResolvesModel_WhenVisitingConfigurationModelWithMatchingModelName() {
        String modelName = "config";
        ConfigurationModel configurationModel = (ConfigurationModel)Mockito.mock(ConfigurationModel.class);
        Mockito.when((Object)configurationModel.getName()).thenReturn((Object)modelName);
        Mockito.when((Object)this.extensionModel.getConfigurationModel(modelName)).thenReturn(Optional.of(configurationModel));
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO("config", ComponentAstDTOModelType.CONFIGURATION, Collections.emptyList(), ComponentIdentifier.builder().namespaceUri("uri").namespace("ns").name("aName").build(), (ParameterizedModel)configurationModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        componentAstDTO.resolveModelComponent(null, this.extensionModelHelper, this.generationInformationResolver);
        MatcherAssert.assertThat(componentAstDTO.getModel(ConfigurationModel.class).get(), (Matcher)Matchers.is((Object)configurationModel));
        MatcherAssert.assertThat(componentAstDTO.getModel(ParameterizedModel.class).get(), (Matcher)Matchers.is((Object)configurationModel));
    }

    @Test
    public void testOnConfigurationDoesNotResolveModel_WhenVisitingConfigurationModelWithNonMatchingModelName() {
        String modelName = "config";
        ConfigurationModel configurationModel = (ConfigurationModel)Mockito.mock(ConfigurationModel.class);
        Mockito.when((Object)configurationModel.getName()).thenReturn((Object)modelName);
        Mockito.when((Object)this.extensionModel.getConfigurationModel(modelName)).thenReturn(Optional.of(configurationModel));
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO("other", ComponentAstDTOModelType.CONFIGURATION, Collections.emptyList(), ComponentIdentifier.builder().namespaceUri("uri").namespace("ns").name("aName").build(), (ParameterizedModel)configurationModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        componentAstDTO.resolveModelComponent(null, this.extensionModelHelper, this.generationInformationResolver);
        MatcherAssert.assertThat((Object)componentAstDTO.getModel(ConfigurationModel.class).isPresent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)componentAstDTO.getModel(ParameterizedModel.class).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testOnConnectionProviderResolvesModel_WhenVisitingConnectionProviderModelWithMatchingModelName() {
        String modelName = "connection";
        ConnectionProviderModel connectionProviderModel = (ConnectionProviderModel)Mockito.mock(ConnectionProviderModel.class);
        Mockito.when((Object)connectionProviderModel.getName()).thenReturn((Object)modelName);
        Mockito.when((Object)this.extensionModel.getConnectionProviderModel(modelName)).thenReturn(Optional.of(connectionProviderModel));
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO(modelName, ComponentAstDTOModelType.CONNECTION_PROVIDER, Collections.emptyList(), ComponentIdentifier.builder().namespaceUri("uri").namespace("ns").name("aName").build(), (ParameterizedModel)connectionProviderModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        componentAstDTO.resolveModelComponent(null, this.extensionModelHelper, this.generationInformationResolver);
        MatcherAssert.assertThat(componentAstDTO.getModel(ConnectionProviderModel.class).get(), (Matcher)Matchers.is((Object)connectionProviderModel));
        MatcherAssert.assertThat(componentAstDTO.getModel(ParameterizedModel.class).get(), (Matcher)Matchers.is((Object)connectionProviderModel));
    }

    @Test
    public void testOnConnectionProviderDoesNotResolvesModel_WhenVisitingConnectionProviderModelWithNonMatchingModelName() {
        String modelName = "connection";
        ConnectionProviderModel connectionProviderModel = (ConnectionProviderModel)Mockito.mock(ConnectionProviderModel.class);
        Mockito.when((Object)connectionProviderModel.getName()).thenReturn((Object)modelName);
        Mockito.when((Object)this.extensionModel.getConnectionProviderModel(modelName)).thenReturn(Optional.of(connectionProviderModel));
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO("another", ComponentAstDTOModelType.CONNECTION_PROVIDER, Collections.emptyList(), ComponentIdentifier.builder().namespaceUri("uri").namespace("ns").name("aName").build(), (ParameterizedModel)connectionProviderModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        componentAstDTO.resolveModelComponent(null, this.extensionModelHelper, this.generationInformationResolver);
        MatcherAssert.assertThat((Object)componentAstDTO.getModel(ConnectionProviderModel.class).isPresent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)componentAstDTO.getModel(ParameterizedModel.class).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testOnOperationResolvesModel_WhenVisitingOperationModelWithMatchingModelName() {
        String modelName = "operation";
        OperationModel operationModel = (OperationModel)Mockito.mock(OperationModel.class);
        Mockito.when((Object)operationModel.getName()).thenReturn((Object)modelName);
        Mockito.when((Object)this.extensionModel.getOperationModel(modelName)).thenReturn(Optional.of(operationModel));
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO(modelName, ComponentAstDTOModelType.OPERATION, Collections.emptyList(), ComponentIdentifier.builder().namespaceUri("uri").namespace("ns").name("aName").build(), (ParameterizedModel)operationModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        componentAstDTO.resolveModelComponent(null, this.extensionModelHelper, this.generationInformationResolver);
        MatcherAssert.assertThat(componentAstDTO.getModel(OperationModel.class).get(), (Matcher)Matchers.is((Object)operationModel));
        MatcherAssert.assertThat(componentAstDTO.getModel(ParameterizedModel.class).get(), (Matcher)Matchers.is((Object)operationModel));
    }

    @Test
    public void testOnOperationDoesNotResolvesModel_WhenVisitingOperationModelWithNonMatchingModelName() {
        String modelName = "operation";
        OperationModel operationModel = (OperationModel)Mockito.mock(OperationModel.class);
        Mockito.when((Object)operationModel.getName()).thenReturn((Object)modelName);
        Mockito.when((Object)this.extensionModel.getOperationModel(modelName)).thenReturn(Optional.of(operationModel));
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO("some other", ComponentAstDTOModelType.OPERATION, Collections.emptyList(), ComponentIdentifier.builder().namespaceUri("uri").namespace("ns").name("aName").build(), (ParameterizedModel)operationModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        componentAstDTO.resolveModelComponent(null, this.extensionModelHelper, this.generationInformationResolver);
        MatcherAssert.assertThat((Object)componentAstDTO.getModel(OperationModel.class).isPresent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)componentAstDTO.getModel(ParameterizedModel.class).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testOnSourceResolvesModel_WhenVisitingSourceModelWithMatchingModelName() {
        String modelName = "source";
        SourceModel sourceModel = (SourceModel)Mockito.mock(SourceModel.class);
        Mockito.when((Object)sourceModel.getName()).thenReturn((Object)modelName);
        Mockito.when((Object)this.extensionModel.getSourceModel(modelName)).thenReturn(Optional.of(sourceModel));
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO(modelName, ComponentAstDTOModelType.SOURCE, Collections.emptyList(), ComponentIdentifier.builder().namespaceUri("uri").namespace("ns").name("aName").build(), (ParameterizedModel)sourceModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        componentAstDTO.resolveModelComponent(null, this.extensionModelHelper, this.generationInformationResolver);
        MatcherAssert.assertThat(componentAstDTO.getModel(SourceModel.class).get(), (Matcher)Matchers.is((Object)sourceModel));
        MatcherAssert.assertThat(componentAstDTO.getModel(ParameterizedModel.class).get(), (Matcher)Matchers.is((Object)sourceModel));
    }

    @Test
    public void testOnSourceDoesNotResolvesModel_WhenVisitingSourceModelWithNonMatchingModelName() {
        String modelName = "source";
        SourceModel sourceModel = (SourceModel)Mockito.mock(SourceModel.class);
        Mockito.when((Object)sourceModel.getName()).thenReturn((Object)modelName);
        Mockito.when((Object)this.extensionModel.getSourceModel(modelName)).thenReturn(Optional.of(sourceModel));
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO("john", ComponentAstDTOModelType.SOURCE, Collections.emptyList(), ComponentIdentifier.builder().namespaceUri("uri").namespace("ns").name("aName").build(), (ParameterizedModel)sourceModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        ExtensionModel extensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)extensionModel.getSourceModel(modelName)).thenReturn(Optional.empty());
        componentAstDTO.setExtensionModel(extensionModel);
        componentAstDTO.resolveModelComponent(null, this.extensionModelHelper, this.generationInformationResolver);
        MatcherAssert.assertThat((Object)componentAstDTO.getModel(ParameterizedModel.class).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testOnConstructResolvesModel_WhenVisitingConstructModelWithMatchingModelName() {
        String modelName = "source";
        ConstructModel constructModel = (ConstructModel)Mockito.mock(ConstructModel.class);
        Mockito.when((Object)constructModel.getName()).thenReturn((Object)modelName);
        Mockito.when((Object)this.extensionModel.getConstructModel(modelName)).thenReturn(Optional.of(constructModel));
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO(modelName, ComponentAstDTOModelType.CONSTRUCT, Collections.emptyList(), ComponentIdentifier.builder().namespaceUri("uri").namespace("ns").name("aName").build(), (ParameterizedModel)constructModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        componentAstDTO.resolveModelComponent(null, this.extensionModelHelper, this.generationInformationResolver);
        MatcherAssert.assertThat(componentAstDTO.getModel(ConstructModel.class).get(), (Matcher)Matchers.is((Object)constructModel));
        MatcherAssert.assertThat(componentAstDTO.getModel(ParameterizedModel.class).get(), (Matcher)Matchers.is((Object)constructModel));
    }

    @Test
    public void testOnConstructDoesNotResolvesModel_WhenVisitingConstructModelWithNonMatchingModelName() {
        String modelName = "source";
        ConstructModel constructModel = (ConstructModel)Mockito.mock(ConstructModel.class);
        Mockito.when((Object)constructModel.getName()).thenReturn((Object)modelName);
        Mockito.when((Object)this.extensionModel.getConstructModel(modelName)).thenReturn(Optional.of(constructModel));
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO("Max", ComponentAstDTOModelType.CONSTRUCT, Collections.emptyList(), ComponentIdentifier.builder().namespaceUri("uri").namespace("ns").name("aName").build(), (ParameterizedModel)constructModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        componentAstDTO.resolveModelComponent(null, this.extensionModelHelper, this.generationInformationResolver);
        MatcherAssert.assertThat((Object)componentAstDTO.getModel(ConstructModel.class).isPresent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)componentAstDTO.getModel(ParameterizedModel.class).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testOnNestableElementResolvesModel_WhenVisitingConstructModelWithMatchingModelName() {
        String modelName = "source";
        Mockito.when((Object)this.nestableModel.getName()).thenReturn((Object)modelName);
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO(modelName, ComponentAstDTOModelType.NESTED_COMPONENT, Collections.emptyList(), ComponentIdentifier.builder().namespaceUri("uri").namespace("ns").name("aName").build(), (ParameterizedModel)this.nestableModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        Mockito.when((Object)this.parentComponentAstDTO.getModel(ComposableModel.class)).thenReturn(Optional.of(this.composableModel));
        componentAstDTO.resolveModelComponent(this.parentComponentAstDTO, this.extensionModelHelper, this.generationInformationResolver);
        MatcherAssert.assertThat(componentAstDTO.getModel(NestedRouteModel.class).get(), (Matcher)Matchers.is((Object)this.nestableModel));
    }

    @Test
    public void testOnNestableElementDoesNotResolvesModel_WhenVisitingConstructModelWithNonMatchingModelName() {
        String modelName = "source";
        Mockito.when((Object)this.nestableModel.getName()).thenReturn((Object)modelName);
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO("nestable", ComponentAstDTOModelType.NESTED_COMPONENT, Collections.emptyList(), ComponentIdentifier.builder().namespaceUri("uri").namespace("ns").name("aName").build(), (ParameterizedModel)this.nestableModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        Mockito.when((Object)this.parentComponentAstDTO.getModel(ComposableModel.class)).thenReturn(Optional.of(this.composableModel));
        componentAstDTO.resolveModelComponent(this.parentComponentAstDTO, this.extensionModelHelper, this.generationInformationResolver);
        MatcherAssert.assertThat((Object)componentAstDTO.getModel(NestedRouteModel.class).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testOnTypeAcceptsADTOMetadataTypeVisitor_WhenWalkingAType() {
        TypeCatalog typeCatalog = (TypeCatalog)Mockito.mock(TypeCatalog.class);
        Mockito.when((Object)this.extensionModelHelper.getTypeCatalog()).thenReturn((Object)typeCatalog);
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO("someType", ComponentAstDTOModelType.TYPE, Collections.emptyList(), ComponentIdentifier.builder().namespaceUri("uri").namespace("ns").name("aName").build(), parameterizedModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        ObjectType type = (ObjectType)Mockito.mock(ObjectType.class);
        Mockito.when((Object)typeCatalog.getType("someType")).thenReturn(Optional.of(type));
        componentAstDTO.resolveModelComponent(null, this.extensionModelHelper, this.generationInformationResolver);
        ((ObjectType)Mockito.verify((Object)type, (VerificationMode)Mockito.times((int)1))).accept((MetadataTypeVisitor)ArgumentMatchers.any(DTOMetadataTypeVisitor.class));
    }

    @Test
    public void testOnSubTypeAcceptsADTOMetadataTypeVisitor_WhenWalkingAType() {
        TypeCatalog typeCatalog = (TypeCatalog)Mockito.mock(TypeCatalog.class);
        Mockito.when((Object)this.extensionModelHelper.getTypeCatalog()).thenReturn((Object)typeCatalog);
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO("someType", ComponentAstDTOModelType.TYPE, Collections.emptyList(), ComponentIdentifier.builder().namespaceUri("uri").namespace("ns").name("aName").build(), parameterizedModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        ObjectType baseType = (ObjectType)Mockito.mock(ObjectType.class);
        ObjectType subType = (ObjectType)Mockito.mock(ObjectType.class);
        Mockito.when((Object)subType.getAnnotation(TypeIdAnnotation.class)).thenReturn(Optional.of(new TypeIdAnnotation("someType")));
        ((ObjectType)Mockito.doAnswer(inv -> {
            ((MetadataTypeVisitor)inv.getArgument(0, MetadataTypeVisitor.class)).visitObject((ObjectType)inv.getMock());
            return null;
        }).when((Object)subType)).accept((MetadataTypeVisitor)ArgumentMatchers.any());
        Mockito.when((Object)typeCatalog.getType("someType")).thenReturn(Optional.empty());
        Mockito.when((Object)this.extensionModel.getSubTypes()).thenReturn(Collections.singleton(new SubTypesModel((MetadataType)baseType, Collections.singleton(subType))));
        componentAstDTO.resolveModelComponent(null, this.extensionModelHelper, this.generationInformationResolver);
        ((ObjectType)Mockito.verify((Object)subType, (VerificationMode)Mockito.times((int)1))).accept((MetadataTypeVisitor)ArgumentMatchers.any(DTOMetadataTypeVisitor.class));
    }

    @Test
    public void testSetPropertiesResolverSetsPropertiesResolverOfParameters_WhenSettingPropertiesResolver() {
        PropertiesResolver propertiesResolver = new PropertiesResolver();
        ComponentParameterAstDTO componentParameterAstDTO1 = (ComponentParameterAstDTO)Mockito.mock(ComponentParameterAstDTO.class);
        ComponentParameterAstDTO componentParameterAstDTO2 = (ComponentParameterAstDTO)Mockito.mock(ComponentParameterAstDTO.class);
        ComponentParameterAstDTO componentParameterAstDTO3 = (ComponentParameterAstDTO)Mockito.mock(ComponentParameterAstDTO.class);
        ArrayList parameters = Lists.newArrayList((Object[])new ComponentParameterAstDTO[]{componentParameterAstDTO1, componentParameterAstDTO2, componentParameterAstDTO3});
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO(null, null, parameters, null, parameterizedModel, Collections.emptyList(), TypedComponentIdentifier.ComponentType.UNKNOWN.toString());
        componentAstDTO.setPropertiesResolver(propertiesResolver);
        ((ComponentParameterAstDTO)Mockito.verify((Object)componentParameterAstDTO1, (VerificationMode)Mockito.times((int)1))).setPropertiesResolver(propertiesResolver);
        ((ComponentParameterAstDTO)Mockito.verify((Object)componentParameterAstDTO2, (VerificationMode)Mockito.times((int)1))).setPropertiesResolver(propertiesResolver);
        ((ComponentParameterAstDTO)Mockito.verify((Object)componentParameterAstDTO3, (VerificationMode)Mockito.times((int)1))).setPropertiesResolver(propertiesResolver);
    }

    @Test
    public void testSetPropertiesResolverSetsPropertiesResolver_WhenSettingPropertiesResolver() {
        PropertiesResolver propertiesResolver = new PropertiesResolver();
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO(null, null, Collections.emptyList(), null, parameterizedModel, Collections.emptyList(), TypedComponentIdentifier.ComponentType.UNKNOWN.toString());
        componentAstDTO.setPropertiesResolver(propertiesResolver);
        MatcherAssert.assertThat((Object)componentAstDTO.getPropertiesResolver(), (Matcher)Matchers.is((Object)propertiesResolver));
    }

    @Test
    public void testResolveModelForInfrastructureParametersSetsMetadataTypeAdapterAsParameterizedModel_WhenResolvingInfrastructureParameterModel() {
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO("errorMappings", ComponentAstDTOModelType.INFRASTRUCTURE, new ArrayList<ComponentParameterAstDTO>(), null, parameterizedModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        MetadataType nonStereotypedType = (MetadataType)Mockito.mock(MetadataType.class);
        Mockito.when((Object)nonStereotypedType.getAnnotation(StereotypeTypeAnnotation.class)).thenReturn(Optional.empty());
        componentAstDTO.setType(nonStereotypedType);
        componentAstDTO.resolveModelComponent(componentAstDTO, this.extensionModelHelper, this.generationInformationResolver);
        MatcherAssert.assertThat((Object)componentAstDTO.getModel(ParameterizedModel.class), (Matcher)Matchers.notNullValue());
    }

    @Test
    @Issue(value="MULE-19819")
    public void testResolveModelForInfrastructureParametersSetsMetadataTypeAdapterWithStereotypeAsParameterizedModel_WhenResolvingInfrastructureParameterModel() {
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO("errorMappings", ComponentAstDTOModelType.INFRASTRUCTURE, new ArrayList<ComponentParameterAstDTO>(), null, parameterizedModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        MetadataType stereotypedType = (MetadataType)Mockito.mock(MetadataType.class);
        StereotypeModel stereotypeModel = (StereotypeModel)Mockito.mock(StereotypeModel.class);
        Mockito.when((Object)stereotypedType.getAnnotation(StereotypeTypeAnnotation.class)).thenReturn(Optional.of(new StereotypeTypeAnnotation(Collections.singletonList(stereotypeModel))));
        componentAstDTO.setType(stereotypedType);
        componentAstDTO.resolveModelComponent(componentAstDTO, this.extensionModelHelper, this.generationInformationResolver);
        MatcherAssert.assertThat(componentAstDTO.getModel(ParameterizedModel.class).get(), (Matcher)Matchers.instanceOf(HasStereotypeModel.class));
        MatcherAssert.assertThat((Object)((HasStereotypeModel)componentAstDTO.getModel(ParameterizedModel.class).get()).getStereotype(), (Matcher)Matchers.is((Object)stereotypeModel));
    }

    @Test
    public void testResolveModelForInfrastructureParametersResolvesGenerationInformation_WhenResolvingInfrastructureParameterModel() {
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO("errorMappings", ComponentAstDTOModelType.INFRASTRUCTURE, new ArrayList<ComponentParameterAstDTO>(), null, parameterizedModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        ComponentGenerationInformationDTO componentGenerationInformationDTO = new ComponentGenerationInformationDTO(null);
        ExtensionModel extensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        componentAstDTO.setExtensionModel(extensionModel);
        Mockito.when((Object)this.generationInformationResolver.resolveComponentAstGenerationInformation((ComponentParameterAstDTO)ArgumentMatchers.isNull(), (ComponentAstDTO)ArgumentMatchers.same((Object)componentAstDTO), (ExtensionModelHelper)ArgumentMatchers.same((Object)this.extensionModelHelper))).thenReturn((Object)componentGenerationInformationDTO);
        MetadataType nonStereotypedType = (MetadataType)Mockito.mock(MetadataType.class);
        Mockito.when((Object)nonStereotypedType.getAnnotation(StereotypeTypeAnnotation.class)).thenReturn(Optional.empty());
        componentAstDTO.setType(nonStereotypedType);
        componentAstDTO.resolveModelComponent(componentAstDTO, this.extensionModelHelper, this.generationInformationResolver);
        MatcherAssert.assertThat((Object)componentAstDTO.getGenerationInformation(), (Matcher)Matchers.is((Object)componentGenerationInformationDTO));
    }

    @Test
    public void testResolveModelForInfrastructureParametersResolvesModelsOfParameters_WhenResolvingInfrastructureParameterModel() {
        this.prepareResolver();
        ComponentParameterAstDTO componentParameterAstDTO1 = this.makeComponentParameterAstDTO("name", null);
        ComponentParameterAstDTO componentParameterAstDTO2 = this.makeComponentParameterAstDTO("name", null);
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO("errorMappings", ComponentAstDTOModelType.INFRASTRUCTURE, Arrays.asList(componentParameterAstDTO1, componentParameterAstDTO2), null, parameterizedModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        componentAstDTO.setType((MetadataType)this.metadataType);
        TypeAliasAnnotation typeAliasAnnotation = (TypeAliasAnnotation)Mockito.mock(TypeAliasAnnotation.class);
        Mockito.when((Object)typeAliasAnnotation.getValue()).thenReturn((Object)"parameter group name");
        Mockito.when((Object)this.metadataType.getAnnotation(TypeAliasAnnotation.class)).thenReturn(Optional.of(typeAliasAnnotation));
        componentAstDTO.resolveModelComponent(componentAstDTO, this.extensionModelHelper, this.generationInformationResolver);
        MatcherAssert.assertThat((Object)componentParameterAstDTO1.getModel(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)componentParameterAstDTO1.getGroupModel(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)componentParameterAstDTO2.getModel(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)componentParameterAstDTO2.getGroupModel(), (Matcher)Matchers.notNullValue());
    }

    @Test
    @Issue(value="MULE-19806")
    public void generationInformationForUnionType() {
        this.prepareResolver();
        ObjectKeyType key = (ObjectKeyType)Mockito.mock(ObjectKeyType.class);
        Mockito.when((Object)key.getName()).thenReturn((Object)new QName("unionParam"));
        ObjectType unionObjectType1 = (ObjectType)Mockito.mock(ObjectType.class);
        ObjectType unionObjectType2 = (ObjectType)Mockito.mock(ObjectType.class);
        UnionType unionType = (UnionType)Mockito.mock(UnionType.class);
        ((UnionType)Mockito.doAnswer(inv -> {
            ((MetadataTypeVisitor)inv.getArgument(0, MetadataTypeVisitor.class)).visitUnion(unionType);
            return null;
        }).when((Object)unionType)).accept((MetadataTypeVisitor)ArgumentMatchers.any(MetadataTypeVisitor.class));
        Mockito.when((Object)unionType.getTypes()).thenReturn(Arrays.asList(unionObjectType1, unionObjectType2));
        ObjectFieldType field = (ObjectFieldType)Mockito.mock(ObjectFieldType.class);
        Mockito.when((Object)field.getValue()).thenReturn((Object)unionType);
        Mockito.when((Object)field.getKey()).thenReturn((Object)key);
        Mockito.when((Object)this.metadataType.getFields()).thenReturn(Collections.singleton(field));
        ComponentParameterAstDTO componentParameterAstDTO1 = this.makeComponentParameterAstDTO("name", null);
        ComponentAstDTO valueComponentAstDTO = (ComponentAstDTO)Mockito.mock(ComponentAstDTO.class);
        ComponentIdentifier valueIdentifier = ComponentIdentifier.builder().name("unionObjectType1").namespace("ns").build();
        Mockito.when((Object)valueComponentAstDTO.getIdentifier()).thenReturn((Object)valueIdentifier);
        ComponentParameterAstDTO componentParameterAstDTO2 = this.makeComponentParameterAstDTO("unionParam", new ParameterValueContainer(null, (Object)valueComponentAstDTO));
        ComponentIdentifier paramIdentifier = ComponentIdentifier.builder().name("unionParam").namespace("ns").build();
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO("errorMappings", ComponentAstDTOModelType.INFRASTRUCTURE, Arrays.asList(componentParameterAstDTO1, componentParameterAstDTO2), paramIdentifier, parameterizedModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        componentAstDTO.setType((MetadataType)this.metadataType);
        TypeAliasAnnotation typeAliasAnnotation = (TypeAliasAnnotation)Mockito.mock(TypeAliasAnnotation.class);
        Mockito.when((Object)typeAliasAnnotation.getValue()).thenReturn((Object)"parameter group name");
        Mockito.when((Object)this.metadataType.getAnnotation(TypeAliasAnnotation.class)).thenReturn(Optional.of(typeAliasAnnotation));
        DslElementSyntax paramValueSyntax1 = (DslElementSyntax)Mockito.mock(DslElementSyntax.class);
        Mockito.when((Object)paramValueSyntax1.getElementName()).thenReturn((Object)"unionObjectType1");
        Mockito.when((Object)this.extensionModelHelper.resolveDslElementModel((MetadataType)unionObjectType1, paramIdentifier.getNamespace())).thenReturn(Optional.of(paramValueSyntax1));
        DslElementSyntax paramValueSyntax2 = (DslElementSyntax)Mockito.mock(DslElementSyntax.class);
        Mockito.when((Object)paramValueSyntax2.getElementName()).thenReturn((Object)"unionObjectType2");
        Mockito.when((Object)this.extensionModelHelper.resolveDslElementModel((MetadataType)unionObjectType2, paramIdentifier.getNamespace())).thenReturn(Optional.of(paramValueSyntax2));
        componentAstDTO.resolveModelComponent(componentAstDTO, this.extensionModelHelper, this.generationInformationResolver);
        MatcherAssert.assertThat(componentParameterAstDTO2.getGenerationInformation().getSyntax().get(), (Matcher)Matchers.is((Object)paramValueSyntax1));
    }

    @Test
    public void testResolveParameterModelByNameResolvesParameterModel_WhenComponentHasComponentModelWithMatchingParameterModel() {
        String parameterModelName = "aParameterModelName";
        ComponentModel componentModel = (ComponentModel)Mockito.mock(ComponentModel.class);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)parameterModelName);
        Mockito.when((Object)componentModel.getAllParameterModels()).thenReturn(Collections.singletonList(parameterModel));
        ComponentParameterAstDTO componentParameterAstDTO = (ComponentParameterAstDTO)Mockito.mock(ComponentParameterAstDTO.class);
        Mockito.when((Object)componentParameterAstDTO.getModelName()).thenReturn((Object)parameterModelName);
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO("aModelName", (ComponentAstDTOModelType)Mockito.mock(ComponentAstDTOModelType.class), Collections.singletonList(componentParameterAstDTO), ComponentIdentifier.builder().namespaceUri("uri").namespace("ns").name("aName").build(), (ParameterizedModel)componentModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        ParameterModel result = componentAstDTO.resolveParameterModel(componentParameterAstDTO);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)parameterModel));
    }

    @Test
    public void testResolveParameterModelByNameResolvesParameterModel_WhenComponentHasConfigurationModelWithMatchingParameterModel() {
        String parameterModelName = "aParameterModelName";
        ConfigurationModel configurationModel = (ConfigurationModel)Mockito.mock(ConfigurationModel.class);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)parameterModelName);
        Mockito.when((Object)configurationModel.getAllParameterModels()).thenReturn(Collections.singletonList(parameterModel));
        ComponentParameterAstDTO componentParameterAstDTO = (ComponentParameterAstDTO)Mockito.mock(ComponentParameterAstDTO.class);
        Mockito.when((Object)componentParameterAstDTO.getModelName()).thenReturn((Object)parameterModelName);
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO("aModelName", (ComponentAstDTOModelType)Mockito.mock(ComponentAstDTOModelType.class), Collections.singletonList(componentParameterAstDTO), ComponentIdentifier.builder().namespaceUri("uri").namespace("ns").name("aName").build(), (ParameterizedModel)configurationModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        ParameterModel result = componentAstDTO.resolveParameterModel(componentParameterAstDTO);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)parameterModel));
    }

    @Test
    public void testResolveParameterModelByNameResolvesParameterModel_WhenComponentHasConnectionProviderModelWithMatchingParameterModel() {
        String parameterModelName = "aParameterModelName";
        ConnectionProviderModel connectionProviderModel = (ConnectionProviderModel)Mockito.mock(ConnectionProviderModel.class);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)parameterModelName);
        Mockito.when((Object)connectionProviderModel.getAllParameterModels()).thenReturn(Collections.singletonList(parameterModel));
        ComponentParameterAstDTO componentParameterAstDTO = (ComponentParameterAstDTO)Mockito.mock(ComponentParameterAstDTO.class);
        Mockito.when((Object)componentParameterAstDTO.getModelName()).thenReturn((Object)parameterModelName);
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO("aModelName", (ComponentAstDTOModelType)Mockito.mock(ComponentAstDTOModelType.class), Collections.singletonList(componentParameterAstDTO), ComponentIdentifier.builder().namespaceUri("uri").namespace("ns").name("aName").build(), (ParameterizedModel)connectionProviderModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        ParameterModel result = componentAstDTO.resolveParameterModel(componentParameterAstDTO);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)parameterModel));
    }

    @Test
    public void testResolveParameterModelByNameResolvesParameterModel_WhenComponentHasParameterizedModelWithMatchingParameterModel() {
        String parameterModelName = "aParameterModelName";
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)parameterModelName);
        Mockito.when((Object)parameterizedModel.getAllParameterModels()).thenReturn(Collections.singletonList(parameterModel));
        ComponentParameterAstDTO componentParameterAstDTO = (ComponentParameterAstDTO)Mockito.mock(ComponentParameterAstDTO.class);
        Mockito.when((Object)componentParameterAstDTO.getModelName()).thenReturn((Object)parameterModelName);
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO("aModelName", (ComponentAstDTOModelType)Mockito.mock(ComponentAstDTOModelType.class), Collections.singletonList(componentParameterAstDTO), ComponentIdentifier.builder().namespaceUri("uri").namespace("ns").name("aName").build(), parameterizedModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        ParameterModel result = componentAstDTO.resolveParameterModel(componentParameterAstDTO);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)parameterModel));
    }

    @Test
    public void testResolveParameterModelByNameDoesNotResolveParameterModel_WhenComponentHasParameterizedModelWithNoMatchingParameterModel() {
        String parameterModelName = "aParameterModelName";
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"non matching name");
        Mockito.when((Object)parameterizedModel.getAllParameterModels()).thenReturn(Collections.singletonList(parameterModel));
        ComponentParameterAstDTO componentParameterAstDTO = (ComponentParameterAstDTO)Mockito.mock(ComponentParameterAstDTO.class);
        Mockito.when((Object)componentParameterAstDTO.getModelName()).thenReturn((Object)parameterModelName);
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO("aModelName", (ComponentAstDTOModelType)Mockito.mock(ComponentAstDTOModelType.class), Collections.singletonList(componentParameterAstDTO), ComponentIdentifier.builder().namespaceUri("uri").namespace("ns").name("aName").build(), parameterizedModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Could not resolve ParameterModel for [" + parameterModelName + "]");
        componentAstDTO.resolveParameterModel(componentParameterAstDTO);
    }

    @Test
    public void testResolveParameterGroupModelByNameResolvesParameterGroupModel_WhenComponentHasComponentModelWithMatchingParameterGroupModel() {
        ComponentParameterAstDTO componentParameterAstDTO = (ComponentParameterAstDTO)Mockito.mock(ComponentParameterAstDTO.class);
        String parameterModelName = "aParameterModelName";
        Mockito.when((Object)componentParameterAstDTO.getModelName()).thenReturn((Object)parameterModelName);
        String parameterGroupModelName = "aParameterGroupModelName";
        Mockito.when((Object)componentParameterAstDTO.getGroupModelName()).thenReturn((Object)parameterGroupModelName);
        ComponentModel componentModel = (ComponentModel)Mockito.mock(ComponentModel.class);
        ParameterGroupModel parameterGroupModel = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)parameterGroupModel.getName()).thenReturn((Object)parameterGroupModelName);
        Mockito.when((Object)componentModel.getParameterGroupModels()).thenReturn(Collections.singletonList(parameterGroupModel));
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO("aModelName", (ComponentAstDTOModelType)Mockito.mock(ComponentAstDTOModelType.class), Collections.singletonList(componentParameterAstDTO), ComponentIdentifier.builder().namespaceUri("uri").namespace("ns").name("aName").build(), (ParameterizedModel)componentModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        ParameterGroupModel result = componentAstDTO.resolveParameterGroupModel(componentParameterAstDTO);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)parameterGroupModel));
    }

    @Test
    public void testResolveParameterGroupModelByNameResolvesParameterGroupModel_WhenComponentHasConfigurationModelWithMatchingParameterGroupModel() {
        ComponentParameterAstDTO componentParameterAstDTO = (ComponentParameterAstDTO)Mockito.mock(ComponentParameterAstDTO.class);
        String parameterModelName = "aParameterModelName";
        Mockito.when((Object)componentParameterAstDTO.getModelName()).thenReturn((Object)parameterModelName);
        String parameterGroupModelName = "aParameterGroupModelName";
        Mockito.when((Object)componentParameterAstDTO.getGroupModelName()).thenReturn((Object)parameterGroupModelName);
        ConfigurationModel configurationModel = (ConfigurationModel)Mockito.mock(ConfigurationModel.class);
        ParameterGroupModel parameterGroupModel = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)parameterGroupModel.getName()).thenReturn((Object)parameterGroupModelName);
        Mockito.when((Object)configurationModel.getParameterGroupModels()).thenReturn(Collections.singletonList(parameterGroupModel));
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO("aModelName", (ComponentAstDTOModelType)Mockito.mock(ComponentAstDTOModelType.class), Collections.singletonList(componentParameterAstDTO), ComponentIdentifier.builder().namespaceUri("uri").namespace("ns").name("aName").build(), (ParameterizedModel)configurationModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        ParameterGroupModel result = componentAstDTO.resolveParameterGroupModel(componentParameterAstDTO);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)parameterGroupModel));
    }

    @Test
    public void testResolveParameterGroupModelByNameResolvesParameterGroupModel_WhenComponentHasConnectionProviderModelWithMatchingParameterGroupModel() {
        ComponentParameterAstDTO componentParameterAstDTO = (ComponentParameterAstDTO)Mockito.mock(ComponentParameterAstDTO.class);
        String parameterModelName = "aParameterModelName";
        Mockito.when((Object)componentParameterAstDTO.getModelName()).thenReturn((Object)parameterModelName);
        String parameterGroupModelName = "aParameterGroupModelName";
        Mockito.when((Object)componentParameterAstDTO.getGroupModelName()).thenReturn((Object)parameterGroupModelName);
        ConnectionProviderModel connectionProviderModel = (ConnectionProviderModel)Mockito.mock(ConnectionProviderModel.class);
        ParameterGroupModel parameterGroupModel = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)parameterGroupModel.getName()).thenReturn((Object)parameterGroupModelName);
        Mockito.when((Object)connectionProviderModel.getParameterGroupModels()).thenReturn(Collections.singletonList(parameterGroupModel));
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO("aModelName", (ComponentAstDTOModelType)Mockito.mock(ComponentAstDTOModelType.class), Collections.singletonList(componentParameterAstDTO), ComponentIdentifier.builder().namespaceUri("uri").namespace("ns").name("aName").build(), (ParameterizedModel)connectionProviderModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        ParameterGroupModel result = componentAstDTO.resolveParameterGroupModel(componentParameterAstDTO);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)parameterGroupModel));
    }

    @Test
    public void testResolveParameterGroupModelByNameResolvesParameterGroupModel_WhenComponentHasParameterizedModelWithMatchingParameterGroupModel() {
        ComponentParameterAstDTO componentParameterAstDTO = (ComponentParameterAstDTO)Mockito.mock(ComponentParameterAstDTO.class);
        String parameterModelName = "aParameterModelName";
        Mockito.when((Object)componentParameterAstDTO.getModelName()).thenReturn((Object)parameterModelName);
        String parameterGroupModelName = "aParameterGroupModelName";
        Mockito.when((Object)componentParameterAstDTO.getGroupModelName()).thenReturn((Object)parameterGroupModelName);
        ParameterizedModel connectionProviderModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ParameterGroupModel parameterGroupModel = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)parameterGroupModel.getName()).thenReturn((Object)parameterGroupModelName);
        Mockito.when((Object)connectionProviderModel.getParameterGroupModels()).thenReturn(Collections.singletonList(parameterGroupModel));
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO("aModelName", (ComponentAstDTOModelType)Mockito.mock(ComponentAstDTOModelType.class), Collections.singletonList(componentParameterAstDTO), ComponentIdentifier.builder().namespaceUri("uri").namespace("ns").name("aName").build(), connectionProviderModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        ParameterGroupModel result = componentAstDTO.resolveParameterGroupModel(componentParameterAstDTO);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)parameterGroupModel));
    }

    @Test
    public void testResolveParameterGroupModelByNameDoesNotResolveParameterGroupModel_WhenComponentHasParameterizedModelWithNoMatchingParameterGroupModel() {
        ComponentParameterAstDTO componentParameterAstDTO = (ComponentParameterAstDTO)Mockito.mock(ComponentParameterAstDTO.class);
        String parameterModelName = "aParameterModelName";
        Mockito.when((Object)componentParameterAstDTO.getModelName()).thenReturn((Object)parameterModelName);
        String parameterGroupModelName = "aParameterGroupModelName";
        Mockito.when((Object)componentParameterAstDTO.getGroupModelName()).thenReturn((Object)parameterGroupModelName);
        ParameterizedModel connectionProviderModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ParameterGroupModel parameterGroupModel = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)parameterGroupModel.getName()).thenReturn((Object)"non matching name");
        Mockito.when((Object)connectionProviderModel.getParameterGroupModels()).thenReturn(Collections.singletonList(parameterGroupModel));
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO("aModelName", (ComponentAstDTOModelType)Mockito.mock(ComponentAstDTOModelType.class), Collections.singletonList(componentParameterAstDTO), ComponentIdentifier.builder().namespaceUri("uri").namespace("ns").name("aName").build(), connectionProviderModel, new ArrayList<ComponentAstDTO>(), TypedComponentIdentifier.ComponentType.UNKNOWN.name());
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Could not resolve ParameterGroupModel [" + parameterGroupModelName + "]");
        componentAstDTO.resolveParameterGroupModel(componentParameterAstDTO);
    }

    @Test
    public void testResolveTypeReturnsTypeFromTypeCatalog_WhenResolvingATypeThatIsInTheCatalog() {
        String modelName = "some.model.Name";
        ObjectType objectType = (ObjectType)Mockito.mock(ObjectType.class);
        Optional<ObjectType> optionalObjectType = Optional.of(objectType);
        Mockito.when((Object)this.typeCatalog.getType(modelName)).thenReturn(optionalObjectType);
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO(modelName, null, null, null, parameterizedModel, null, TypedComponentIdentifier.ComponentType.UNKNOWN.toString());
        Optional optionalMetadataType = componentAstDTO.resolveType(this.extensionModelHelper, (ClassLoader)this.applicationClassLoader);
        MatcherAssert.assertThat((Object)optionalMetadataType, (Matcher)Matchers.is(optionalObjectType));
    }

    @Test
    public void testResolveTypeReturnsTypeFromExtensionModelsSubtypes_WhenResolvingATypeThatIsNotInTheCatalogButIsASubtype() {
        String modelName = "some.model.Name";
        SubTypesModel subTypesModel = (SubTypesModel)Mockito.mock(SubTypesModel.class);
        Mockito.when((Object)this.typeCatalog.getType(modelName)).thenReturn(Optional.empty());
        HashSet<SubTypesModel> subTypesModels = new HashSet<SubTypesModel>();
        subTypesModels.add(subTypesModel);
        Mockito.when((Object)this.extensionModel.getSubTypes()).thenReturn(subTypesModels);
        TestObjectType objectType = new TestObjectType(modelName);
        HashSet<TestObjectType> subtypes = new HashSet<TestObjectType>();
        subtypes.add(objectType);
        Mockito.when((Object)subTypesModel.getSubTypes()).thenReturn(subtypes);
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO(modelName, null, null, null, parameterizedModel, null, TypedComponentIdentifier.ComponentType.UNKNOWN.toString());
        componentAstDTO.setExtensionModel(this.extensionModel);
        Optional optionalMetadataType = componentAstDTO.resolveType(this.extensionModelHelper, (ClassLoader)this.applicationClassLoader);
        MatcherAssert.assertThat((Object)optionalMetadataType, (Matcher)Matchers.is(Optional.of(objectType)));
    }

    @Test
    public void testResolveTypeReturnsTypeFromApplicationClassLoader_WhenResolvingATypeThatIsNotInTheCatalogNorIsASubtypeButIsInApplicationClassLoader() throws ClassNotFoundException {
        String modelName = "some.model.Name";
        Mockito.when((Object)this.typeCatalog.getType(modelName)).thenReturn(Optional.empty());
        HashSet subTypesModels = new HashSet();
        Mockito.when((Object)this.extensionModel.getSubTypes()).thenReturn(subTypesModels);
        Class<Class> aClass = Class.class;
        this.applicationClassLoader.addClass(modelName, aClass);
        MetadataType metadataType = (MetadataType)Mockito.mock(MetadataType.class);
        Optional<MetadataType> typeOptional = Optional.of(metadataType);
        Mockito.when((Object)this.extensionModelHelper.findMetadataType(aClass)).thenReturn(typeOptional);
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO(modelName, null, null, null, parameterizedModel, null, TypedComponentIdentifier.ComponentType.UNKNOWN.toString());
        componentAstDTO.setExtensionModel(this.extensionModel);
        Optional optionalMetadataType = componentAstDTO.resolveType(this.extensionModelHelper, (ClassLoader)this.applicationClassLoader);
        MatcherAssert.assertThat((Object)optionalMetadataType, (Matcher)Matchers.is(typeOptional));
    }

    @Test
    public void testResolveTypeReturnsTypeFromApplicationClassLoader_WhenResolvingATypeThatIsInnerClassInApplicationClassLoader() throws ClassNotFoundException {
        String modelName = "some.model.Some.Name";
        String inner = "some.model.Some$Name";
        Mockito.when((Object)this.typeCatalog.getType(modelName)).thenReturn(Optional.empty());
        HashSet subTypesModels = new HashSet();
        Mockito.when((Object)this.extensionModel.getSubTypes()).thenReturn(subTypesModels);
        Class<Class> aClass = Class.class;
        this.applicationClassLoader.addMissingClass(modelName);
        this.applicationClassLoader.addClass(inner, aClass);
        MetadataType metadataType = (MetadataType)Mockito.mock(MetadataType.class);
        Optional<MetadataType> typeOptional = Optional.of(metadataType);
        Mockito.when((Object)this.extensionModelHelper.findMetadataType(aClass)).thenReturn(typeOptional);
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO(modelName, null, null, null, parameterizedModel, null, TypedComponentIdentifier.ComponentType.UNKNOWN.toString());
        componentAstDTO.setExtensionModel(this.extensionModel);
        Optional optionalMetadataType = componentAstDTO.resolveType(this.extensionModelHelper, (ClassLoader)this.applicationClassLoader);
        MatcherAssert.assertThat((Object)optionalMetadataType, (Matcher)Matchers.is(typeOptional));
    }

    @Test
    @Issue(value="MULE-19864")
    public void testResolveTypeReturnsTypeFromPluginClassLoader_WhenResolvingATypeThatIsInPluginClassLoader() throws ClassNotFoundException {
        String modelName = "some.model.Some.Name";
        String inner = "some.model.Some$Name";
        Mockito.when((Object)this.typeCatalog.getType(modelName)).thenReturn(Optional.empty());
        HashSet subTypesModels = new HashSet();
        Mockito.when((Object)this.extensionModel.getSubTypes()).thenReturn(subTypesModels);
        Class<Class> aClass = Class.class;
        this.applicationClassLoader.addMissingClass(modelName);
        this.applicationClassLoader.addMissingClass(inner);
        this.pluginClassLoader.addClass(modelName, aClass);
        MetadataType metadataType = (MetadataType)Mockito.mock(MetadataType.class);
        Optional<MetadataType> typeOptional = Optional.of(metadataType);
        Mockito.when((Object)this.extensionModelHelper.findMetadataType(aClass)).thenReturn(typeOptional);
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO(modelName, null, null, null, parameterizedModel, null, TypedComponentIdentifier.ComponentType.UNKNOWN.toString());
        componentAstDTO.setExtensionModel(this.extensionModel);
        Optional optionalMetadataType = componentAstDTO.resolveType(this.extensionModelHelper, (ClassLoader)this.applicationClassLoader);
        MatcherAssert.assertThat((Object)optionalMetadataType, (Matcher)Matchers.is(typeOptional));
    }

    @Test
    @Issue(value="MULE-19864")
    public void testResolveTypeReturnsTypeFromPluginClassLoader_WhenResolvingATypeThatIsInnerClassInPluginClassLoader() throws ClassNotFoundException {
        String modelName = "some.model.Some.Name";
        String inner = "some.model.Some$Name";
        Mockito.when((Object)this.typeCatalog.getType(modelName)).thenReturn(Optional.empty());
        HashSet subTypesModels = new HashSet();
        Mockito.when((Object)this.extensionModel.getSubTypes()).thenReturn(subTypesModels);
        Class<Class> aClass = Class.class;
        this.applicationClassLoader.addMissingClass(modelName);
        this.applicationClassLoader.addMissingClass(inner);
        this.pluginClassLoader.addMissingClass(modelName);
        this.pluginClassLoader.addClass(inner, aClass);
        MetadataType metadataType = (MetadataType)Mockito.mock(MetadataType.class);
        Optional<MetadataType> typeOptional = Optional.of(metadataType);
        Mockito.when((Object)this.extensionModelHelper.findMetadataType(aClass)).thenReturn(typeOptional);
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO(modelName, null, null, null, parameterizedModel, null, TypedComponentIdentifier.ComponentType.UNKNOWN.toString());
        componentAstDTO.setExtensionModel(this.extensionModel);
        Optional optionalMetadataType = componentAstDTO.resolveType(this.extensionModelHelper, (ClassLoader)this.applicationClassLoader);
        MatcherAssert.assertThat((Object)optionalMetadataType, (Matcher)Matchers.is(typeOptional));
    }

    @Test
    @Issue(value="W-11743525")
    public void resolveGenerationInformationForMapEntriesParamsWithNullOwnerGenerationInformation() {
        ComponentParameterAstDTO keyComponentParameterAstDto = this.makeComponentParameterAstDTO("key", null);
        keyComponentParameterAstDto.resolveMapEntryAttribute((ParameterModel)Mockito.mock(ParameterModel.class), null, this.extensionModelHelper, null, this.generationInformationResolver, this.componentAstDTO);
        ((GenerationInformationResolver)Mockito.verify((Object)this.generationInformationResolver)).resolveGenerationInformationThroughParent((String)ArgumentMatchers.eq((Object)"key"), (ComponentAstDTO)ArgumentMatchers.any(), (ParameterModel)ArgumentMatchers.any(), (ComponentGenerationInformation)ArgumentMatchers.isNull());
        ComponentParameterAstDTO valueComponentParameterAstDto = this.makeComponentParameterAstDTO("value", null);
        valueComponentParameterAstDto.resolveMapEntryAttribute((ParameterModel)Mockito.mock(ParameterModel.class), null, this.extensionModelHelper, null, this.generationInformationResolver, this.componentAstDTO);
        ((GenerationInformationResolver)Mockito.verify((Object)this.generationInformationResolver)).resolveGenerationInformationThroughParent((String)ArgumentMatchers.eq((Object)"value"), (ComponentAstDTO)ArgumentMatchers.any(), (ParameterModel)ArgumentMatchers.any(), (ComponentGenerationInformation)ArgumentMatchers.isNull());
    }

    @Test
    @Issue(value="W-11780221")
    public void resolveMapValuesTypes() {
        ComponentAstDTO mapEntry = new ComponentAstDTO(null, TypedComponentIdentifier.ComponentType.UNKNOWN.toString(), null, (ComponentLocation)Mockito.mock(ComponentLocation.class), null, Collections.emptyList(), null, (ExtensionModelDTO)Mockito.mock(ExtensionModelDTO.class), null, null, null);
        MetadataType mapValuesType = (MetadataType)Mockito.mock(MetadataType.class);
        ObjectType mapType = (ObjectType)Mockito.mock(ObjectType.class);
        Mockito.when((Object)mapType.getOpenRestriction()).thenReturn(Optional.of(mapValuesType));
        ParameterModel ownerParameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)ownerParameterModel.getType()).thenReturn((Object)mapType);
        ComponentParameterAstDTO ownerParameter = (ComponentParameterAstDTO)Mockito.mock(ComponentParameterAstDTO.class);
        Mockito.when((Object)ownerParameter.getModel()).thenReturn((Object)ownerParameterModel);
        mapEntry.resolveMapEntryComponentModels(mapEntry, ownerParameter, this.extensionModelHelper, (ExtensionModelResolver)Mockito.mock(ExtensionModelResolver.class), this.generationInformationResolver);
        ParameterizedModel pmzModel = (ParameterizedModel)mapEntry.getModel(ParameterizedModel.class).get();
        MatcherAssert.assertThat((Object)((ObjectFieldType)((ObjectType)((MetadataTypeAdapter)pmzModel).getType()).getFieldByName("value").get()).getValue(), (Matcher)Matchers.is((Object)mapValuesType));
    }

    protected void prepareResolver() {
        ComponentGenerationInformationDTO componentGenerationInformationDTO = new ComponentGenerationInformationDTO(null);
        ExtensionModel extensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)this.componentAstDTO.getExtensionModel()).thenReturn((Object)extensionModel);
        Mockito.when((Object)this.generationInformationResolver.resolveComponentAstGenerationInformation((ComponentParameterAstDTO)ArgumentMatchers.any(ComponentParameterAstDTO.class), (ComponentAstDTO)ArgumentMatchers.same((Object)this.componentAstDTO), (ExtensionModelHelper)ArgumentMatchers.same((Object)this.extensionModelHelper))).thenReturn((Object)componentGenerationInformationDTO);
    }

    private ComponentAstDTO makeComponentAstDTO(String modelName, ComponentAstDTOModelType modelType, Collection<ComponentParameterAstDTO> parameters, ComponentIdentifier identifier, ParameterizedModel componentModel, List<ComponentAstDTO> directChildren, String componentType) {
        ComponentLocation location = (ComponentLocation)Mockito.mock(ComponentLocation.class);
        ComponentMetadataAstDTO componentMetadataAstDTO = (ComponentMetadataAstDTO)Mockito.mock(ComponentMetadataAstDTO.class);
        ComponentAstDTO componentAstDTO = new ComponentAstDTO(directChildren, componentType, identifier, location, componentMetadataAstDTO, parameters, "componentId", new ExtensionModelDTO("anExtensionModelName"), modelName, modelType, new HashMap());
        componentAstDTO.setParameterizedModel(componentModel);
        componentAstDTO.setExtensionModel(this.extensionModel);
        return componentAstDTO;
    }

    private ComponentParameterAstDTO makeComponentParameterAstDTO(String modelName, ParameterValueContainer parameterValueContainer) {
        return new ComponentParameterAstDTO(parameterValueContainer, null, false, null, "parameter group name", modelName);
    }

    private static class MockClassLoader
    extends ClassLoader {
        private final Map<String, Class> classesByName = new HashMap<String, Class>();
        private final Set<String> missingClassesNames = new HashSet<String>();

        private MockClassLoader() {
        }

        public void addClass(String className, Class clazz) {
            this.classesByName.put(className, clazz);
        }

        public void addMissingClass(String className) {
            this.missingClassesNames.add(className);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (this.missingClassesNames.contains(name)) {
                throw new ClassNotFoundException(name);
            }
            return this.classesByName.get(name);
        }
    }

    private static class TestObjectType
    implements ObjectType {
        private final String className;

        private TestObjectType(String className) {
            this.className = className;
        }

        public Optional<MetadataType> getOpenRestriction() {
            return Optional.empty();
        }

        public Collection<ObjectFieldType> getFields() {
            return null;
        }

        public boolean isOrdered() {
            return false;
        }

        public Optional<ObjectFieldType> getFieldByName(String propertyName) {
            return Optional.empty();
        }

        public MetadataFormat getMetadataFormat() {
            return null;
        }

        public <T extends TypeAnnotation> Optional<T> getAnnotation(Class<T> annotation) {
            if (annotation.equals(TypeIdAnnotation.class)) {
                return Optional.of(new TypeIdAnnotation(this.className));
            }
            return Optional.empty();
        }

        public Set<TypeAnnotation> getAnnotations() {
            return null;
        }

        public Optional<String> getDescription() {
            return Optional.empty();
        }

        public void accept(MetadataTypeVisitor visitor) {
            visitor.visitObject((ObjectType)this);
        }
    }
}

