/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.dto.factory;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.internal.serialization.dto.ComponentAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentMetadataAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentParameterAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ExtensionModelDTO;
import org.mule.runtime.ast.internal.serialization.dto.factory.AstDTOFactoryProvider;
import org.mule.runtime.ast.internal.serialization.dto.factory.ComponentMetadataAstDTOFactory;
import org.mule.runtime.ast.internal.serialization.dto.factory.ComponentParameterAstDTOFactory;
import org.mule.runtime.ast.internal.serialization.dto.factory.ExtensionModelDTOFactory;
import org.mule.runtime.ast.testobjects.TestArtifactAstFactory;

@Feature(value="AST serialization")
@Story(value="AST serializable representation")
public class ComponentAstDTOFactoryTestCase {
    private TestArtifactAstFactory testArtifactAstFactory;
    private AstDTOFactoryProvider astDTOFactoryProvider;
    private ExtensionModelDTOFactory extensionModelDTOFactory;
    private ComponentMetadataAstDTOFactory componentMetadataAstDTOFactory;
    private ComponentParameterAstDTOFactory componentParameterAstDTOFactory;
    private ExtensionModelDTO extensionModelDTO;
    private ComponentMetadataAstDTO componentMetadataAstDTO;
    private ComponentParameterAstDTO componentParameterAstDTO;
    private Set<ExtensionModel> extensionModels;

    @Before
    public void setUp() throws Exception {
        this.testArtifactAstFactory = new TestArtifactAstFactory();
        this.extensionModelDTOFactory = (ExtensionModelDTOFactory)Mockito.mock(ExtensionModelDTOFactory.class);
        this.extensionModelDTO = new ExtensionModelDTO("Some name");
        Mockito.when((Object)this.extensionModelDTOFactory.from((ExtensionModel)ArgumentMatchers.any(ExtensionModel.class))).thenReturn((Object)this.extensionModelDTO);
        this.componentMetadataAstDTOFactory = (ComponentMetadataAstDTOFactory)Mockito.mock(ComponentMetadataAstDTOFactory.class);
        this.componentMetadataAstDTO = new ComponentMetadataAstDTO(null, null, null, null, null, null, null, null, null, null);
        Mockito.when((Object)this.componentMetadataAstDTOFactory.from((ComponentMetadataAst)ArgumentMatchers.any(ComponentMetadataAst.class))).thenReturn((Object)this.componentMetadataAstDTO);
        this.componentParameterAstDTOFactory = (ComponentParameterAstDTOFactory)Mockito.mock(ComponentParameterAstDTOFactory.class);
        this.componentParameterAstDTO = new ComponentParameterAstDTO(null, null, false, null, null, null);
        Mockito.when((Object)this.componentParameterAstDTOFactory.from((ComponentParameterAst)ArgumentMatchers.any(ComponentParameterAst.class))).thenReturn((Object)this.componentParameterAstDTO);
        this.astDTOFactoryProvider = new TestAstDTOFactoryProvider();
    }

    @Test
    public void testMappingSimpleHttpAppConfigComponent() {
        this.extensionModels = this.testArtifactAstFactory.extensionModelsSetForTests();
        ArtifactAst simpleHttpArtifact = this.testArtifactAstFactory.createArtifactFromXmlFile("test-apps/http-listener-with-logger.xml", this.extensionModels);
        MatcherAssert.assertThat((Object)simpleHttpArtifact.topLevelComponentsStream().count(), (Matcher)Matchers.is((Object)2L));
        ComponentAst config = simpleHttpArtifact.topLevelComponentsStream().filter(componentAst -> "listener-config".equals(componentAst.getIdentifier().getName())).findFirst().get();
        ComponentAstDTO configDTO = this.astDTOFactoryProvider.getComponentAstDTOFactory().from(config);
        this.assertDTOIsAnalogToComponentAST(config, configDTO);
        ((ExtensionModelDTOFactory)Mockito.verify((Object)this.extensionModelDTOFactory, (VerificationMode)Mockito.times((int)2))).from((ExtensionModel)ArgumentMatchers.any(ExtensionModel.class));
    }

    @Test
    public void testMappingSimpleHttpAppFlowComponent() {
        this.extensionModels = this.testArtifactAstFactory.extensionModelsSetForTests();
        ArtifactAst simpleHttpArtifact = this.testArtifactAstFactory.createArtifactFromXmlFile("test-apps/http-listener-with-logger.xml", this.extensionModels);
        MatcherAssert.assertThat((Object)simpleHttpArtifact.topLevelComponentsStream().count(), (Matcher)Matchers.is((Object)2L));
        ComponentAst flow = simpleHttpArtifact.topLevelComponentsStream().filter(componentAst -> "flow".equals(componentAst.getIdentifier().getName())).findFirst().get();
        ComponentAstDTO flowDTO = this.astDTOFactoryProvider.getComponentAstDTOFactory().from(flow);
        this.assertDTOIsAnalogToComponentAST(flow, flowDTO);
        MatcherAssert.assertThat((Object)flowDTO.directChildrenStream().count(), (Matcher)Matchers.is((Object)2L));
        flow.directChildrenStream().forEach(componentAst -> {
            ComponentAstDTO componentAstDTO = this.astDTOFactoryProvider.getComponentAstDTOFactory().from(componentAst);
            this.assertDTOIsAnalogToComponentAST((ComponentAst)componentAst, componentAstDTO);
        });
        ((ExtensionModelDTOFactory)Mockito.verify((Object)this.extensionModelDTOFactory, (VerificationMode)Mockito.times((int)5))).from((ExtensionModel)ArgumentMatchers.any(ExtensionModel.class));
    }

    private void assertDTOIsAnalogToComponentAST(ComponentAst componentAst, ComponentAstDTO componentAstDTO) {
        MatcherAssert.assertThat((Object)componentAstDTO.getIdentifier(), (Matcher)Matchers.is((Object)componentAst.getIdentifier()));
        MatcherAssert.assertThat((Object)componentAstDTO.getLocation(), (Matcher)Matchers.is((Object)componentAst.getLocation()));
        MatcherAssert.assertThat((Object)componentAstDTO.getComponentId(), (Matcher)Matchers.is((Object)componentAst.getComponentId()));
        MatcherAssert.assertThat((Object)componentAstDTO.getComponentType(), (Matcher)Matchers.is((Object)componentAst.getComponentType()));
        if (componentAst.getExtensionModel() != null) {
            MatcherAssert.assertThat((Object)componentAstDTO.getExtensionModelDTO(), (Matcher)Matchers.is((Object)this.extensionModelDTO));
        }
        if (componentAst.getMetadata() != null) {
            InOrder order = Mockito.inOrder((Object[])new Object[]{this.componentMetadataAstDTOFactory, this.componentMetadataAstDTOFactory});
            ((ComponentMetadataAstDTOFactory)order.verify((Object)this.componentMetadataAstDTOFactory, Mockito.times((int)1))).from(componentAst.getMetadata());
            MatcherAssert.assertThat((Object)componentAstDTO.getMetadata(), (Matcher)Matchers.is((Object)this.componentMetadataAstDTO));
        }
        componentAst.getParameters().forEach(param -> {
            InOrder order = Mockito.inOrder((Object[])new Object[]{this.componentParameterAstDTOFactory, this.componentParameterAstDTOFactory});
            ((ComponentParameterAstDTOFactory)order.verify((Object)this.componentParameterAstDTOFactory, Mockito.times((int)1))).from(param);
        });
        if (!componentAst.getParameters().isEmpty()) {
            MatcherAssert.assertThat((Object)componentAstDTO.getParameters().size(), (Matcher)Matchers.is((Object)componentAst.getParameters().size()));
            componentAstDTO.getParameters().forEach(paramDTO -> MatcherAssert.assertThat((Object)paramDTO, (Matcher)Matchers.is((Object)this.componentParameterAstDTO)));
        }
        MatcherAssert.assertThat((Object)componentAstDTO.getParameters(), (Matcher)Matchers.hasSize((int)componentAst.getParameters().size()));
        MatcherAssert.assertThat((Object)componentAstDTO.getType(), (Matcher)Matchers.is((Object)componentAst.getType()));
        if (componentAst.getAnnotations() != null) {
            MatcherAssert.assertThat((Object)componentAstDTO.getAnnotations(), (Matcher)Matchers.is((Object)componentAst.getAnnotations()));
        }
    }

    private class TestAstDTOFactoryProvider
    extends AstDTOFactoryProvider {
        private TestAstDTOFactoryProvider() {
        }

        public ExtensionModelDTOFactory getExtensionModelDTOFactory() {
            return ComponentAstDTOFactoryTestCase.this.extensionModelDTOFactory;
        }

        public ComponentMetadataAstDTOFactory getComponentMetadataAstDTOFactory() {
            return ComponentAstDTOFactoryTestCase.this.componentMetadataAstDTOFactory;
        }

        public ComponentParameterAstDTOFactory getComponentParameterAstDTOFactory() {
            return ComponentAstDTOFactoryTestCase.this.componentParameterAstDTOFactory;
        }
    }
}

