/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.dto.factory;

import com.google.common.collect.Lists;
import com.google.gson.internal.LinkedTreeMap;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.ParameterResolutionException;
import org.mule.runtime.ast.internal.serialization.dto.ComponentAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentMetadataAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentParameterAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.factory.AstDTOFactoryProvider;
import org.mule.runtime.ast.internal.serialization.dto.factory.ComponentMetadataAstDTOFactory;
import org.mule.runtime.extension.api.error.ErrorMapping;

@Feature(value="AST serialization")
@Story(value="AST serializable representation")
public class ComponentParameterAstDTOFactoryTestCase {
    private String unresolvedValue;
    private String resolvedRawValue;
    private Either<String, Object> value;
    private boolean defaultValue;
    private ComponentParameterAst componentParameterAst;
    private ComponentParameterAstDTO componentParameterAstDTO;
    private AstDTOFactoryProvider astDTOFactoryProvider;
    private ComponentMetadataAst componentMetadataAst;
    private ComponentMetadataAstDTOFactory componentMetadataAstDTOFactory;
    private ParameterModel parameterModel;

    @Before
    public void setUp() throws Exception {
        this.astDTOFactoryProvider = new AstDTOFactoryProvider(){

            public ComponentMetadataAstDTOFactory getComponentMetadataAstDTOFactory() {
                return ComponentParameterAstDTOFactoryTestCase.this.componentMetadataAstDTOFactory;
            }
        };
        this.unresolvedValue = null;
        this.resolvedRawValue = null;
        this.value = Either.empty();
        this.defaultValue = false;
        this.parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)this.parameterModel.getName()).thenReturn((Object)"some parameter model name");
        this.componentParameterAst = new TestComponentParameterAst();
    }

    @Test
    public void testBuildReturnsComponentParameterAstDTOWithInputSerializableAttributes_WhenBuildingFromComponentParameterAstWithSetSerializableAttributes() {
        this.unresolvedValue = "some unresolved value";
        this.resolvedRawValue = "some resolved raw value";
        this.value = Either.right((Object)"some value");
        this.defaultValue = true;
        this.componentParameterAstDTO = this.astDTOFactoryProvider.getComponentParameterAstDTOFactory().from(this.componentParameterAst);
        MatcherAssert.assertThat((Object)this.componentParameterAstDTO.getRawValue(), (Matcher)Matchers.is((Object)this.componentParameterAst.getRawValue()));
        MatcherAssert.assertThat((Object)this.componentParameterAstDTO.getResolvedRawValue(), (Matcher)Matchers.is(this.value.getValue().get()));
        MatcherAssert.assertThat((Object)this.componentParameterAstDTO.getValue().getRight(), (Matcher)Matchers.is((Object)this.componentParameterAst.getValue().getRight()));
        MatcherAssert.assertThat((Object)this.componentParameterAstDTO.isDefaultValue(), (Matcher)Matchers.is((Object)this.componentParameterAst.isDefaultValue()));
    }

    @Test
    public void testBuildReturnsComponentParameterAstDTOWithComponentAstAsValue_WhenBuildingFromComponentParameterAstWithComponentAstAsValue() {
        this.unresolvedValue = "some unresolved value";
        this.resolvedRawValue = "some resolved raw value";
        this.value = Either.right((Object)this.testComponentAstDTO());
        this.defaultValue = true;
        this.componentParameterAstDTO = this.astDTOFactoryProvider.getComponentParameterAstDTOFactory().from(this.componentParameterAst);
        MatcherAssert.assertThat((Object)this.componentParameterAstDTO.getRawValue(), (Matcher)Matchers.is((Object)this.componentParameterAst.getRawValue()));
        MatcherAssert.assertThat((Object)this.componentParameterAstDTO.getResolvedRawValue(), (Matcher)Matchers.is((Object)this.componentParameterAst.getRawValue()));
        MatcherAssert.assertThat((Object)((ComponentAstDTO)this.componentParameterAstDTO.getValue().getRight()).getIdentifier().getName(), (Matcher)Matchers.is((Object)((ComponentAstDTO)this.componentParameterAst.getValue().getRight()).getIdentifier().getName()));
        MatcherAssert.assertThat((Object)this.componentParameterAstDTO.isDefaultValue(), (Matcher)Matchers.is((Object)this.componentParameterAst.isDefaultValue()));
    }

    @Test
    public void testBuildReturnsComponentParameterAstDTOWithListOfComponentAstsAsValue_WhenBuildingFromComponentParameterAstWithListOfComponentAstsAsValue() {
        this.unresolvedValue = "some unresolved value";
        this.resolvedRawValue = "some resolved raw value";
        ComponentAstDTO componentAstDTO = this.testComponentAstDTO();
        this.value = Either.right((Object)Lists.newArrayList((Object[])new ComponentAstDTO[]{componentAstDTO}));
        this.defaultValue = true;
        this.componentParameterAstDTO = this.astDTOFactoryProvider.getComponentParameterAstDTOFactory().from(this.componentParameterAst);
        MatcherAssert.assertThat((Object)this.componentParameterAstDTO.getRawValue(), (Matcher)Matchers.is((Object)this.componentParameterAst.getRawValue()));
        MatcherAssert.assertThat((Object)this.componentParameterAstDTO.getResolvedRawValue(), (Matcher)Matchers.is((Object)this.componentParameterAst.getRawValue()));
        MatcherAssert.assertThat((Object)((ComponentAstDTO)((List)this.componentParameterAstDTO.getValue().getRight()).get(0)).getIdentifier().getName(), (Matcher)Matchers.is((Object)((ComponentAstDTO)((List)this.componentParameterAst.getValue().getRight()).get(0)).getIdentifier().getName()));
        MatcherAssert.assertThat((Object)this.componentParameterAstDTO.isDefaultValue(), (Matcher)Matchers.is((Object)this.componentParameterAst.isDefaultValue()));
    }

    @Test
    public void testBuildReturnsComponentParameterAstDTOWithEmptyListValue_WhenBuildingFromComponentParameterAstWithEmptyListAsValue() {
        this.unresolvedValue = "some unresolved value";
        this.resolvedRawValue = "some resolved raw value";
        this.value = Either.right((Object)Lists.newArrayList());
        this.defaultValue = true;
        this.componentParameterAstDTO = this.astDTOFactoryProvider.getComponentParameterAstDTOFactory().from(this.componentParameterAst);
        MatcherAssert.assertThat((Object)this.componentParameterAstDTO.getRawValue(), (Matcher)Matchers.is((Object)this.componentParameterAst.getRawValue()));
        MatcherAssert.assertThat((Object)this.componentParameterAstDTO.getResolvedRawValue(), (Matcher)Matchers.is((Object)this.componentParameterAst.getRawValue()));
        MatcherAssert.assertThat((Object)((List)this.componentParameterAstDTO.getValue().getRight()).size(), (Matcher)Matchers.is((Object)((List)this.componentParameterAst.getValue().getRight()).size()));
        MatcherAssert.assertThat((Object)this.componentParameterAstDTO.isDefaultValue(), (Matcher)Matchers.is((Object)this.componentParameterAst.isDefaultValue()));
    }

    @Test
    public void testBuildReturnsComponentParameterAstDTOWithErrorMappingListValue_WhenBuildingFromComponentParameterAstWithErrorMappingListAsValue() {
        this.unresolvedValue = "some unresolved value";
        this.resolvedRawValue = "some resolved raw value in the original";
        this.value = Either.right((Object)Lists.newArrayList((Object[])new ErrorMapping[]{new ErrorMapping("source", "target")}));
        this.defaultValue = true;
        this.componentParameterAstDTO = this.astDTOFactoryProvider.getComponentParameterAstDTOFactory().from(this.componentParameterAst);
        MatcherAssert.assertThat((Object)this.componentParameterAstDTO.getRawValue(), (Matcher)Matchers.is((Object)this.componentParameterAst.getRawValue()));
        MatcherAssert.assertThat((Object)this.componentParameterAstDTO.getResolvedRawValue(), (Matcher)Matchers.is((Object)this.componentParameterAst.getRawValue()));
        MatcherAssert.assertThat((Object)((List)this.componentParameterAstDTO.getValue().getRight()).size(), (Matcher)Matchers.is((Object)((List)this.componentParameterAst.getValue().getRight()).size()));
        MatcherAssert.assertThat((Object)((ErrorMapping)((List)this.componentParameterAstDTO.getValue().getRight()).get(0)).getSource(), (Matcher)Matchers.is((Object)"source"));
        MatcherAssert.assertThat((Object)((ErrorMapping)((List)this.componentParameterAstDTO.getValue().getRight()).get(0)).getTarget(), (Matcher)Matchers.is((Object)"target"));
        MatcherAssert.assertThat((Object)this.componentParameterAstDTO.isDefaultValue(), (Matcher)Matchers.is((Object)this.componentParameterAst.isDefaultValue()));
    }

    @Test
    public void testBuildReturnsComponentParameterAstDTOWithStringListValue_WhenBuildingFromComponentParameterAstWithStringListAsValue() {
        this.unresolvedValue = "some unresolved value";
        this.resolvedRawValue = "some resolved raw value";
        this.value = Either.right((Object)Lists.newArrayList((Object[])new String[]{"Aruba", "Jamaica", "Bermuda", "Bahamas", "Key Largo", "Montego", "Kokomo"}));
        this.defaultValue = true;
        this.componentParameterAstDTO = this.astDTOFactoryProvider.getComponentParameterAstDTOFactory().from(this.componentParameterAst);
        MatcherAssert.assertThat((Object)this.componentParameterAstDTO.getRawValue(), (Matcher)Matchers.is((Object)this.componentParameterAst.getRawValue()));
        MatcherAssert.assertThat((Object)this.componentParameterAstDTO.getResolvedRawValue(), (Matcher)Matchers.is((Object)this.componentParameterAst.getRawValue()));
        MatcherAssert.assertThat((Object)((List)this.componentParameterAstDTO.getValue().getRight()).size(), (Matcher)Matchers.is((Object)((List)this.componentParameterAst.getValue().getRight()).size()));
        MatcherAssert.assertThat((Object)this.componentParameterAstDTO.isDefaultValue(), (Matcher)Matchers.is((Object)this.componentParameterAst.isDefaultValue()));
    }

    @Test
    public void testBuildReturnsComponentParameterAstDTOWithLinkedTreeMapValue_WhenBuildingFromComponentParameterAstWithLinkedTreeMapAsValue() {
        this.unresolvedValue = "some unresolved value";
        this.resolvedRawValue = "some resolved raw value";
        LinkedTreeMap map = new LinkedTreeMap();
        map.put((Object)"some key", (Object)"some value");
        this.value = Either.right((Object)map);
        this.defaultValue = true;
        this.componentParameterAstDTO = this.astDTOFactoryProvider.getComponentParameterAstDTOFactory().from(this.componentParameterAst);
        MatcherAssert.assertThat((Object)this.componentParameterAstDTO.getRawValue(), (Matcher)Matchers.is((Object)this.componentParameterAst.getRawValue()));
        MatcherAssert.assertThat((Object)this.componentParameterAstDTO.getResolvedRawValue(), (Matcher)Matchers.is((Object)this.componentParameterAst.getRawValue()));
        MatcherAssert.assertThat(((Map)this.componentParameterAstDTO.getValue().getRight()).get("some key"), (Matcher)Matchers.is(((Map)this.componentParameterAst.getValue().getRight()).get("some key")));
        MatcherAssert.assertThat(((Map)this.componentParameterAstDTO.getValue().getRight()).get("some key"), (Matcher)Matchers.is((Object)"some value"));
        MatcherAssert.assertThat((Object)this.componentParameterAstDTO.isDefaultValue(), (Matcher)Matchers.is((Object)this.componentParameterAst.isDefaultValue()));
    }

    @Test
    public void testBuildReturnsComponentParameterAstDTOWithMetadataDTO_WhenBuildingFromComponentParameterAstWithMetadata() {
        this.componentMetadataAst = (ComponentMetadataAst)Mockito.mock(ComponentMetadataAst.class);
        ComponentMetadataAstDTO componentMetadataAstDTO = new ComponentMetadataAstDTO(null, null, null, null, null, null, null, null, null, null);
        this.componentMetadataAstDTOFactory = (ComponentMetadataAstDTOFactory)Mockito.mock(ComponentMetadataAstDTOFactory.class);
        Mockito.when((Object)this.componentMetadataAstDTOFactory.from(this.componentMetadataAst)).thenReturn((Object)componentMetadataAstDTO);
        this.componentParameterAstDTO = this.astDTOFactoryProvider.getComponentParameterAstDTOFactory().from(this.componentParameterAst);
        MatcherAssert.assertThat((Object)this.componentParameterAstDTO.getMetadata(), (Matcher)Matchers.is(Optional.of(componentMetadataAstDTO)));
    }

    private ComponentAstDTO testComponentAstDTO() {
        return new ComponentAstDTO(Collections.emptyList(), TypedComponentIdentifier.ComponentType.UNKNOWN.toString(), ComponentIdentifier.builder().name("a name").namespace("prefix").namespaceUri("uri").build(), (ComponentLocation)Mockito.mock(ComponentLocation.class), null, Collections.emptyList(), null, null, null, null, null);
    }

    private class TestComponentParameterAst
    implements ComponentParameterAst {
        private TestComponentParameterAst() {
        }

        public ParameterModel getModel() {
            return ComponentParameterAstDTOFactoryTestCase.this.parameterModel;
        }

        public ParameterGroupModel getGroupModel() {
            return null;
        }

        public <T> Either<String, T> getValue() {
            return ComponentParameterAstDTOFactoryTestCase.this.value;
        }

        public <T> Either<String, Either<ParameterResolutionException, T>> getValueOrResolutionError() {
            try {
                return this.getValue().mapRight(fixedValue -> Either.right((Object)fixedValue));
            }
            catch (ParameterResolutionException e) {
                return Either.right((Object)Either.left((Object)((Object)e)));
            }
        }

        public String getRawValue() {
            return ComponentParameterAstDTOFactoryTestCase.this.unresolvedValue;
        }

        public String getResolvedRawValue() {
            return ComponentParameterAstDTOFactoryTestCase.this.resolvedRawValue;
        }

        public Optional<ComponentMetadataAst> getMetadata() {
            return Optional.ofNullable(ComponentParameterAstDTOFactoryTestCase.this.componentMetadataAst);
        }

        public ComponentGenerationInformation getGenerationInformation() {
            return null;
        }

        public boolean isDefaultValue() {
            return ComponentParameterAstDTOFactoryTestCase.this.defaultValue;
        }
    }
}

