/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.json;

import com.google.gson.Gson;
import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.internal.serialization.dto.ArtifactAstDTO;
import org.mule.runtime.ast.internal.serialization.json.JsonArtifactAstSerializer;
import org.mule.runtime.ast.testobjects.TestArtifactAstFactory;

@Feature(value="AST serialization")
@Story(value="AST Json serialization")
public class JsonArtifactAstSerializerTestCase {
    private JsonArtifactAstSerializer jsonArtifactAstSerializer;
    private TestArtifactAstFactory testArtifactAstFactory;
    private Set<ExtensionModel> extensionModels;
    private Gson gsonMock;

    @Before
    public void setUp() {
        this.jsonArtifactAstSerializer = new JsonArtifactAstSerializer((Executor)Executors.newSingleThreadExecutor());
        this.testArtifactAstFactory = new TestArtifactAstFactory();
        this.extensionModels = this.testArtifactAstFactory.extensionModelsSetForTests();
        this.gsonMock = (Gson)Mockito.mock(Gson.class);
    }

    @Test
    @Description(value="The JsonArtifactAstSerializer adds a header when serializing an artifact that says its a Json and the serializer version used")
    public void testSerializeReturnsAnInputStreamWithAHeaderOfJsonV100WhenSerializingAnArtifact() throws IOException {
        ArtifactAst emptyArtifact = this.testArtifactAstFactory.createArtifactFromXmlFile("test-apps/trivial.xml", this.extensionModels);
        InputStream result = this.jsonArtifactAstSerializer.serialize(emptyArtifact);
        String headerString = this.readHeaderString(result);
        String[] headerArray = headerString.trim().split("#");
        MatcherAssert.assertThat((Object)headerArray[0], (Matcher)Matchers.is((Object)"JSON"));
        MatcherAssert.assertThat((Object)headerArray[1], (Matcher)Matchers.is((Object)"1.0"));
    }

    @Test
    public void testSerializeReturnsAnInputStreamOfATrivialAppJson_WhenArtifactIsTrivial() throws IOException {
        ArtifactAst emptyArtifact = this.testArtifactAstFactory.createArtifactFromXmlFile("test-apps/trivial.xml", this.extensionModels);
        InputStream result = this.jsonArtifactAstSerializer.serialize(emptyArtifact);
        this.readHeaderString(result);
        String jsonString = IOUtils.toString((InputStream)result, (Charset)Charset.defaultCharset());
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.containsString((String)"{\"artifactName\":\"artifact\",\"artifactType\":\"APPLICATION\",\"dependencies\":["));
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.containsString((String)"{\"name\":\"mule\"}"));
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.containsString((String)"{\"name\":\"tls\"}"));
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.containsString((String)"{\"name\":\"http\"}"));
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.containsString((String)"{\"name\":\"wsc\"}"));
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.containsString((String)"{\"name\":\"file\"}"));
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.containsString((String)"{\"name\":\"os\"}"));
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.containsString((String)"{\"name\":\"db\"}"));
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.containsString((String)"],\"topLevelComponentAsts\":[]"));
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.containsString((String)"\"errorTypeRepository\":{\"hierarchy\":[{\"identifier\":\"ANY\",\"namespace\":\"MULE\",\"internal\":false,\"children\":[{\"identifier\":\"EXPRESSION\",\"namespace\":\"MULE\",\"internal\":false,\"children\":[]},{\"identifier\":\"TIMEOUT\",\"namespace\":\"MULE\",\"internal\":false,\"children\":[]},{\"identifier\":\"CONNECTIVITY\",\"namespace\":\"MULE\",\"internal\":false,\"children\":[{\"identifier\":\"RETRY_EXHAUSTED\",\"namespace\":\"MULE\",\"internal\":false,\"children\":[]}]},{\"identifier\":\"ROUTING\",\"namespace\":\"MULE\",\"internal\":false,\"children\":[{\"identifier\":\"COMPOSITE_ROUTING\",\"namespace\":\"MULE\",\"internal\":false,\"children\":[]}]},{\"identifier\":\"STREAM_MAXIMUM_SIZE_EXCEEDED\",\"namespace\":\"MULE\",\"internal\":false,\"children\":[]},{\"identifier\":\"SECURITY\",\"namespace\":\"MULE\",\"internal\":false,\"children\":[{\"identifier\":\"SERVER_SECURITY\",\"namespace\":\"MULE\",\"internal\":false,\"children\":[{\"identifier\":\"NOT_PERMITTED\",\"namespace\":\"MULE\",\"internal\":false,\"children\":[]}]},{\"identifier\":\"CLIENT_SECURITY\",\"namespace\":\"MULE\",\"internal\":false,\"children\":[]}]},{\"identifier\":\"VALIDATION\",\"namespace\":\"MULE\",\"internal\":false,\"children\":[{\"identifier\":\"DUPLICATE_MESSAGE\",\"namespace\":\"MULE\",\"internal\":false,\"children\":[]}]},{\"identifier\":\"TRANSFORMATION\",\"namespace\":\"MULE\",\"internal\":false,\"children\":[]},{\"identifier\":\"REDELIVERY_EXHAUSTED\",\"namespace\":\"MULE\",\"internal\":false,\"children\":[]},{\"identifier\":\"SOURCE\",\"namespace\":\"MULE\",\"internal\":true,\"children\":[{\"identifier\":\"SOURCE_RESPONSE\",\"namespace\":\"MULE\",\"internal\":false,\"children\":[{\"identifier\":\"SOURCE_RESPONSE_GENERATE\",\"namespace\":\"MULE\",\"internal\":false,\"children\":[]},{\"identifier\":\"SOURCE_RESPONSE_SEND\",\"namespace\":\"MULE\",\"internal\":false,\"children\":[]}]},{\"identifier\":\"SOURCE_ERROR_RESPONSE_GENERATE\",\"namespace\":\"MULE\",\"internal\":true,\"children\":[]},{\"identifier\":\"SOURCE_ERROR_RESPONSE_SEND\",\"namespace\":\"MULE\",\"internal\":true,\"children\":[]}]},{\"identifier\":\"UNKNOWN\",\"namespace\":\"MULE\",\"internal\":true,\"children\":[]}]},{\"identifier\":\"CRITICAL\",\"namespace\":\"MULE\",\"internal\":true,\"children\":[{\"identifier\":\"FATAL_JVM_ERROR\",\"namespace\":\"MULE\",\"internal\":true,\"children\":[]},{\"identifier\":\"OVERLOAD\",\"namespace\":\"MULE\",\"internal\":true,\"children\":[{\"identifier\":\"FLOW_BACK_PRESSURE\",\"namespace\":\"MULE\",\"internal\":true,\"children\":[]}]}]}]"));
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.containsString((String)"]},\"importedResources\":[]}"));
    }

    @Test
    public void testSerializeCallsGsonWithArtifactAstDTO_WhenSerializingArtifactAst() throws IOException {
        this.jsonArtifactAstSerializer = new JsonArtifactAstSerializer(this.gsonMock, (Executor)Executors.newSingleThreadExecutor());
        ArtifactAst trivialArtifact = this.testArtifactAstFactory.createArtifactFromXmlFile("test-apps/trivial.xml", this.extensionModels);
        Mockito.when((Object)this.gsonMock.toJson(ArgumentMatchers.any(ArtifactAstDTO.class))).thenReturn((Object)"{\"dependenciesDTOs\":[{\"name\":\"mule\"}],\"topLevelComponentAsts\":[],\"parent\":{}}");
        InputStream serialize = this.jsonArtifactAstSerializer.serialize(trivialArtifact);
        String string = IOUtils.toString((InputStream)serialize, (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)string, (Matcher)Matchers.is((Object)"JSON#1.0#UTF-8#\n"));
        ((Gson)Mockito.verify((Object)this.gsonMock, (VerificationMode)Mockito.times((int)1))).toJson(ArgumentMatchers.any(ArtifactAstDTO.class), (Appendable)ArgumentMatchers.any(Writer.class));
    }

    @Test
    public void testSerializeCallsExecutorWithARunnable_WhenSerializingArtifactAst() {
        Executor executor = (Executor)Mockito.spy((Object)Executors.newSingleThreadExecutor());
        this.jsonArtifactAstSerializer = new JsonArtifactAstSerializer(this.gsonMock, executor);
        ArtifactAst trivialArtifact = this.testArtifactAstFactory.createArtifactFromXmlFile("test-apps/trivial.xml", this.extensionModels);
        Mockito.when((Object)this.gsonMock.toJson(ArgumentMatchers.any(ArtifactAstDTO.class))).thenReturn((Object)"{\"dependenciesDTOs\":[{\"name\":\"mule\"}],\"topLevelComponentAsts\":[],\"parent\":{}}");
        this.jsonArtifactAstSerializer.serialize(trivialArtifact);
        ((Executor)Mockito.verify((Object)executor, (VerificationMode)Mockito.times((int)1))).execute((Runnable)ArgumentMatchers.any(Runnable.class));
    }

    private String readHeaderString(InputStream result) throws IOException {
        return new BufferedReader(new InputStreamReader(result)).readLine();
    }
}

