/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.json.gson;

import com.google.gson.Gson;
import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

@Feature(value="AST serialization")
@Stories(value={@Story(value="AST Json serialization"), @Story(value="AST Json deserialization"), @Story(value="AST serialization versioning")})
public class GsonChangesToleranceTestCase {
    @Test
    @Description(value="Gson tolerates older Jsons with missing attributes using different new object to deserialize")
    public void testNewVersionHasMoreAttributesAndSerializedIsOldAndDeserializerNew() {
        Gson gson = new Gson();
        String jsonString = gson.toJson((Object)new OldVersion("one", "two"));
        NewAttributesVersion newAttributesVersion = (NewAttributesVersion)gson.fromJson(jsonString, NewAttributesVersion.class);
        MatcherAssert.assertThat((Object)newAttributesVersion.getOldAttribute1(), (Matcher)Matchers.is((Object)"one"));
        MatcherAssert.assertThat((Object)newAttributesVersion.getOldAttribute2(), (Matcher)Matchers.is((Object)"two"));
        MatcherAssert.assertThat((Object)newAttributesVersion.getNewAttribute(), (Matcher)Matchers.nullValue());
    }

    @Test
    @Description(value="Gson tolerates older Jsons with missing attributes using extended old object to deserialize")
    public void testExtendedOlVersionHasMoreAttributesAndSerializedIsOldAndDeserializerExtended() {
        Gson gson = new Gson();
        String jsonString = gson.toJson((Object)new OldVersion("one", "two"));
        ExtendedOldVersion newVersion = (ExtendedOldVersion)gson.fromJson(jsonString, ExtendedOldVersion.class);
        MatcherAssert.assertThat((Object)newVersion.getOldAttribute1(), (Matcher)Matchers.is((Object)"one"));
        MatcherAssert.assertThat((Object)newVersion.getOldAttribute2(), (Matcher)Matchers.is((Object)"two"));
        MatcherAssert.assertThat((Object)newVersion.getExtendedAttribute(), (Matcher)Matchers.nullValue());
    }

    @Test
    @Description(value="Gson tolerates inner objects of an older version with less attributes")
    public void testNewVersionHasMoreAttributesAndSerializedIsOldInsideAnotherObjectAndDeserializerNew() {
        Gson gson = new Gson();
        String jsonString = gson.toJson((Object)new HighOrderObjectOld(new OldVersion("one", "two")));
        HighOrderObjectNew highOrderObjectNew = (HighOrderObjectNew)gson.fromJson(jsonString, HighOrderObjectNew.class);
        MatcherAssert.assertThat((Object)highOrderObjectNew.getInner().getOldAttribute1(), (Matcher)Matchers.is((Object)"one"));
        MatcherAssert.assertThat((Object)highOrderObjectNew.getInner().getOldAttribute2(), (Matcher)Matchers.is((Object)"two"));
        MatcherAssert.assertThat((Object)highOrderObjectNew.getInner().getNewAttribute(), (Matcher)Matchers.nullValue());
    }

    @Test
    @Description(value="Gson tolerates jsons of newer versions with extra attributes")
    public void testNewVersionHasMoreAttributesAndSerializedIsNewAndDeserializerOld() {
        Gson gson = new Gson();
        String jsonString = gson.toJson((Object)new NewAttributesVersion("one", "two", "three"));
        OldVersion oldVersion = (OldVersion)gson.fromJson(jsonString, OldVersion.class);
        MatcherAssert.assertThat((Object)oldVersion.getOldAttribute1(), (Matcher)Matchers.is((Object)"one"));
        MatcherAssert.assertThat((Object)oldVersion.getOldAttribute2(), (Matcher)Matchers.is((Object)"two"));
    }

    @Test
    @Description(value="Gson tolerates jsons of newer versions extended from the old with extra attributes")
    public void testExtendedVersionHasMoreAttributesAndSerializedIsExtendedOldAndDeserializerOld() {
        Gson gson = new Gson();
        String jsonString = gson.toJson((Object)new ExtendedOldVersion("one", "two", "three"));
        OldVersion oldVersion = (OldVersion)gson.fromJson(jsonString, OldVersion.class);
        MatcherAssert.assertThat((Object)oldVersion.getOldAttribute1(), (Matcher)Matchers.is((Object)"one"));
        MatcherAssert.assertThat((Object)oldVersion.getOldAttribute2(), (Matcher)Matchers.is((Object)"two"));
    }

    @Test
    @Description(value="Gson tolerates inner objects of a newer version with more attributes")
    public void testNewVersionHasMoreAttributesAndSerializedIsNewInsideAnotherObjectAndDeserializerOld() {
        Gson gson = new Gson();
        String jsonString = gson.toJson((Object)new HighOrderObjectNew(new NewAttributesVersion("one", "two", "three")));
        HighOrderObjectOld highOrderObjectOld = (HighOrderObjectOld)gson.fromJson(jsonString, HighOrderObjectOld.class);
        MatcherAssert.assertThat((Object)highOrderObjectOld.getInner().getOldAttribute1(), (Matcher)Matchers.is((Object)"one"));
        MatcherAssert.assertThat((Object)highOrderObjectOld.getInner().getOldAttribute2(), (Matcher)Matchers.is((Object)"two"));
    }

    @Test
    @Description(value="Gson tolerates type differences in equally named attributes if content can be converted")
    public void testIncompatibleVersionChangedAttributeTypeAndSerializedIsOldAndDeserializerIncompatible() {
        Gson gson = new Gson();
        String jsonString = gson.toJson((Object)new OldVersion("one", "2"));
        StringIsNowIntVersion stringIsNowIntVersion = (StringIsNowIntVersion)gson.fromJson(jsonString, StringIsNowIntVersion.class);
        MatcherAssert.assertThat((Object)stringIsNowIntVersion.getOldAttribute1(), (Matcher)Matchers.is((Object)"one"));
        MatcherAssert.assertThat((Object)stringIsNowIntVersion.getOldAttribute2(), (Matcher)Matchers.is((Object)2));
    }

    private class HighOrderObjectNew {
        private NewAttributesVersion inner;

        public HighOrderObjectNew(NewAttributesVersion newAttributesVersion) {
            this.inner = newAttributesVersion;
        }

        public NewAttributesVersion getInner() {
            return this.inner;
        }
    }

    private class HighOrderObjectOld {
        private OldVersion inner;

        public HighOrderObjectOld(OldVersion oldVersion) {
            this.inner = oldVersion;
        }

        public OldVersion getInner() {
            return this.inner;
        }
    }

    private class ExtendedOldVersion
    extends OldVersion {
        private String extendedAttribute;

        public ExtendedOldVersion(String oldAttribute1, String oldAttribute2, String newAttribute) {
            super(oldAttribute1, oldAttribute2);
            this.extendedAttribute = newAttribute;
        }

        public String getExtendedAttribute() {
            return this.extendedAttribute;
        }
    }

    private class NewAttributesVersion {
        private String oldAttribute1;
        private String oldAttribute2;
        private String newAttribute;

        public NewAttributesVersion(String oldAttribute1, String oldAttribute2, String newAttribute) {
            this.oldAttribute1 = oldAttribute1;
            this.oldAttribute2 = oldAttribute2;
            this.newAttribute = newAttribute;
        }

        public String getOldAttribute1() {
            return this.oldAttribute1;
        }

        public String getOldAttribute2() {
            return this.oldAttribute2;
        }

        public String getNewAttribute() {
            return this.newAttribute;
        }
    }

    private class StringIsNowIntVersion {
        protected String oldAttribute1;
        protected Integer oldAttribute2;

        public StringIsNowIntVersion(String oldAttribute1, Integer oldAttribute2) {
            this.oldAttribute1 = oldAttribute1;
            this.oldAttribute2 = oldAttribute2;
        }

        public String getOldAttribute1() {
            return this.oldAttribute1;
        }

        public Integer getOldAttribute2() {
            return this.oldAttribute2;
        }
    }

    private class OldVersion {
        protected String oldAttribute1;
        protected String oldAttribute2;

        public OldVersion(String oldAttribute1, String oldAttribute2) {
            this.oldAttribute1 = oldAttribute1;
            this.oldAttribute2 = oldAttribute2;
        }

        public String getOldAttribute1() {
            return this.oldAttribute1;
        }

        public String getOldAttribute2() {
            return this.oldAttribute2;
        }
    }
}

