/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.testobjects;

import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.ast.testobjects.DummyConfigurationModel;
import org.mule.runtime.ast.testobjects.DummyConnectionProviderModel;
import org.mule.runtime.ast.testobjects.DummyExtensionModel;
import org.mule.runtime.ast.testobjects.DummyParameterGroupModel;
import org.mule.runtime.ast.testobjects.DummyParameterModel;
import org.mule.runtime.ast.testobjects.DummySourceModel;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.dsl.api.xml.parser.ParsingPropertyResolver;

public class TestArtifactAstFactory {
    private final ArtifactAst parentArtifact = null;
    private final ParsingPropertyResolver parsingPropertyResolver = s -> s;

    public ArtifactAst createArtifactFromXmlFile(String xmlResourcePath, Set<ExtensionModel> extensionModels) {
        AstXmlParser.Builder builder = new AstXmlParser.Builder();
        builder.withExtensionModels(extensionModels);
        builder.withParentArtifact(this.parentArtifact);
        builder.withPropertyResolver(this.parsingPropertyResolver);
        AstXmlParser xmlParser = builder.build();
        return xmlParser.parse(new URL[]{Thread.currentThread().getContextClassLoader().getResource(xmlResourcePath)});
    }

    public Set<ExtensionModel> extensionModelsSetForTests() {
        ExtensionModel muleExtensionModel = MuleExtensionModelProvider.getExtensionModel();
        ArrayList<OperationModel> httpOperationModels = new ArrayList<OperationModel>();
        DummyConnectionProviderModel httpListenerConnectionProviderModel = new DummyConnectionProviderModel("listener-connection", Collections.singletonList(new DummyParameterGroupModel("", Arrays.asList(new DummyParameterModel("host"), new DummyParameterModel("port")))));
        DummyConfigurationModel httpListenerConfigurationModel = new DummyConfigurationModel("listener-config", Collections.singletonList(new DummyParameterGroupModel("", Collections.singletonList(new DummyParameterModel("name")))), Collections.emptyList(), Collections.emptyList(), httpListenerConnectionProviderModel);
        DummyConnectionProviderModel httpRequesterConnectionProviderModel = new DummyConnectionProviderModel("request-connection", Collections.singletonList(new DummyParameterGroupModel("", Arrays.asList(new DummyParameterModel("host"), new DummyParameterModel("port")))));
        DummyConfigurationModel httpRequesterConfigurationModel = new DummyConfigurationModel("request-config", Collections.singletonList(new DummyParameterGroupModel("", Arrays.asList(new DummyParameterModel("name"), new DummyParameterModel("authentication")))), Collections.emptyList(), Collections.emptyList(), httpRequesterConnectionProviderModel);
        DummySourceModel httpListenerSourceModel = new DummySourceModel("listener", Collections.singletonList(new DummyParameterGroupModel("", Arrays.asList(new DummyParameterModel("path"), new DummyParameterModel("config-ref")))));
        ArrayList<ConstructModel> httpConstructModels = new ArrayList<ConstructModel>();
        DummyExtensionModel httpExtensionModel = new DummyExtensionModel("http", httpOperationModels, Arrays.asList(httpListenerConfigurationModel, httpRequesterConfigurationModel), Collections.singletonList(httpListenerSourceModel), httpConstructModels, Arrays.asList(httpListenerConnectionProviderModel, httpRequesterConnectionProviderModel));
        return ImmutableSet.of((Object)new DummyExtensionModel("tls"), (Object)muleExtensionModel, (Object)httpExtensionModel, (Object)new DummyExtensionModel("db"), (Object)new DummyExtensionModel("file"), (Object)new DummyExtensionModel("wsc"), (Object[])new ExtensionModel[]{new DummyExtensionModel("os")});
    }
}

