/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import org.apache.commons.io.input.ReaderInputStream;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.DependencyResolutionMode;
import org.mule.runtime.ast.api.serialization.ArtifactAstSerializer;
import org.mule.runtime.ast.internal.serialization.ArtifactAstSerializerMetadata;
import org.mule.runtime.ast.internal.serialization.ArtifactAstSerializerMetadataSerializer;
import org.mule.runtime.ast.internal.serialization.dto.ArtifactAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ParserAttributesDTO;
import org.mule.runtime.ast.internal.serialization.dto.factory.AstDTOFactoryProvider;
import org.mule.runtime.ast.internal.serialization.json.gson.ComponentIdentifierJsonSerializer;
import org.mule.runtime.ast.internal.serialization.json.gson.ComponentLocationJsonSerializer;
import org.mule.runtime.ast.internal.serialization.json.gson.ParserAttributesJsonTypeAdapter;
import org.mule.runtime.ast.internal.serialization.json.gson.TypedComponentIdentifierJsonSerializer;

public class JsonArtifactAstSerializer
implements ArtifactAstSerializer {
    public static final String SERIALIZER_VERSION = "1.0";
    private final Executor executor;
    private Gson gson;
    private final Charset charset;
    private final ArtifactAstSerializerMetadataSerializer artifactAstSerializerMetadataSerializer = new ArtifactAstSerializerMetadataSerializer();
    private final AstDTOFactoryProvider astDTOFactoryProvider;

    public JsonArtifactAstSerializer(Executor executor) {
        Objects.requireNonNull(executor);
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(ComponentIdentifier.class, (Object)new ComponentIdentifierJsonSerializer());
        gsonBuilder.registerTypeAdapter(ComponentLocation.class, (Object)new ComponentLocationJsonSerializer());
        gsonBuilder.registerTypeAdapter(TypedComponentIdentifier.class, (Object)new TypedComponentIdentifierJsonSerializer());
        gsonBuilder.registerTypeAdapter(ParserAttributesDTO.class, (Object)new ParserAttributesJsonTypeAdapter());
        this.gson = gsonBuilder.create();
        this.astDTOFactoryProvider = new AstDTOFactoryProvider();
        this.charset = StandardCharsets.UTF_8;
        this.executor = executor;
    }

    public JsonArtifactAstSerializer(Gson gson, Executor executor) {
        this(executor);
        this.gson = gson;
    }

    @Override
    public InputStream serialize(ArtifactAst artifactAst) {
        if (DependencyResolutionMode.getDependencyResolutionMode() != DependencyResolutionMode.COMPILED) {
            throw new IllegalStateException("Artifact AST serialization with `DependencyResolutionMode != COMPILE` would have limited usability when deserialized.");
        }
        ArtifactAstDTO artifactAstDTO = this.astDTOFactoryProvider.getArtifactAstDTOFactory().from(artifactAst);
        Reader reader = this.getJsonBodyReader(artifactAstDTO);
        ReaderInputStream bodyInputStream = new ReaderInputStream(reader, this.charset);
        return this.artifactAstSerializerMetadataSerializer.addArtifactAstSerializerMetadataToInputStream((InputStream)bodyInputStream, new ArtifactAstSerializerMetadata("JSON", SERIALIZER_VERSION, this.charset));
    }

    private Reader getJsonBodyReader(ArtifactAstDTO artifactAstDTO) {
        CountDownLatch pipesConnected = new CountDownLatch(1);
        PipedReader pipedReader = new PipedReader();
        this.executor.execute(() -> {
            try (PipedWriter pipedWriter = new PipedWriter(pipedReader);){
                pipesConnected.countDown();
                this.gson.toJson((Object)artifactAstDTO, (Appendable)pipedWriter);
            }
            catch (IOException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not serialize Json"), (Throwable)e);
            }
        });
        try {
            pipesConnected.await();
            return pipedReader;
        }
        catch (InterruptedException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not serialize Json"), (Throwable)e);
        }
    }

    public Executor getExecutor() {
        return this.executor;
    }
}

