/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.serialization.dto.factory;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.internal.serialization.dto.ExtensionModelDTO;
import org.mule.runtime.ast.internal.serialization.dto.factory.ExtensionModelDTOFactory;
import org.mule.runtime.ast.testobjects.DummyExtensionModel;

@Feature(value="AST serialization")
@Story(value="AST serializable representation")
public class ExtensionModelDTOFactoryTestCase {
    private ExtensionModelDTOFactory extensionModelDTOFactory;

    @Before
    public void setUp() throws Exception {
        this.extensionModelDTOFactory = new ExtensionModelDTOFactory();
    }

    @Test
    public void testBuildFromExtensionModelSetsNameRick_WhenBuildingDTOForRickExtensionModel() {
        DummyExtensionModel extensionModel = new DummyExtensionModel(){

            @Override
            public String getName() {
                return "Rick";
            }
        };
        ExtensionModelDTO extensionModelDTO = this.extensionModelDTOFactory.from((ExtensionModel)extensionModel);
        MatcherAssert.assertThat((Object)extensionModelDTO.getName(), (Matcher)Matchers.is((Object)extensionModel.getName()));
    }

    @Test
    public void testBuildFromExtensionModelSetsNameRobert_WhenBuildingDTOForRobertExtensionModel() {
        DummyExtensionModel extensionModel = new DummyExtensionModel(){

            @Override
            public String getName() {
                return "Robert";
            }
        };
        ExtensionModelDTO extensionModelDTO = this.extensionModelDTOFactory.from((ExtensionModel)extensionModel);
        MatcherAssert.assertThat((Object)extensionModelDTO.getName(), (Matcher)Matchers.is((Object)extensionModel.getName()));
    }
}

