/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.dto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComposableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.serialization.ExtensionModelResolver;
import org.mule.runtime.ast.api.util.BaseComponentAst;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.builder.adapter.MetadataTypeModelAdapter;
import org.mule.runtime.ast.internal.model.DefaultExtensionModelHelper;
import org.mule.runtime.ast.internal.serialization.dto.ComponentAstDTOModelType;
import org.mule.runtime.ast.internal.serialization.dto.ComponentGenerationInformationDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentMetadataAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentParameterAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ExtensionModelDTO;
import org.mule.runtime.ast.internal.serialization.dto.ImportedResourceDTO;
import org.mule.runtime.ast.internal.serialization.resolver.GenerationInformationResolver;
import org.mule.runtime.ast.internal.serialization.visitor.DTOMetadataTypeVisitor;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.loader.util.InfrastructureTypeUtils;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentAstDTO
extends BaseComponentAst
implements ComponentAst {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentAstDTO.class);
    private final List<ComponentAstDTO> directChildren;
    private final String componentType;
    private final ComponentIdentifier identifier;
    private final ComponentLocation location;
    private final ComponentMetadataAstDTO metadata;
    private final Collection<ComponentParameterAstDTO> parameters;
    private final String componentId;
    private final ExtensionModelDTO extensionModel;
    private final String modelName;
    private final ComponentAstDTOModelType modelType;
    private final Map<String, Object> annotations;
    private ComponentGenerationInformationDTO generationInformation;
    private transient TypedComponentIdentifier.ComponentType componentTypeTransient;
    private transient ExtensionModel extensionModelTransient;
    private transient ComponentModel componentModel;
    private transient ConfigurationModel configurationModel;
    private transient ConnectionProviderModel connectionProviderModel;
    private transient NestableElementModel nestableElementModel;
    private transient ParameterizedModel parameterizedModel;
    private transient MetadataType metadataType;
    private transient PropertiesResolver propertiesResolver;

    public ComponentAstDTO(List<ComponentAstDTO> directChildren, String componentType, ComponentIdentifier identifier, ComponentLocation location, ComponentMetadataAstDTO metadata, Collection<ComponentParameterAstDTO> parameters, String componentId, ExtensionModelDTO extensionModel, String modelName, ComponentAstDTOModelType modelType, Map<String, Object> annotations) {
        this.directChildren = directChildren;
        this.componentType = componentType;
        this.componentTypeTransient = TypedComponentIdentifier.ComponentType.valueOf((String)this.componentType);
        this.identifier = identifier;
        location.getLocation();
        this.location = location;
        this.metadata = metadata;
        this.parameters = new ArrayList<ComponentParameterAstDTO>(parameters);
        this.componentId = componentId;
        this.extensionModel = extensionModel;
        this.modelName = modelName;
        this.modelType = modelType;
        this.annotations = annotations;
    }

    public ComponentIdentifier getIdentifier() {
        return this.identifier;
    }

    public TypedComponentIdentifier.ComponentType getComponentType() {
        if (this.componentTypeTransient == null) {
            this.componentTypeTransient = TypedComponentIdentifier.ComponentType.valueOf((String)this.componentType);
        }
        return this.componentTypeTransient;
    }

    public ComponentLocation getLocation() {
        return this.location;
    }

    public ComponentMetadataAst getMetadata() {
        return this.metadata;
    }

    public ComponentGenerationInformation getGenerationInformation() {
        return this.generationInformation;
    }

    public Optional<String> getComponentId() {
        return Optional.ofNullable(this.componentId);
    }

    public ComponentAstDTOModelType getModelType() {
        return this.modelType;
    }

    public Map<String, Object> getAnnotations() {
        return this.annotations;
    }

    public ExtensionModel getExtensionModel() {
        return this.extensionModelTransient;
    }

    public <M> Optional<M> getModel(Class<M> modelClass) {
        if (modelClass.isInstance(this.componentModel)) {
            return Optional.of(modelClass.cast(this.componentModel));
        }
        if (modelClass.isInstance(this.configurationModel)) {
            return Optional.of(modelClass.cast(this.configurationModel));
        }
        if (modelClass.isInstance(this.connectionProviderModel)) {
            return Optional.of(modelClass.cast(this.connectionProviderModel));
        }
        if (modelClass.isInstance(this.nestableElementModel)) {
            return Optional.of(modelClass.cast(this.nestableElementModel));
        }
        if (modelClass.isInstance(this.parameterizedModel)) {
            return Optional.of(modelClass.cast(this.parameterizedModel));
        }
        return Optional.empty();
    }

    public MetadataType getType() {
        return this.metadataType;
    }

    public void setType(MetadataType metadataType) {
        this.metadataType = metadataType;
    }

    public Collection<ComponentParameterAst> getParameters() {
        return Collections.unmodifiableCollection(this.parameters);
    }

    public List<ComponentAst> directChildren() {
        return Collections.unmodifiableList(this.directChildren);
    }

    public void setGenerationInformation(ComponentGenerationInformationDTO generationInformation) {
        this.generationInformation = generationInformation;
    }

    public ExtensionModelDTO getExtensionModelDTO() {
        return this.extensionModel;
    }

    public void setComponentModel(ComponentModel model) {
        this.componentModel = model;
    }

    public void setParameterizedModel(ParameterizedModel model) {
        this.parameterizedModel = model;
    }

    public void setConfigurationModel(ConfigurationModel model) {
        this.configurationModel = model;
    }

    public void setConnectionProviderModel(ConnectionProviderModel model) {
        this.connectionProviderModel = model;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setExtensionModel(ExtensionModel extensionModel) {
        this.extensionModelTransient = extensionModel;
    }

    public PropertiesResolver getPropertiesResolver() {
        return this.propertiesResolver;
    }

    public void enrichWithImportedResources(Map<String, ImportedResourceDTO> importResourcesByRawLocation) {
        LOGGER.debug("Enrichment: enrichWithImportedResources: {}", (Object)this);
        if (this.metadata != null) {
            this.metadata.enrich(importResourcesByRawLocation);
        }
        this.directChildren.forEach(componentAstDTO -> componentAstDTO.enrichWithImportedResources(importResourcesByRawLocation));
        this.parameters.forEach(param -> param.enrichWithImportedResources(importResourcesByRawLocation));
    }

    public void setPropertiesResolver(PropertiesResolver propertiesResolver) {
        this.propertiesResolver = propertiesResolver;
        this.parameters.forEach(parameter -> parameter.setPropertiesResolver(propertiesResolver));
        this.directChildren.forEach(componentAstDTO -> componentAstDTO.setPropertiesResolver(propertiesResolver));
        if (this.metadata != null) {
            this.metadata.setPropertiesResolver(propertiesResolver);
        }
    }

    public void resolveModelsRecursively(ComponentAstDTO parentComponentAstDTO, DefaultExtensionModelHelper extensionModelHelper, ExtensionModelResolver extensionModelResolver, GenerationInformationResolver generationInformationResolver) {
        LOGGER.debug("Enrichment: resolveModelsRecursively({})", (Object)this);
        this.extensionModelTransient = extensionModelResolver.resolve(this.extensionModel.getName());
        this.resolveModelComponent(parentComponentAstDTO, extensionModelHelper, generationInformationResolver);
        this.directChildren.forEach(childComponentAstDTO -> childComponentAstDTO.resolveModelsRecursively(this, extensionModelHelper, extensionModelResolver, generationInformationResolver));
        this.generationInformation = generationInformationResolver.resolveComponentAstGenerationInformation(null, this, extensionModelHelper);
        ArrayList<ComponentParameterAstDTO> filteredParams = new ArrayList<ComponentParameterAstDTO>();
        for (ComponentParameterAstDTO parameter : this.parameters) {
            try {
                parameter.resolveModelParameter(this, extensionModelHelper, extensionModelResolver, generationInformationResolver);
                filteredParams.add(parameter);
            }
            catch (IllegalArgumentException e) {
                if (this.isGlobalErrorHandlerRef(parameter)) continue;
                throw e;
            }
        }
        this.parameters.clear();
        this.parameters.addAll(filteredParams);
    }

    private boolean isGlobalErrorHandlerRef(ComponentParameterAstDTO parameter) {
        return this.extensionModel.getName().equals("mule") && this.getModelName().equals("errorHandler");
    }

    public void resolveModelComponent(ComponentAstDTO parentComponentAstDTO, DefaultExtensionModelHelper extensionModelHelper, GenerationInformationResolver generationInformationResolver) {
        LOGGER.debug("Enrichment: resolveModelComponent({}, {})", (Object)this, (Object)(this.extensionModelTransient != null ? this.extensionModelTransient.getName() : "(no_ext)"));
        switch (this.modelType) {
            case OPERATION: {
                this.resolveOperationModel();
                break;
            }
            case CONSTRUCT: {
                if (parentComponentAstDTO != null) {
                    this.resolveNestedModel(parentComponentAstDTO);
                    if (this.getModel(NestedComponentModel.class).isPresent()) break;
                }
                this.resolveConstructModel();
                break;
            }
            case CONFIGURATION: {
                this.resolveConfigurationModel();
                break;
            }
            case CONNECTION_PROVIDER: {
                this.resolveConnectionProviderModel();
                break;
            }
            case NESTED_COMPONENT: 
            case NESTED_ROUTE: {
                this.resolveNestedModel(parentComponentAstDTO);
                break;
            }
            case SOURCE: {
                this.resolveSourceModel();
                break;
            }
            case TYPE: {
                this.resolveTypeModel(extensionModelHelper);
                break;
            }
            case INFRASTRUCTURE: {
                this.resolveInfrastructureModel(extensionModelHelper, generationInformationResolver);
            }
        }
    }

    private void resolveInfrastructureModel(DefaultExtensionModelHelper extensionModelHelper, GenerationInformationResolver generationInformationResolver) {
        Optional tt = InfrastructureTypeUtils.getTypeFor((ComponentIdentifier)this.getIdentifier()).flatMap(arg_0 -> ((DefaultExtensionModelHelper)extensionModelHelper).findMetadataType(arg_0));
        if (!tt.isPresent()) {
            LOGGER.warn("Enrichment: resolveInfrastructureModel - NO MODEL RESOLVED!: {} - {}", (Object)this.modelType, (Object)this.modelName);
        }
        tt.ifPresent(resolvedType -> {
            LOGGER.debug("Enrichment: resolveInfrastructureModel: {} - {}", (Object)this.modelType, resolvedType);
            this.metadataType = resolvedType;
        });
        this.parameterizedModel = (ParameterizedModel)MetadataTypeModelAdapter.createMetadataTypeModelAdapterWithStereotype((MetadataType)this.metadataType, (DefaultExtensionModelHelper)extensionModelHelper).orElseGet(() -> MetadataTypeModelAdapter.createParameterizedTypeModelAdapter((MetadataType)this.metadataType, (DefaultExtensionModelHelper)extensionModelHelper));
        this.generationInformation = generationInformationResolver.resolveComponentAstGenerationInformation(null, this, extensionModelHelper);
        this.parameters.forEach(componentParameterAstDTO -> componentParameterAstDTO.resolveInfrastructureParameter(this, extensionModelHelper, generationInformationResolver));
    }

    private void resolveTypeModel(DefaultExtensionModelHelper extensionModelHelper) {
        Optional<? extends MetadataType> t = this.resolveType(extensionModelHelper, Thread.currentThread().getContextClassLoader());
        if (!t.isPresent()) {
            LOGGER.warn("Enrichment: resolveModelComponent - NO MODEL RESOLVED!: {} - {}", (Object)this.getModelType(), (Object)this.modelName);
        }
        t.ifPresent(resolvedType -> {
            resolvedType.accept((MetadataTypeVisitor)new DTOMetadataTypeVisitor(this, extensionModelHelper));
            LOGGER.debug("Enrichment: resolveModelComponent: {} - {}", (Object)this.getModelType(), resolvedType);
            this.metadataType = resolvedType;
        });
    }

    private void resolveSourceModel() {
        ExtensionModel extensionModel = this.extensionModelTransient;
        SourceModel sourceModel = extensionModel.getSourceModel(this.modelName).orElseGet(() -> {
            for (ConfigurationModel configModel : extensionModel.getConfigurationModels()) {
                Optional sourceModelInConfig = configModel.getSourceModel(this.modelName);
                if (!sourceModelInConfig.isPresent()) continue;
                LOGGER.debug("Enrichment: resolveModelComponent: {} - {}", (Object)this.getModelType(), (Object)((SourceModel)sourceModelInConfig.get()).getName());
                return (SourceModel)sourceModelInConfig.get();
            }
            LOGGER.warn("Enrichment: resolveModelComponent - NO MODEL RESOLVED!: {} - {}", (Object)this.getModelType(), (Object)this.modelName);
            return null;
        });
        this.componentModel = sourceModel;
        this.parameterizedModel = sourceModel;
    }

    private void resolveNestedModel(ComponentAstDTO parentComponentAstDTO) {
        NestableElementModel nestableModel = null;
        for (NestableElementModel nestableModelInParent : parentComponentAstDTO.getModel(ComposableModel.class).get().getNestedComponents()) {
            if (!nestableModelInParent.getName().equals(this.modelName)) continue;
            LOGGER.debug("Enrichment: resolveModelComponent: {} - {}", (Object)this.getModelType(), (Object)nestableModelInParent.getName());
            nestableModel = nestableModelInParent;
            break;
        }
        if (nestableModel == null) {
            LOGGER.warn("Enrichment: resolveModelComponent - NO MODEL RESOLVED!: {} - {}", (Object)this.getModelType(), (Object)this.modelName);
        }
        this.parameterizedModel = nestableModel;
    }

    private void resolveConnectionProviderModel() {
        ConnectionProviderModel connectionProviderModel;
        ExtensionModel extensionModel = this.extensionModelTransient;
        this.connectionProviderModel = connectionProviderModel = extensionModel.getConnectionProviderModel(this.modelName).orElseGet(() -> {
            for (ConfigurationModel configModel : extensionModel.getConfigurationModels()) {
                Optional connectionProviderModelInConfig = configModel.getConnectionProviderModel(this.modelName);
                if (!connectionProviderModelInConfig.isPresent()) continue;
                LOGGER.debug("Enrichment: resolveModelComponent: {} - {}", (Object)this.getModelType(), (Object)((ConnectionProviderModel)connectionProviderModelInConfig.get()).getName());
                return (ConnectionProviderModel)connectionProviderModelInConfig.get();
            }
            LOGGER.warn("Enrichment: resolveModelComponent - NO MODEL RESOLVED!: {} - {}", (Object)this.getModelType(), (Object)this.modelName);
            return null;
        });
        this.parameterizedModel = connectionProviderModel;
    }

    private void resolveConfigurationModel() {
        ConfigurationModel configurationModel;
        this.configurationModel = configurationModel = this.extensionModelTransient.getConfigurationModel(this.modelName).map(m -> {
            LOGGER.debug("Enrichment: resolveModelComponent: {} - {}", (Object)this.getModelType(), (Object)m.getName());
            return m;
        }).orElseGet(() -> {
            LOGGER.warn("Enrichment: resolveModelComponent - NO MODEL RESOLVED!: {} - {}", (Object)this.getModelType(), (Object)this.modelName);
            return null;
        });
        this.parameterizedModel = configurationModel;
    }

    private void resolveConstructModel() {
        ConstructModel constructModel = this.extensionModelTransient.getConstructModel(this.modelName).map(m -> {
            LOGGER.debug("Enrichment: resolveModelComponent: {} - {}", (Object)this.getModelType(), (Object)m.getName());
            return m;
        }).orElse(null);
        if (constructModel != null) {
            this.componentModel = constructModel;
            this.parameterizedModel = constructModel;
        } else {
            LOGGER.debug("ConstructModel not found for {}, attempting with OperationModel", (Object)this.modelName);
            this.resolveOperationModel();
        }
    }

    private void resolveOperationModel() {
        ExtensionModel extensionModel = this.extensionModelTransient;
        OperationModel operationModel = extensionModel.getOperationModel(this.modelName).orElseGet(() -> {
            for (ConfigurationModel configModel : extensionModel.getConfigurationModels()) {
                Optional operationModelInConfig = configModel.getOperationModel(this.modelName);
                if (!operationModelInConfig.isPresent()) continue;
                LOGGER.debug("Enrichment: resolveModelComponent: {} - {}", (Object)this.modelType, (Object)((OperationModel)operationModelInConfig.get()).getName());
                return (OperationModel)operationModelInConfig.get();
            }
            LOGGER.warn("Enrichment: resolveModelComponent - NO MODEL RESOLVED!: {} - {}", (Object)this.getModelType(), (Object)this.modelName);
            return null;
        });
        this.componentModel = operationModel;
        this.parameterizedModel = operationModel;
    }

    public void resolveMapEntryComponentModels(ComponentAstDTO mapComponentAstDTO, ComponentParameterAstDTO ownerComponentParameterAst, DefaultExtensionModelHelper extensionModelHelper, ExtensionModelResolver extensionModelResolver, GenerationInformationResolver generationInformationResolver) {
        ParameterModel ownerParameterModel = ownerComponentParameterAst.getModel();
        this.extensionModelTransient = extensionModelResolver.resolve(this.getExtensionModelDTO().getName());
        if (!this.getModel(Object.class).isPresent()) {
            this.parameterizedModel = MetadataTypeModelAdapter.createKeyValueWrapperTypeModelAdapter((String)"key", (MetadataType)extensionModelHelper.findMetadataType(String.class).orElse(null), (String)"value", (MetadataType)(ownerParameterModel.getType() instanceof ObjectType ? ((ObjectType)ownerParameterModel.getType()).getOpenRestriction().orElseGet(() -> extensionModelHelper.findMetadataType(String.class).orElse(null)) : (MetadataType)extensionModelHelper.findMetadataType(String.class).orElse(null)), (DefaultExtensionModelHelper)extensionModelHelper);
            this.generationInformation = generationInformationResolver.resolveComponentAstGenerationInformation(ownerComponentParameterAst, this, extensionModelHelper);
        }
        this.parameters.forEach(parameter -> parameter.resolveMapEntryAttribute(ownerParameterModel, mapComponentAstDTO.getGenerationInformation(), extensionModelHelper, extensionModelResolver, generationInformationResolver, this));
    }

    public Optional<? extends MetadataType> resolveType(DefaultExtensionModelHelper extensionModelHelper, ClassLoader applicationClassLoader) {
        Optional type = extensionModelHelper.getTypeCatalog().getType(this.modelName);
        if (type.isPresent()) {
            return type;
        }
        Optional<? extends MetadataType> subType = this.getSubTypeByName();
        if (subType.isPresent()) {
            return subType;
        }
        return extensionModelHelper.findMetadataType(this.loadClassByName(this.modelName, this.extensionModelTransient, applicationClassLoader));
    }

    public Optional<? extends MetadataType> getSubTypeByName() {
        return this.extensionModelTransient.getSubTypes().stream().flatMap(subtype -> subtype.getSubTypes().stream()).filter(subtype -> MetadataTypeUtils.getTypeId((MetadataType)subtype).map(this.modelName::equals).orElse(false)).findFirst();
    }

    public Class<?> loadClassByName(String fullyQualifiedName, ExtensionModel extensionModel, ClassLoader applicationClassLoader) {
        try {
            return this.loadClassFromClassLoader(fullyQualifiedName, applicationClassLoader);
        }
        catch (ClassNotFoundException e) {
            try {
                return this.loadClassFromClassLoader(fullyQualifiedName, extensionModel.getModelProperty(ClassLoaderModelProperty.class).map(ClassLoaderModelProperty::getClassLoader).orElseThrow(() -> new IllegalStateException(e)));
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public Class<?> loadClassFromClassLoader(String fullyQualifiedName, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            return classLoader.loadClass(fullyQualifiedName);
        }
        catch (ClassNotFoundException e) {
            return classLoader.loadClass(StringUtils.reverse((String)StringUtils.replaceOnce((String)StringUtils.reverse((String)fullyQualifiedName), (String)".", (String)"$")));
        }
    }

    public ParameterModel resolveParameterModel(ComponentParameterAstDTO componentParameterAstDTO) {
        Optional<ParameterizedModel> model = this.getModel(ParameterizedModel.class);
        if (!model.isPresent()) {
            throw new IllegalArgumentException("Could not resolve ParameterModel for [" + componentParameterAstDTO.getModelName() + "]");
        }
        return (ParameterModel)model.flatMap(componentModel -> componentModel.getAllParameterModels().stream().filter(parameterModel -> parameterModel.getName().equals(componentParameterAstDTO.getModelName())).findFirst()).orElseThrow(() -> new IllegalArgumentException("Could not resolve ParameterModel for [" + componentParameterAstDTO.getModelName() + "] in [" + ((ParameterizedModel)model.get()).getName() + "]"));
    }

    public Optional<ParameterGroupModel> getParameterGroupModelForSourceModel(ComponentParameterAstDTO componentParameterAstDTO) {
        Optional<SourceModel> sourceModelOptional = this.getModel(SourceModel.class);
        if (!sourceModelOptional.isPresent()) {
            return Optional.empty();
        }
        SourceModel sourceModel = sourceModelOptional.get();
        List errorCallbackParameterGroupModels = sourceModel.getErrorCallback().map(ParameterizedModel::getParameterGroupModels).orElse(new ArrayList());
        List successCallbackParameterGroupModels = sourceModel.getSuccessCallback().map(ParameterizedModel::getParameterGroupModels).orElse(new ArrayList());
        return Stream.concat(errorCallbackParameterGroupModels.stream(), successCallbackParameterGroupModels.stream()).filter(parameterGroupModel -> parameterGroupModel.getName().equals(componentParameterAstDTO.getGroupModelName())).findFirst();
    }

    public ParameterGroupModel resolveParameterGroupModel(ComponentParameterAstDTO componentParameterAstDTO) {
        return this.getModel(ParameterizedModel.class).flatMap(parameterizedModel -> parameterizedModel.getParameterGroupModels().stream().filter(parameterGroupModel -> parameterGroupModel.getName().equals(componentParameterAstDTO.getGroupModelName())).findFirst()).orElseGet(() -> this.getParameterGroupModelForSourceModel(componentParameterAstDTO).orElseThrow(() -> new IllegalArgumentException("Could not resolve ParameterGroupModel [" + componentParameterAstDTO.getGroupModelName() + "]")));
    }

    public void resolveSimpleTypeComponentModel(ComponentParameterAstDTO ownerComponentParameterAst, SimpleType simpleType, ExtensionModelResolver extensionModelResolver, DefaultExtensionModelHelper extensionModelHelper, GenerationInformationResolver generationInformationResolver) {
        this.extensionModelTransient = extensionModelResolver.resolve(this.getExtensionModelDTO().getName());
        this.parameterizedModel = MetadataTypeModelAdapter.createSimpleWrapperTypeModelAdapter((SimpleType)simpleType, (DefaultExtensionModelHelper)extensionModelHelper);
        this.generationInformation = generationInformationResolver.resolveComponentAstGenerationInformation(ownerComponentParameterAst, this, extensionModelHelper);
        this.parameters.forEach(componentParameterAstDTO -> componentParameterAstDTO.resolveSimpleTypeComponentParameter(this, simpleType, extensionModelHelper, generationInformationResolver));
    }

    boolean isWrapped(ComponentParameterAstDTO componentParameterAstDTO, DefaultExtensionModelHelper extensionModelHelper) {
        if (this.generationInformation == null) {
            return false;
        }
        DslElementSyntax syntax = this.generationInformation.getSyntax().flatMap(s -> s.getChild(componentParameterAstDTO.getModel().getName())).orElseGet(() -> extensionModelHelper.resolveDslElementModel(componentParameterAstDTO.getModel(), this.getIdentifier()));
        return syntax.isWrapped();
    }
}

