/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.serialization.dto;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.metadata.api.annotation.ExampleAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.ast.api.ArtifactType;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.model.ExtensionModelHelper;
import org.mule.runtime.ast.api.serialization.ExtensionModelResolver;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.model.DefaultExtensionModelHelper;
import org.mule.runtime.ast.internal.model.ParameterModelUtils;
import org.mule.runtime.ast.internal.serialization.dto.ArtifactAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentAstDTOModelType;
import org.mule.runtime.ast.internal.serialization.dto.ComponentGenerationInformationDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentMetadataAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentParameterAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ErrorTypeRepositoryDTO;
import org.mule.runtime.ast.internal.serialization.dto.ExtensionModelDTO;
import org.mule.runtime.ast.internal.serialization.dto.ParameterValueContainer;
import org.mule.runtime.ast.internal.serialization.resolver.DefaultGenerationInformationResolver;
import org.mule.runtime.ast.internal.serialization.resolver.GenerationInformationResolver;
import org.mule.runtime.ast.internal.serialization.visitor.UnionTypesVisitor;
import org.mule.runtime.ast.testobjects.DummyExtensionModel;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;

@Feature(value="AST serialization")
@Story(value="AST serialization enrichment")
public class ArtifactAstDTOTestCase {
    private static final String CONSTRUCT_MODEL_NAME = "constructModelName";
    private static final String CONSTRUCT_MODEL_ELEMENT_NAME = "construct-model-name";
    private static final String CONSTRUCT_PARAM_GROUP_MODEL_NAME = "constructParamGroupModelName";
    private static final String CONSTRUCT_STRING_LIST_PARAM_MODEL_NAME = "stringListParamModelName";
    private static final String CONSTRUCT_COMPONENT_LIST_PARAM_MODEL_NAME = "componentListParamModelName";
    private static final String CONSTRUCT_SIMPLE_PARAM_MODEL_NAME = "simpleParamModelName";
    private static final String CONSTRUCT_COMPONENT_AST_PARAM_MODEL_NAME = "componentAstParamModelName";
    private static final String DUMMY_NAMESPACE = "dummyNamespace";
    private static final String DUMMY_NAMESPACE_URI = "dummyNamespaceUri";
    private static final String OPERATION_MODEL_NAME = "operationModelName";
    private static final String OPERATION_MODEL_ELEMENT_NAME = "operation-model-name";
    private static final String OPERATION_PARAM_GROUP_MODEL_NAME = "operationParamGroupModelName";
    private static final String OPERATION_SIMPLE_PARAM_MODEL_NAME = "simpleParamModelName";
    private static final String INFRASTRUCTURE_TYPE_IDENTIFIER = "error-mapping";
    private static final String INFRASTRUCTURE_PARAMETER_IDENTIFIER = "error-mapping";
    private static final String INFRASTRUCTURE_PARAMETER_PARAMETERIZED_MODEL_NAME = "ErrorMapping";
    private static final String INFRASTRUCTURE_TYPE_PARAMETER_MODEL_GROUP_NAME = "ErrorMapping";
    private static final String INFRASTRUCTURE_PARAMETER_PARAMETER_GROUP_MODEL_NAME = "ErrorMapping";
    private static final String INFRASTRUCTURE_TYPE_PARAMETERIZED_MODEL_NAME = "infrastructureTypeParameterizedModel";
    private static final String INFRASTRUCTURE_TYPE_PARAMETER_MODEL_NAME = "name";
    private static final String INFRASTRUCTURE_PARAMETER_PARAMETER_MODEL = "name";
    private ExtensionModelResolver extensionModelResolver;
    private GenerationInformationResolver generationInformationResolver;
    private OperationModel operationModel;
    private ConstructModel constructModel;
    private ConstructModel paramValueConstructModel;
    private ExtensionModelDTO muleExtensionModelDTO;
    private ExtensionModelDTO dummyExtensionModelDTO;
    private ArtifactAstDTO artifactAstDTOWithOneComponent;
    private ArtifactAstDTO artifactAstDTOWithStringListParam;
    private ArtifactAstDTO artifactAstDTOWithComponentListParam;
    private ArtifactAstDTO artifactAstDTOWithOneInfrastructureType;
    private ArtifactAstDTO artifactAstDTOWithOneInfrastructureParameter;

    @Before
    public void setUp() {
        this.muleExtensionModelDTO = new ExtensionModelDTO("mule");
        this.dummyExtensionModelDTO = new ExtensionModelDTO(DUMMY_NAMESPACE);
        this.artifactAstDTOWithOneComponent = this.makeArtifactAstDTOWithOneComponent();
        this.artifactAstDTOWithStringListParam = this.makeArtifactAstDTOWithStringListParam();
        this.artifactAstDTOWithComponentListParam = this.makeArtifactAstDTOWithComponentListParam();
        this.artifactAstDTOWithOneInfrastructureType = this.makeArtifactAstDTOWithOneInfrastructureType();
        this.artifactAstDTOWithOneInfrastructureParameter = this.makeArtifactAstDTOWithOneInfrastructureParameter();
        this.extensionModelResolver = this.initExtensionModelResolver();
        this.generationInformationResolver = new DefaultGenerationInformationResolver();
    }

    @Test
    public void testEnrichCallsExtensionModelResolver_WhenEnrichingArtifactAstDTO() {
        ComponentGenerationInformationDTO componentGenerationInformationDTO = (ComponentGenerationInformationDTO)Mockito.mock(ComponentGenerationInformationDTO.class);
        DslElementSyntax dslElementSyntax = (DslElementSyntax)Mockito.mock(DslElementSyntax.class);
        Mockito.when((Object)componentGenerationInformationDTO.getSyntax()).thenReturn(Optional.of(dslElementSyntax));
        Mockito.when((Object)dslElementSyntax.getChild((String)ArgumentMatchers.any())).thenReturn(Optional.of(dslElementSyntax));
        Mockito.when((Object)dslElementSyntax.isWrapped()).thenReturn((Object)false);
        this.artifactAstDTOWithOneComponent.enrich(this.extensionModelResolver, this.generationInformationResolver, new ParameterModelUtils());
        ((ExtensionModelResolver)Mockito.verify((Object)this.extensionModelResolver, (VerificationMode)Mockito.times((int)3))).resolve(DUMMY_NAMESPACE);
        ((ExtensionModelResolver)Mockito.verify((Object)this.extensionModelResolver, (VerificationMode)Mockito.times((int)1))).resolve("mule");
    }

    @Test
    public void testEnrichResolves2DependencyDTOsIntoDependencies_WhenEnrichingArtifactAstDTOWith2DependencyDTOsAnd3ComponentsTotal() {
        this.artifactAstDTOWithOneComponent.enrich(this.extensionModelResolver, this.generationInformationResolver, new ParameterModelUtils());
        ((ExtensionModelResolver)Mockito.verify((Object)this.extensionModelResolver, (VerificationMode)Mockito.times((int)1))).resolve(this.muleExtensionModelDTO.getName());
        ((ExtensionModelResolver)Mockito.verify((Object)this.extensionModelResolver, (VerificationMode)Mockito.times((int)3))).resolve(this.dummyExtensionModelDTO.getName());
        MatcherAssert.assertThat(this.artifactAstDTOWithOneComponent.dependencies().stream().map(ExtensionModel::getName).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{this.muleExtensionModelDTO.getName(), this.dummyExtensionModelDTO.getName()}));
    }

    @Test
    public void testEnrichResolves2DependencyDTOsIntoDependencies_WhenEnrichingArtifactAstDTOWith2DependencyDTOs() {
        this.artifactAstDTOWithOneInfrastructureType.enrich(this.extensionModelResolver, this.generationInformationResolver, new ParameterModelUtils());
        ((ExtensionModelResolver)Mockito.verify((Object)this.extensionModelResolver, (VerificationMode)Mockito.times((int)2))).resolve(this.muleExtensionModelDTO.getName());
        ((ExtensionModelResolver)Mockito.verify((Object)this.extensionModelResolver, (VerificationMode)Mockito.times((int)1))).resolve(this.dummyExtensionModelDTO.getName());
        MatcherAssert.assertThat(this.artifactAstDTOWithOneInfrastructureType.dependencies().stream().map(ExtensionModel::getName).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{this.muleExtensionModelDTO.getName(), this.dummyExtensionModelDTO.getName()}));
    }

    @Test
    public void testEnrichResolvesTopLevelComponentAstModel_WhenEnrichingArtifactAstDTOWithATopLevelComponentAst() {
        this.artifactAstDTOWithOneComponent.enrich(this.extensionModelResolver, this.generationInformationResolver, new ParameterModelUtils());
        ComponentAst complexComponent = (ComponentAst)this.artifactAstDTOWithOneComponent.topLevelComponents().get(0);
        MatcherAssert.assertThat((Object)complexComponent.getModel(Object.class).isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ParameterizedModel)complexComponent.getModel(ParameterizedModel.class).get()).getName(), (Matcher)Matchers.is((Object)CONSTRUCT_MODEL_NAME));
    }

    @Test
    public void testEnrichResolvesComponentParameterAstModels_WhenEnrichingArtifactAstDTOWithATopLevelComponentWithAParameter() {
        this.artifactAstDTOWithOneComponent.enrich(this.extensionModelResolver, this.generationInformationResolver, new ParameterModelUtils());
        ComponentAst complexComponent = (ComponentAst)this.artifactAstDTOWithOneComponent.topLevelComponents().get(0);
        ArrayList firstTopLevelComponentParameters = new ArrayList(complexComponent.getParameters());
        ComponentParameterAst firstConstructComponentParameterAst = (ComponentParameterAst)firstTopLevelComponentParameters.get(0);
        MatcherAssert.assertThat((Object)firstConstructComponentParameterAst.getModel(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)firstConstructComponentParameterAst.getModel().getName(), (Matcher)Matchers.is((Object)CONSTRUCT_COMPONENT_AST_PARAM_MODEL_NAME));
        MatcherAssert.assertThat((Object)firstConstructComponentParameterAst.getGroupModel(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)firstConstructComponentParameterAst.getGroupModel().getName(), (Matcher)Matchers.is((Object)CONSTRUCT_PARAM_GROUP_MODEL_NAME));
        MatcherAssert.assertThat((Object)((ComponentParameterAst)firstTopLevelComponentParameters.get(1)).getModel(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)((ComponentParameterAst)firstTopLevelComponentParameters.get(1)).getModel().getName(), (Matcher)Matchers.is((Object)"simpleParamModelName"));
        MatcherAssert.assertThat((Object)((ComponentParameterAst)firstTopLevelComponentParameters.get(1)).getGroupModel(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)((ComponentParameterAst)firstTopLevelComponentParameters.get(1)).getGroupModel().getName(), (Matcher)Matchers.is((Object)CONSTRUCT_PARAM_GROUP_MODEL_NAME));
    }

    @Test
    public void testEnrichResolvesModelOfComponentAstThatIsValueOfParameter_WhenEnrichingArtifactAstDTOWithTopLevelComponentThatHasParameterWhoseValueIsAComponentAst() {
        this.artifactAstDTOWithOneComponent.enrich(this.extensionModelResolver, this.generationInformationResolver, new ParameterModelUtils());
        ComponentAst complexComponent = (ComponentAst)this.artifactAstDTOWithOneComponent.topLevelComponents().get(0);
        ArrayList firstTopLevelComponentParameters = new ArrayList(complexComponent.getParameters());
        ComponentParameterAst firstConstructComponentParameterAst = (ComponentParameterAst)firstTopLevelComponentParameters.get(0);
        MatcherAssert.assertThat((Object)firstConstructComponentParameterAst.getValue().isRight(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)firstConstructComponentParameterAst.getValue().getRight(), (Matcher)Matchers.notNullValue());
        ComponentAst valueOfTheFirstParameterOfTheConstruct = (ComponentAst)firstConstructComponentParameterAst.getValue().getRight();
        MatcherAssert.assertThat((Object)valueOfTheFirstParameterOfTheConstruct, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)valueOfTheFirstParameterOfTheConstruct.getModel(Object.class).isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ParameterizedModel)valueOfTheFirstParameterOfTheConstruct.getModel(ParameterizedModel.class).get()).getName(), (Matcher)Matchers.is((Object)OPERATION_MODEL_NAME));
    }

    @Test
    public void testEnrichResolvesModelOfComponentParameterAstOfComponentAstThatIsValueOfAnotherParameter_WhenEnrichingArtifactAstDTOWithTopLevelComponentThatHasParameterWhoseValueIsAComponentAstThatHasParameters() {
        this.artifactAstDTOWithOneComponent.enrich(this.extensionModelResolver, this.generationInformationResolver, new ParameterModelUtils());
        ComponentAst complexComponent = (ComponentAst)this.artifactAstDTOWithOneComponent.topLevelComponents().get(0);
        ArrayList firstTopLevelComponentParameters = new ArrayList(complexComponent.getParameters());
        ComponentParameterAst firstConstructComponentParameterAst = (ComponentParameterAst)firstTopLevelComponentParameters.get(0);
        ComponentAst valueOfTheFirstParameterOfTheConstruct = (ComponentAst)firstConstructComponentParameterAst.getValue().getRight();
        ComponentParameterAst valueComponentParameters = (ComponentParameterAst)new ArrayList(valueOfTheFirstParameterOfTheConstruct.getParameters()).get(0);
        MatcherAssert.assertThat((Object)valueComponentParameters.getModel(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)valueComponentParameters.getModel().getName(), (Matcher)Matchers.is((Object)"simpleParamModelName"));
        MatcherAssert.assertThat((Object)valueComponentParameters.getGroupModel(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)valueComponentParameters.getGroupModel().getName(), (Matcher)Matchers.is((Object)OPERATION_PARAM_GROUP_MODEL_NAME));
    }

    @Test
    @Issue(value="W-15677894")
    public void testEnrichResolvesModelOfComponentParameterAstOfComponentAstThatIsValueOfAnotherParameter_WhenEnrichingArtifactAstDTOWithTopLevelComponentThatHasParameterWhoseValueIsAListOfSimpleValues() {
        this.artifactAstDTOWithStringListParam.enrich(this.extensionModelResolver, this.generationInformationResolver, new ParameterModelUtils());
        ComponentAst complexComponent = (ComponentAst)this.artifactAstDTOWithStringListParam.topLevelComponents().get(0);
        ArrayList firstTopLevelComponentParameters = new ArrayList(complexComponent.getParameters());
        ComponentParameterAst firstConstructComponentParameterAst = (ComponentParameterAst)firstTopLevelComponentParameters.get(0);
        List valueOfTheFirstParameterOfTheConstruct = (List)firstConstructComponentParameterAst.getValue().getRight();
        ComponentParameterAst valueComponentParameters = (ComponentParameterAst)new ArrayList(((ComponentAst)valueOfTheFirstParameterOfTheConstruct.get(0)).getParameters()).get(0);
        MatcherAssert.assertThat((Object)valueComponentParameters.getModel(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)valueComponentParameters.getModel().getName(), (Matcher)Matchers.is((Object)"value"));
        MatcherAssert.assertThat((Object)valueComponentParameters.getGroupModel(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)valueComponentParameters.getGroupModel().getName(), (Matcher)Matchers.is((Object)"General"));
    }

    @Test
    @Issue(value="W-15677894")
    public void testEnrichResolvesModelOfComponentParameterAstOfComponentAstThatIsValueOfAnotherParameter_WhenEnrichingArtifactAstDTOWithTopLevelComponentThatHasParameterWhoseValueIsAListOfComponents() {
        this.artifactAstDTOWithComponentListParam.enrich(this.extensionModelResolver, this.generationInformationResolver, new ParameterModelUtils());
        ComponentAst complexComponent = (ComponentAst)this.artifactAstDTOWithComponentListParam.topLevelComponents().get(0);
        ArrayList firstTopLevelComponentParameters = new ArrayList(complexComponent.getParameters());
        ComponentParameterAst firstConstructComponentParameterAst = (ComponentParameterAst)firstTopLevelComponentParameters.get(0);
        List valueOfTheFirstParameterOfTheConstruct = (List)firstConstructComponentParameterAst.getValue().getRight();
        ComponentParameterAst valueComponentParameters = (ComponentParameterAst)new ArrayList(((ComponentAst)valueOfTheFirstParameterOfTheConstruct.get(0)).getParameters()).get(0);
        MatcherAssert.assertThat((Object)valueComponentParameters.getModel(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)valueComponentParameters.getModel().getName(), (Matcher)Matchers.is((Object)CONSTRUCT_COMPONENT_AST_PARAM_MODEL_NAME));
        MatcherAssert.assertThat((Object)valueComponentParameters.getGroupModel(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)valueComponentParameters.getGroupModel().getName(), (Matcher)Matchers.is((Object)CONSTRUCT_PARAM_GROUP_MODEL_NAME));
    }

    @Test
    public void testEnrichResolvesInfrastructureParameterModel_WhenEnrichingArtifactAstDTOWithATopLevelInfrastructureComponentAst() {
        this.artifactAstDTOWithOneInfrastructureParameter.enrich(this.extensionModelResolver, this.generationInformationResolver, new ParameterModelUtils());
        ComponentAst infrastructureParameterComponent = (ComponentAst)this.artifactAstDTOWithOneInfrastructureParameter.topLevelComponents().get(0);
        MatcherAssert.assertThat((Object)infrastructureParameterComponent.getModel(ParameterizedModel.class).isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ParameterizedModel)infrastructureParameterComponent.getModel(ParameterizedModel.class).get()).getName(), (Matcher)Matchers.is((Object)"ErrorMapping"));
    }

    @Test
    public void testUpdatePropertiesResolverCallsPropertyResolverSetMappingFunction_WhenUpdatingPropertyResolversMappingFunction() {
        PropertiesResolver propertiesResolver = (PropertiesResolver)Mockito.mock(PropertiesResolver.class);
        UnaryOperator newMappingFunction = UnaryOperator.identity();
        this.artifactAstDTOWithOneComponent.setPropertiesResolver(propertiesResolver);
        this.artifactAstDTOWithOneComponent.updatePropertiesResolver(newMappingFunction);
        ((PropertiesResolver)Mockito.verify((Object)propertiesResolver, (VerificationMode)Mockito.times((int)1))).setMappingFunction(newMappingFunction);
    }

    @Test
    @Issue(value="MULE-19806")
    public void testResolveParameterModelsParameterGroupModelsAndGenerationInformationResolvesUnionType_WhenResolvingModelsForParameterWithUnionType() {
        DefaultGenerationInformationResolver generationInformationResolver = (DefaultGenerationInformationResolver)Mockito.mock(DefaultGenerationInformationResolver.class);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        UnionType unionType = (UnionType)Mockito.mock(UnionType.class);
        Mockito.when((Object)parameterModel.getType()).thenReturn((Object)unionType);
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"parameterModelName");
        ParameterGroupModel parameterGroupModel = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)parameterGroupModel.getName()).thenReturn((Object)"parameterGroupModelName");
        ComponentAstDTO componentParameterValue = (ComponentAstDTO)Mockito.mock(ComponentAstDTO.class);
        ComponentIdentifier componentIdentifier = ComponentIdentifier.builder().name("aName").namespace("aNamespace").namespaceUri("aNamespaceUri").build();
        Mockito.when((Object)componentParameterValue.getIdentifier()).thenReturn((Object)componentIdentifier);
        Mockito.when((Object)componentParameterValue.getModelType()).thenReturn((Object)ComponentAstDTOModelType.TYPE);
        Mockito.when((Object)componentParameterValue.getModelName()).thenReturn((Object)"someTypeId");
        Mockito.when((Object)componentParameterValue.getExtensionModelDTO()).thenReturn((Object)((ExtensionModelDTO)Mockito.mock(ExtensionModelDTO.class)));
        ComponentParameterAstDTO componentParameterAstDTO = this.makeComponentParameterAstDTO(new ParameterValueContainer(null, (Object)componentParameterValue));
        ExtensionModel extensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)this.extensionModelResolver.resolve("someExtensionModel")).thenReturn((Object)extensionModel);
        ConfigurationModel componentAstDTOModel = (ConfigurationModel)Mockito.mock(ConfigurationModel.class);
        Mockito.when((Object)componentAstDTOModel.getAllParameterModels()).thenReturn(Collections.singletonList(parameterModel));
        Mockito.when((Object)componentAstDTOModel.getParameterGroupModels()).thenReturn(Collections.singletonList(parameterGroupModel));
        Mockito.when((Object)extensionModel.getConfigurationModel("configurationModelName")).thenReturn(Optional.of(componentAstDTOModel));
        ComponentAstDTO componentAstDTO = this.makeComponentAstDTO(new ExtensionModelDTO("someExtensionModel"), null, ComponentIdentifier.builder().name("configuration").namespace(DUMMY_NAMESPACE).namespaceUri(DUMMY_NAMESPACE_URI).build(), "configurationModelName", ComponentAstDTOModelType.CONFIGURATION, Collections.singletonList(componentParameterAstDTO), new ArrayList<ComponentAstDTO>());
        componentAstDTO.setParameterizedModel((ParameterizedModel)componentAstDTOModel);
        DefaultExtensionModelHelper extensionModelHelper = (DefaultExtensionModelHelper)Mockito.mock(DefaultExtensionModelHelper.class);
        ComponentGenerationInformationDTO componentGenerationInformationDTO = (ComponentGenerationInformationDTO)Mockito.mock(ComponentGenerationInformationDTO.class);
        DslElementSyntax componentSyntax = (DslElementSyntax)Mockito.mock(DslElementSyntax.class);
        Mockito.when((Object)componentGenerationInformationDTO.getSyntax()).thenReturn(Optional.ofNullable(componentSyntax));
        DslElementSyntax childSyntax = (DslElementSyntax)Mockito.mock(DslElementSyntax.class);
        Mockito.when((Object)componentSyntax.getChild((String)ArgumentMatchers.any())).thenReturn(Optional.of(childSyntax));
        Mockito.when((Object)childSyntax.isWrapped()).thenReturn((Object)false);
        Mockito.when((Object)generationInformationResolver.resolveComponentAstGenerationInformation(null, componentAstDTO, (ExtensionModelHelper)extensionModelHelper)).thenReturn((Object)componentGenerationInformationDTO);
        MetadataType metadataType = (MetadataType)Mockito.mock(MetadataType.class);
        Mockito.when((Object)unionType.getTypes()).thenReturn(Collections.singletonList(metadataType));
        ((UnionType)Mockito.doAnswer(invocation -> {
            UnionTypesVisitor argument = (UnionTypesVisitor)invocation.getArgument(0);
            argument.visitUnion(unionType);
            return argument;
        }).when((Object)unionType)).accept((MetadataTypeVisitor)ArgumentMatchers.any(UnionTypesVisitor.class));
        DslElementSyntax dslElementSyntax = (DslElementSyntax)Mockito.mock(DslElementSyntax.class);
        Mockito.when((Object)dslElementSyntax.getElementName()).thenReturn((Object)"aName");
        TypeCatalog typeCatalog = (TypeCatalog)Mockito.mock(TypeCatalog.class);
        Mockito.when((Object)typeCatalog.getType("someTypeId")).thenReturn(Optional.of((ObjectType)Mockito.mock(ObjectType.class)));
        Mockito.when((Object)extensionModelHelper.getTypeCatalog()).thenReturn((Object)typeCatalog);
        componentAstDTO.resolveModelsRecursively(null, (ExtensionModelHelper)extensionModelHelper, this.extensionModelResolver, (GenerationInformationResolver)generationInformationResolver, new ParameterModelUtils());
        ((UnionType)Mockito.verify((Object)unionType, (VerificationMode)Mockito.times((int)1))).accept((MetadataTypeVisitor)ArgumentMatchers.any(UnionTypesVisitor.class));
        ((DefaultGenerationInformationResolver)Mockito.verify((Object)generationInformationResolver, (VerificationMode)Mockito.never())).resolveComponentParameterAstGenerationInformation(componentParameterAstDTO, componentAstDTO, (ExtensionModelHelper)extensionModelHelper);
    }

    @Test
    @Issue(value="W-12244895")
    public void enrichExtensionModelNotFound() {
        ExtensionModelDTO nonExistantExtensionModelDTO = new ExtensionModelDTO("nonExistant");
        HashSet<ExtensionModelDTO> extensionModelDTOS = new HashSet<ExtensionModelDTO>(Arrays.asList(this.muleExtensionModelDTO, this.dummyExtensionModelDTO, nonExistantExtensionModelDTO));
        ArtifactAstDTO artifactAstDTO = new ArtifactAstDTO("myApp", ArtifactType.APPLICATION, extensionModelDTOS, Collections.emptyList(), (ErrorTypeRepositoryDTO)Mockito.mock(ErrorTypeRepositoryDTO.class), Collections.emptySet());
        artifactAstDTO.enrich(this.extensionModelResolver, this.generationInformationResolver, new ParameterModelUtils());
        ((ExtensionModelResolver)Mockito.verify((Object)this.extensionModelResolver)).resolve("nonExistant");
        MatcherAssert.assertThat((Object)artifactAstDTO.dependencies(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        MatcherAssert.assertThat((Object)artifactAstDTO.dependencies(), (Matcher)Matchers.everyItem((Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue()))));
    }

    private ComponentParameterAstDTO makeComponentParameterAstDTO(ParameterValueContainer value) {
        return new ComponentParameterAstDTO(value, null, false, null, "parameterGroupModelName", "parameterModelName");
    }

    private ArtifactAstDTO makeArtifactAstDTOWithOneComponent() {
        this.operationModel = this.initOperationModel();
        this.constructModel = this.initConstructModel();
        HashSet<ExtensionModelDTO> extensionModelDTOS = new HashSet<ExtensionModelDTO>(Arrays.asList(this.muleExtensionModelDTO, this.dummyExtensionModelDTO));
        ComponentAstDTO constructWithAChildOperationComponentAstDTO = this.makeComponentAstDTO(this.dummyExtensionModelDTO, "constructWithAChildOperation", ComponentIdentifier.builder().name(CONSTRUCT_MODEL_ELEMENT_NAME).namespace(DUMMY_NAMESPACE).namespaceUri(DUMMY_NAMESPACE_URI).build(), CONSTRUCT_MODEL_NAME, ComponentAstDTOModelType.CONSTRUCT, Arrays.asList(this.makeParameterWithAComponentAstValue(), this.makeParameterWithAnEmptyValue(CONSTRUCT_PARAM_GROUP_MODEL_NAME, "simpleParamModelName")), Collections.emptyList());
        List<ComponentAstDTO> topLevelComponents = Collections.singletonList(constructWithAChildOperationComponentAstDTO);
        ErrorTypeRepositoryDTO errorTypeRepositoryDTO = this.makeErrorTypeRepository();
        return new ArtifactAstDTO("myApp", ArtifactType.APPLICATION, extensionModelDTOS, topLevelComponents, errorTypeRepositoryDTO, Collections.emptySet());
    }

    private ArtifactAstDTO makeArtifactAstDTOWithStringListParam() {
        this.operationModel = this.initOperationModel();
        this.constructModel = this.initConstructModel();
        HashSet<ExtensionModelDTO> extensionModelDTOS = new HashSet<ExtensionModelDTO>(Arrays.asList(this.muleExtensionModelDTO, this.dummyExtensionModelDTO));
        ComponentAstDTO constructWithAChildOperationComponentAstDTO = this.makeComponentAstDTO(this.dummyExtensionModelDTO, "constructWithAChildOperation", ComponentIdentifier.builder().name(CONSTRUCT_MODEL_ELEMENT_NAME).namespace(DUMMY_NAMESPACE).namespaceUri(DUMMY_NAMESPACE_URI).build(), CONSTRUCT_MODEL_NAME, ComponentAstDTOModelType.CONSTRUCT, Arrays.asList(this.makeParameterWithAStringListValue(CONSTRUCT_PARAM_GROUP_MODEL_NAME, CONSTRUCT_STRING_LIST_PARAM_MODEL_NAME)), Collections.emptyList());
        List<ComponentAstDTO> topLevelComponents = Collections.singletonList(constructWithAChildOperationComponentAstDTO);
        ErrorTypeRepositoryDTO errorTypeRepositoryDTO = this.makeErrorTypeRepository();
        return new ArtifactAstDTO("myApp", ArtifactType.APPLICATION, extensionModelDTOS, topLevelComponents, errorTypeRepositoryDTO, Collections.emptySet());
    }

    private ArtifactAstDTO makeArtifactAstDTOWithComponentListParam() {
        this.operationModel = this.initOperationModel();
        this.constructModel = this.initConstructModel();
        this.paramValueConstructModel = this.initParamValueConstructModel();
        HashSet<ExtensionModelDTO> extensionModelDTOS = new HashSet<ExtensionModelDTO>(Arrays.asList(this.muleExtensionModelDTO, this.dummyExtensionModelDTO));
        ComponentAstDTO constructWithAChildOperationComponentAstDTO = this.makeComponentAstDTO(this.dummyExtensionModelDTO, "constructWithAChildOperation", ComponentIdentifier.builder().name(CONSTRUCT_MODEL_ELEMENT_NAME).namespace(DUMMY_NAMESPACE).namespaceUri(DUMMY_NAMESPACE_URI).build(), CONSTRUCT_MODEL_NAME, ComponentAstDTOModelType.CONSTRUCT, Arrays.asList(this.makeParameterWithAComponentListValue(CONSTRUCT_PARAM_GROUP_MODEL_NAME, CONSTRUCT_COMPONENT_LIST_PARAM_MODEL_NAME)), Collections.emptyList());
        List<ComponentAstDTO> topLevelComponents = Collections.singletonList(constructWithAChildOperationComponentAstDTO);
        ErrorTypeRepositoryDTO errorTypeRepositoryDTO = this.makeErrorTypeRepository();
        return new ArtifactAstDTO("myApp", ArtifactType.APPLICATION, extensionModelDTOS, topLevelComponents, errorTypeRepositoryDTO, Collections.emptySet());
    }

    private ArtifactAstDTO makeArtifactAstDTOWithOneInfrastructureParameter() {
        HashSet<ExtensionModelDTO> dependencies = new HashSet<ExtensionModelDTO>(Arrays.asList(this.muleExtensionModelDTO, this.dummyExtensionModelDTO));
        ComponentAstDTO infrastructureParameterComponentAstDTO = this.makeComponentAstDTO(this.dummyExtensionModelDTO, "infrastructureParameter", ComponentIdentifier.builder().name("error-mapping").namespace("mule").namespaceUri("http://www.mulesoft.org/schema/mule/core").build(), "ErrorMapping", ComponentAstDTOModelType.INFRASTRUCTURE, Collections.singletonList(this.makeParameterWithAStringValue("ErrorMapping", "name")), Collections.emptyList());
        List<ComponentAstDTO> topLevelComponents = Collections.singletonList(infrastructureParameterComponentAstDTO);
        return new ArtifactAstDTO("myApp", ArtifactType.APPLICATION, dependencies, topLevelComponents, (ErrorTypeRepositoryDTO)Mockito.mock(ErrorTypeRepositoryDTO.class), Collections.emptySet());
    }

    private ArtifactAstDTO makeArtifactAstDTOWithOneInfrastructureType() {
        HashSet<ExtensionModelDTO> dependencies = new HashSet<ExtensionModelDTO>(Arrays.asList(this.muleExtensionModelDTO, this.dummyExtensionModelDTO));
        ComponentAstDTO infrastructureTypeComponentAstDTO = this.makeComponentAstDTO(this.muleExtensionModelDTO, "errorMappings", ComponentIdentifier.builder().name("error-mapping").namespace("mule").namespaceUri("http://www.mulesoft.org/schema/mule/core").build(), INFRASTRUCTURE_TYPE_PARAMETERIZED_MODEL_NAME, ComponentAstDTOModelType.INFRASTRUCTURE, Collections.singletonList(this.makeParameterWithAStringValue("ErrorMapping", "name")), Collections.emptyList());
        List<ComponentAstDTO> topLevelComponents = Collections.singletonList(infrastructureTypeComponentAstDTO);
        return new ArtifactAstDTO("myApp", ArtifactType.APPLICATION, dependencies, topLevelComponents, (ErrorTypeRepositoryDTO)Mockito.mock(ErrorTypeRepositoryDTO.class), Collections.emptySet());
    }

    private ErrorTypeRepositoryDTO makeErrorTypeRepository() {
        return new ErrorTypeRepositoryDTO(this.makeErrorType("ANY", null), this.makeErrorType("SOURCE", this.makeErrorType("ANY", null)), this.makeErrorType("SOURCE_RESPONSE", this.makeErrorType("ANY", null)), this.makeErrorType("CRITICAL", this.makeErrorType("ANY", null)), new HashSet<ErrorType>(Arrays.asList(this.makeErrorType("FIRST", this.makeErrorType("ANY", null)), this.makeErrorType("SECOND", this.makeErrorType("ANY", null)))), new HashSet<ErrorType>(Arrays.asList(this.makeErrorType("FIRST_INTERNAL", this.makeErrorType("ANY", null)), this.makeErrorType("SECOND_INTERNAL", this.makeErrorType("ANY", null)), this.makeErrorType("THIRD_INTERNAL", this.makeErrorType("ANY", null)))));
    }

    private ErrorType makeErrorType(String name, ErrorType parentErrorType) {
        ErrorType anyErrorType = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)anyErrorType.getIdentifier()).thenReturn((Object)name);
        Mockito.when((Object)anyErrorType.getNamespace()).thenReturn((Object)DUMMY_NAMESPACE);
        Mockito.when((Object)anyErrorType.getParentErrorType()).thenReturn((Object)parentErrorType);
        return anyErrorType;
    }

    private OperationModel initOperationModel() {
        OperationModel operationModel = (OperationModel)Mockito.mock(OperationModel.class);
        Mockito.when((Object)operationModel.getName()).thenReturn((Object)OPERATION_MODEL_NAME);
        ParameterGroupModel mockParameterGroupModel = this.mockParameterGroupModel(OPERATION_PARAM_GROUP_MODEL_NAME);
        Mockito.when((Object)operationModel.getParameterGroupModels()).thenReturn(Collections.singletonList(mockParameterGroupModel));
        ParameterModel mockParameterModel = this.mockParameterModel("simpleParamModelName", ParameterRole.CONTENT, new TestMetadataType());
        Mockito.when((Object)operationModel.getAllParameterModels()).thenReturn(Collections.singletonList(mockParameterModel));
        return operationModel;
    }

    private ConstructModel initConstructModel() {
        ConstructModel constructModel = (ConstructModel)Mockito.mock(ConstructModel.class);
        Mockito.when((Object)constructModel.getName()).thenReturn((Object)CONSTRUCT_MODEL_NAME);
        ParameterGroupModel parameterGroupModel = this.mockParameterGroupModel(CONSTRUCT_PARAM_GROUP_MODEL_NAME);
        Mockito.when((Object)constructModel.getParameterGroupModels()).thenReturn(Collections.singletonList(parameterGroupModel));
        ParameterModel mockParameterWithComponentValueModel = this.mockParameterModel(CONSTRUCT_COMPONENT_AST_PARAM_MODEL_NAME, ParameterRole.BEHAVIOUR, new TestMetadataType());
        ParameterModel mockParameterWithStringListModel = this.mockParameterModel(CONSTRUCT_STRING_LIST_PARAM_MODEL_NAME, ParameterRole.BEHAVIOUR, (MetadataType)new BaseTypeBuilder(MetadataFormat.JAVA).arrayType().of((TypeBuilder)new BaseTypeBuilder(MetadataFormat.JAVA).stringType()).build());
        ObjectTypeBuilder objectTypeBuilder = new BaseTypeBuilder(MetadataFormat.JAVA).objectType();
        objectTypeBuilder.addField().key("fieldA").value((TypeBuilder)new BaseTypeBuilder(MetadataFormat.JAVA).stringType()).build();
        objectTypeBuilder.addField().key("fieldB").value((TypeBuilder)new BaseTypeBuilder(MetadataFormat.JAVA).stringType()).build();
        ObjectType componentType = objectTypeBuilder.build();
        ParameterModel mockParameterWithComponentListModel = this.mockParameterModel(CONSTRUCT_COMPONENT_LIST_PARAM_MODEL_NAME, ParameterRole.BEHAVIOUR, (MetadataType)new BaseTypeBuilder(MetadataFormat.JAVA).arrayType().of((MetadataType)componentType).build());
        ParameterModel mockParameterModel = this.mockParameterModel("simpleParamModelName", ParameterRole.CONTENT, new TestMetadataType());
        Mockito.when((Object)constructModel.getAllParameterModels()).thenReturn(Arrays.asList(mockParameterWithComponentValueModel, mockParameterWithStringListModel, mockParameterWithComponentListModel, mockParameterModel));
        return constructModel;
    }

    private ConstructModel initParamValueConstructModel() {
        ConstructModel constructModel = (ConstructModel)Mockito.mock(ConstructModel.class);
        Mockito.when((Object)constructModel.getName()).thenReturn((Object)"componentsList");
        ParameterGroupModel parameterGroupModel = this.mockParameterGroupModel(CONSTRUCT_PARAM_GROUP_MODEL_NAME);
        Mockito.when((Object)constructModel.getParameterGroupModels()).thenReturn(Collections.singletonList(parameterGroupModel));
        ParameterModel mockParameterWithComponentValueModel = this.mockParameterModel(CONSTRUCT_COMPONENT_AST_PARAM_MODEL_NAME, ParameterRole.BEHAVIOUR, new TestMetadataType());
        ParameterModel mockParameterWithStringListModel = this.mockParameterModel(CONSTRUCT_STRING_LIST_PARAM_MODEL_NAME, ParameterRole.BEHAVIOUR, (MetadataType)new BaseTypeBuilder(MetadataFormat.JAVA).arrayType().of((TypeBuilder)new BaseTypeBuilder(MetadataFormat.JAVA).stringType()).build());
        ParameterModel mockParameterModel = this.mockParameterModel("simpleParamModelName", ParameterRole.CONTENT, new TestMetadataType());
        Mockito.when((Object)constructModel.getAllParameterModels()).thenReturn(Arrays.asList(mockParameterWithComponentValueModel, mockParameterWithStringListModel, mockParameterModel));
        return constructModel;
    }

    private ExtensionModelResolver initExtensionModelResolver() {
        ExtensionModelResolver extensionModelResolver = (ExtensionModelResolver)Mockito.mock(ExtensionModelResolver.class);
        Mockito.when((Object)extensionModelResolver.resolve(this.muleExtensionModelDTO.getName())).thenReturn((Object)new DummyExtensionModel(this.muleExtensionModelDTO.getName()));
        Mockito.when((Object)extensionModelResolver.resolve(this.dummyExtensionModelDTO.getName())).thenReturn((Object)new DummyExtensionModel(this.dummyExtensionModelDTO.getName(), Collections.singletonList(this.operationModel), Collections.emptyList(), Collections.emptyList(), Arrays.asList(this.constructModel, this.paramValueConstructModel), new ArrayList<ConnectionProviderModel>()));
        return extensionModelResolver;
    }

    private ComponentParameterAstDTO makeParameterWithAnEmptyValue(String parameterGroupModelName, String parameterModelName) {
        return new ComponentParameterAstDTO(null, "unresolvedValue", false, new ComponentMetadataAstDTO(), parameterGroupModelName, parameterModelName);
    }

    private ComponentParameterAstDTO makeParameterWithAStringValue(String parameterGroupModelName, String parameterModelName) {
        ParameterValueContainer value = new ParameterValueContainer(null, (Object)"some value");
        return new ComponentParameterAstDTO(value, "unresolvedValue", false, this.makeEmptyComponentMetadataAstDTO(), parameterGroupModelName, parameterModelName);
    }

    private ComponentParameterAstDTO makeParameterWithAStringListValue(String parameterGroupModelName, String parameterModelName) {
        ParameterValueContainer value = new ParameterValueContainer(null, Arrays.asList(this.makeComponentAstDTO(this.dummyExtensionModelDTO, "stringsList", ComponentIdentifier.builder().name("strings-list").namespace(DUMMY_NAMESPACE).namespaceUri(DUMMY_NAMESPACE_URI).build(), "stringsList", ComponentAstDTOModelType.CONSTRUCT, Arrays.asList(this.makeParameterWithAStringValue("General", "value")), Collections.emptyList()), this.makeComponentAstDTO(this.dummyExtensionModelDTO, "stringsList", ComponentIdentifier.builder().name("strings-list").namespace(DUMMY_NAMESPACE).namespaceUri(DUMMY_NAMESPACE_URI).build(), "stringsList", ComponentAstDTOModelType.CONSTRUCT, Arrays.asList(this.makeParameterWithAStringValue("General", "value")), Collections.emptyList())));
        return new ComponentParameterAstDTO(value, "unresolvedValue", false, this.makeEmptyComponentMetadataAstDTO(), parameterGroupModelName, parameterModelName);
    }

    private ComponentParameterAstDTO makeParameterWithAComponentListValue(String parameterGroupModelName, String parameterModelName) {
        ParameterValueContainer value = new ParameterValueContainer(null, Arrays.asList(this.makeComponentAstDTO(this.dummyExtensionModelDTO, "componentsList", ComponentIdentifier.builder().name("components-list").namespace(DUMMY_NAMESPACE).namespaceUri(DUMMY_NAMESPACE_URI).build(), "componentsList", ComponentAstDTOModelType.CONSTRUCT, Arrays.asList(this.makeParameterWithAComponentAstValue()), Collections.emptyList()), this.makeComponentAstDTO(this.dummyExtensionModelDTO, "componentsList", ComponentIdentifier.builder().name("components-list").namespace(DUMMY_NAMESPACE).namespaceUri(DUMMY_NAMESPACE_URI).build(), "componentsList", ComponentAstDTOModelType.CONSTRUCT, Arrays.asList(this.makeParameterWithAComponentAstValue()), Collections.emptyList())));
        return new ComponentParameterAstDTO(value, "unresolvedValue", false, this.makeEmptyComponentMetadataAstDTO(), parameterGroupModelName, parameterModelName);
    }

    private ComponentParameterAstDTO makeParameterWithAComponentAstValue() {
        return new ComponentParameterAstDTO(new ParameterValueContainer(null, (Object)this.makeComponentAstDTO(this.dummyExtensionModelDTO, "level1children1Id", ComponentIdentifier.builder().name(OPERATION_MODEL_ELEMENT_NAME).namespace(DUMMY_NAMESPACE).namespaceUri(DUMMY_NAMESPACE_URI).build(), OPERATION_MODEL_NAME, ComponentAstDTOModelType.OPERATION, Collections.singletonList(this.makeParameterWithAnEmptyValue(OPERATION_PARAM_GROUP_MODEL_NAME, "simpleParamModelName")), Collections.emptyList())), "unresolvedValue", false, this.makeEmptyComponentMetadataAstDTO(), CONSTRUCT_PARAM_GROUP_MODEL_NAME, CONSTRUCT_COMPONENT_AST_PARAM_MODEL_NAME);
    }

    private ComponentAstDTO makeComponentAstDTO(ExtensionModelDTO dummyExtensionModelDTO, String componentId, ComponentIdentifier identifier, String modelName, ComponentAstDTOModelType modelType, List<ComponentParameterAstDTO> parameters, List<ComponentAstDTO> directChildren) {
        ComponentAstDTO componentAstDTO = new ComponentAstDTO(directChildren, TypedComponentIdentifier.ComponentType.UNKNOWN.toString(), identifier, (ComponentLocation)Mockito.mock(ComponentLocation.class), null, parameters, componentId, dummyExtensionModelDTO, modelName, modelType, null);
        componentAstDTO.setGenerationInformation(new ComponentGenerationInformationDTO(new DslElementSyntax(identifier.getName(), identifier.getName(), "dum", DUMMY_NAMESPACE, false, false, false, false, false, null, new HashMap())));
        return componentAstDTO;
    }

    private ComponentMetadataAstDTO makeEmptyComponentMetadataAstDTO() {
        return new ComponentMetadataAstDTO(null, null, null, null, null, Collections.emptyList(), null, null, null, null);
    }

    private ParameterGroupModel mockParameterGroupModel(String paramGroupModelName) {
        ParameterGroupModel parameterGroupModel = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)parameterGroupModel.getName()).thenReturn((Object)paramGroupModelName);
        return parameterGroupModel;
    }

    private ParameterModel mockParameterModel(String paramModelName, ParameterRole parameterRole, MetadataType metadataType) {
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)paramModelName);
        Mockito.when((Object)parameterModel.getRole()).thenReturn((Object)parameterRole);
        Mockito.when((Object)parameterModel.getType()).thenReturn((Object)metadataType);
        Mockito.when((Object)parameterModel.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        return parameterModel;
    }

    private static class TestMetadataType
    implements MetadataType {
        private TestMetadataType() {
        }

        public MetadataFormat getMetadataFormat() {
            return new MetadataFormat("label", "id", new String[]{"mimetype1", "mimetype2"});
        }

        public <T extends TypeAnnotation> Optional<T> getAnnotation(Class<T> annotation) {
            return Optional.empty();
        }

        public Set<TypeAnnotation> getAnnotations() {
            return Collections.singleton(new ExampleAnnotation("exampleValue"));
        }

        public Optional<String> getDescription() {
            return Optional.of("TestMetadataTypeDescription");
        }

        public void accept(MetadataTypeVisitor visitor) {
        }
    }
}

