/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.serialization;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.serialization.ArtifactAstSerializer;
import org.mule.runtime.ast.internal.serialization.ArtifactAstSerializerFactory;

@Feature(value="AST serialization")
@Stories(value={@Story(value="AST serialization versioning"), @Story(value="AST Json deserialization"), @Story(value="AST Json serialization")})
public class ArtifactAstSerializerFactoryTestCase {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private ArtifactAstSerializerFactory artifactAstSerializerFactory;
    private Executor executor;

    @Before
    public void setUp() {
        this.executor = (Executor)Mockito.spy((Object)Executors.newSingleThreadExecutor());
        this.artifactAstSerializerFactory = new ArtifactAstSerializerFactory(this.executor, true);
    }

    @Test
    public void testGetSerializerThrowsIllegalArgumentExceptionUnexistingFormat_WhenGettingSerializerForUnexistingFormat() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("No serializer named 'UNEXISTING' version '1.0' is available. Available serializers are: [" + StringUtils.join((Iterable)this.artifactAstSerializerFactory.getAvailableSerializers(), (String)", ") + "]");
        this.artifactAstSerializerFactory.getSerializer("UNEXISTING", "1.0");
    }

    @Test
    public void testGetSerializerThrowsIllegalArgumentException123Version_WhenGettingSerializerFor123Version() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("No serializer named 'JSON' version '12.3' is available. Available serializers are: [" + StringUtils.join((Iterable)this.artifactAstSerializerFactory.getAvailableSerializers(), (String)", ") + "]");
        this.artifactAstSerializerFactory.getSerializer("JSON", "12.3");
    }

    @Test
    @Issue(value="MULE-19748")
    public void testGetSerializerReturnsASerializerThatUsesTheExecutorToExecuteARunnable_WhenGettingASerializerAndAnExecutorIsConfigured() {
        ArtifactAst artifactAst = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        Mockito.when((Object)artifactAst.getErrorTypeRepository()).thenReturn((Object)((ErrorTypeRepository)Mockito.mock(ErrorTypeRepository.class)));
        ArtifactAstSerializer jsonSerializer = this.artifactAstSerializerFactory.getSerializer("JSON", "1.0");
        jsonSerializer.serialize(artifactAst);
        ((Executor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).execute((Runnable)ArgumentMatchers.any(Runnable.class));
    }

    @Test
    public void testGetDeserializerThrowsIllegalArgumentExceptionUnexisting2Format_WhenGettingDeserializerForUnexisting2Format() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("No deserializer named 'UNEXISTING2' version '2.3' is available. Available deserializers are: [" + StringUtils.join((Iterable)this.artifactAstSerializerFactory.getAvailableSerializers(), (String)", ") + "]");
        this.artifactAstSerializerFactory.getDeserializer("UNEXISTING2", "2.3");
    }

    @Test
    public void testGetDeserializerThrowsIllegalArgumentException123Version_WhenGettingDeserializerFor123Version() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("No deserializer named 'JSON' version '12.3' is available. Available deserializers are: [" + StringUtils.join((Iterable)this.artifactAstSerializerFactory.getAvailableSerializers(), (String)", ") + "]");
        this.artifactAstSerializerFactory.getDeserializer("JSON", "12.3");
    }

    @Test
    public void testGetDeserializerThrowsNullPointerException_WhenGettingDeserializerWithNullFormatParameter() {
        this.exception.expect(NullPointerException.class);
        this.exception.expectMessage("format");
        this.artifactAstSerializerFactory.getDeserializer(null, "12.3");
    }

    @Test
    public void testGetDeserializerThrowsNullPointerException_WhenGettingDeserializerWithNullSerializerVersionParameter() {
        this.exception.expect(NullPointerException.class);
        this.exception.expectMessage("serializerVersion");
        this.artifactAstSerializerFactory.getDeserializer("JSON", null);
    }

    @Test
    public void testGetAvailableSerializers() {
        List availableSerializers = this.artifactAstSerializerFactory.getAvailableSerializers();
        MatcherAssert.assertThat((Object)availableSerializers, (Matcher)Matchers.hasItems((Object[])new String[]{"JSON[1.0]", "JSON[1.1]"}));
    }
}

