/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.serialization.dto;

import org.mule.runtime.ast.internal.serialization.ArtifactAstSerializerMetadata;

/**
 * Marker interface for DTOs that need to be aware of the {@link ArtifactAstSerializerMetadata}.
 *
 * @since 1.3, 1.2, 1.1.4
 */
public interface ArtifactAstSerializerMetadataAware {

  /**
   * Sets the given {@link ArtifactAstSerializerMetadata} to this instance.
   *
   * @param artifactAstSerializerMetadata The {@link ArtifactAstSerializerMetadata} associated with this DTO's
   *                                      serialization/deserialization context.
   */
  void setArtifactAstSerializerMetadata(ArtifactAstSerializerMetadata artifactAstSerializerMetadata);
}
