/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.serialization.dto.factory;

import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.internal.serialization.dto.ImportedResourceDTO;

public class ImportedResourceDTOFactory {

  private final AstDTOFactoryProvider astDTOFactoryProvider;

  public ImportedResourceDTOFactory(AstDTOFactoryProvider astDTOFactoryProvider) {
    this.astDTOFactoryProvider = astDTOFactoryProvider;
  }

  public ImportedResourceDTO from(ImportedResource importedResource) {
    return new ImportedResourceDTO(importedResource.getRawResourceLocation(),
                                   astDTOFactoryProvider.getComponentMetadataAstDTOFactory()
                                       .from(importedResource.getMetadata()),
                                   importedResource.getResolutionFailure().orElse(null));
  }

}
