/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.serialization.visitor;

import static org.mule.metadata.api.utils.MetadataTypeUtils.getTypeId;

import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.ast.internal.serialization.dto.ComponentAstDTO;

public class SetComponentAstDTOTypeMetadataTypeVisitor extends MetadataTypeVisitor {

  private final ComponentAstDTO componentAstDTO;

  public SetComponentAstDTOTypeMetadataTypeVisitor(ComponentAstDTO componentAstDTO) {
    this.componentAstDTO = componentAstDTO;
  }

  @Override
  protected void defaultVisit(MetadataType metadataType) {
    componentAstDTO.setType(metadataType);
  }

  @Override
  public void visitUnion(UnionType unionType) {
    unionType.getTypes().stream()
        .filter(type -> getTypeId(type).map(id -> id.equals(componentAstDTO.getModelName())).orElse(false)).findAny()
        .ifPresent(componentAstDTO::setType);
  }
}
