/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.serialization.dto.factory;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.api.error.ErrorTypeRepositoryProvider;
import org.mule.runtime.ast.internal.error.CompositeErrorTypeRepository;
import org.mule.runtime.ast.internal.error.DefaultErrorTypeRepository;
import org.mule.runtime.ast.internal.serialization.dto.ErrorTypeRepositoryDTO;
import org.mule.runtime.ast.internal.serialization.dto.factory.ErrorTypeRepositoryDTOFactory;

@Feature(value="AST serialization")
@Story(value="AST serializable representation")
public class ErrorTypeRepositoryDTOFactoryTestCase {
    private static final ErrorTypeRepository CORE_ERROR_TYPE_REPOSITORY = ErrorTypeRepositoryProvider.getCoreErrorTypeRepo();
    private ErrorTypeRepository coreErrorTypeRepo;
    private ErrorTypeRepository errorTypeRepository;
    private ErrorTypeRepositoryDTOFactory errorTypeRepositoryDTOFactory;

    @Before
    public void setUp() throws Exception {
        this.errorTypeRepositoryDTOFactory = new ErrorTypeRepositoryDTOFactory();
        this.coreErrorTypeRepo = CORE_ERROR_TYPE_REPOSITORY;
        this.errorTypeRepository = new DefaultErrorTypeRepository();
    }

    @Test
    public void testBuildReturnsErrorTypeRepositoryDTOWithOneErrorTypeDTO_WhenBuildingFromAnErrorTypeRepositoryWithOneErrorType() {
        this.addErrorType("boom", "chaka", this.errorTypeRepository);
        ErrorTypeRepositoryDTO errorTypeRepositoryDTO = this.toErrorTypeRepoDto();
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getErrorTypes().stream().filter(errorType -> !errorType.getNamespace().equals("MULE")).count(), (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void testBuildReturnsErrorTypeRepositoryDTOWithOneErrorTypeDTOJuan_WhenBuildingFromAnErrorTypeRepositoryWithOneErrorTypeJuan() {
        this.addErrorType("Juan", "Jhon", this.errorTypeRepository);
        ErrorTypeRepositoryDTO errorTypeRepositoryDTO = this.toErrorTypeRepoDto();
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getErrorTypes().stream().filter(errorType -> !errorType.getNamespace().equals("MULE")).count(), (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void testBuildReturnsErrorTypeRepositoryDTOWithTwoErrorTypeDTOs_WhenBuildingFromAnErrorTypeRepositoryWithTwoErrorTypes() {
        this.addErrorType("Juan", "Jhon", this.errorTypeRepository);
        this.addErrorType("Maria", "Mary", this.errorTypeRepository);
        ErrorTypeRepositoryDTO errorTypeRepositoryDTO = this.toErrorTypeRepoDto();
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getErrorTypes().stream().filter(errorType -> !errorType.getNamespace().equals("MULE")).count(), (Matcher)Matchers.is((Object)2L));
    }

    @Test
    public void testBuildReturnsErrorTypeRepositoryDTOWithSameCharacteristics_WhenBuildingFromAnErrorTypeRepository() {
        ComponentIdentifier componentIdentifier = this.addErrorType("boom", "CHAKA", this.errorTypeRepository);
        ErrorTypeRepositoryDTO errorTypeRepositoryDTO = this.toErrorTypeRepoDto();
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getErrorTypes().stream().filter(errorType -> !errorType.getNamespace().equals("MULE")).count(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getInternalErrorTypes().stream().filter(errorType -> !errorType.getNamespace().equals("MULE")).count(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat(errorTypeRepositoryDTO.getErrorNamespaces().stream().filter(ns -> !ns.equals("MULE")).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])this.errorTypeRepository.getErrorNamespaces().toArray()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getAnyErrorType(), (Matcher)Matchers.is((Object)this.coreErrorTypeRepo.getAnyErrorType()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getCriticalErrorType(), (Matcher)Matchers.is((Object)this.coreErrorTypeRepo.getCriticalErrorType()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getSourceErrorType(), (Matcher)Matchers.is((Object)this.coreErrorTypeRepo.getSourceErrorType()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getSourceResponseErrorType(), (Matcher)Matchers.is((Object)this.coreErrorTypeRepo.getSourceResponseErrorType()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.lookupErrorType(componentIdentifier), (Matcher)Matchers.is((Object)this.errorTypeRepository.lookupErrorType(componentIdentifier)));
    }

    @Test
    public void testBuildReturnsErrorTypeRepositoryDTOWithSameCharacteristics_WhenBuildingFromAnErrorTypeRepositoryWithTwoErrorTypes() {
        ComponentIdentifier componentIdentifier = this.addErrorType("boom", "CHAKA", this.errorTypeRepository);
        ComponentIdentifier componentIdentifier2 = this.addErrorType("UNKNOWN", "EXT", this.errorTypeRepository);
        ErrorTypeRepositoryDTO errorTypeRepositoryDTO = this.toErrorTypeRepoDto();
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getErrorTypes().stream().filter(errorType -> !errorType.getNamespace().equals("MULE")).count(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getInternalErrorTypes().stream().filter(errorType -> !errorType.getNamespace().equals("MULE")).count(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat(errorTypeRepositoryDTO.getErrorNamespaces().stream().filter(ns -> !ns.equals("MULE")).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])this.errorTypeRepository.getErrorNamespaces().toArray()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getAnyErrorType(), (Matcher)Matchers.is((Object)this.coreErrorTypeRepo.getAnyErrorType()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getCriticalErrorType(), (Matcher)Matchers.is((Object)this.coreErrorTypeRepo.getCriticalErrorType()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getSourceErrorType(), (Matcher)Matchers.is((Object)this.coreErrorTypeRepo.getSourceErrorType()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getSourceResponseErrorType(), (Matcher)Matchers.is((Object)this.coreErrorTypeRepo.getSourceResponseErrorType()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.lookupErrorType(componentIdentifier), (Matcher)Matchers.is((Object)this.errorTypeRepository.lookupErrorType(componentIdentifier)));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.lookupErrorType(componentIdentifier2), (Matcher)Matchers.is((Object)this.errorTypeRepository.lookupErrorType(componentIdentifier2)));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getErrorType(componentIdentifier), (Matcher)Matchers.is((Object)this.errorTypeRepository.getErrorType(componentIdentifier)));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getErrorType(componentIdentifier2), (Matcher)Matchers.is((Object)this.errorTypeRepository.getErrorType(componentIdentifier2)));
    }

    @Test
    public void testBuildReturnsErrorTypeRepositoryDTOWithSameCharacteristics_WhenBuildingFromAnErrorTypeRepositoryWithTwoErrorTypesAndTwoInternalErrorTypes() {
        ComponentIdentifier componentIdentifier = this.addErrorType("boom", "CHAKA", this.errorTypeRepository);
        ComponentIdentifier componentIdentifier2 = this.addErrorType("UNKNOWN", "EXT", this.errorTypeRepository);
        ComponentIdentifier internalComponentIdentifier = this.addInternalErrorType("int", "ER", this.errorTypeRepository);
        ComponentIdentifier internalComponentIdentifier2 = this.addInternalErrorType("KNOWN", "EXT", this.errorTypeRepository);
        ErrorTypeRepositoryDTO errorTypeRepositoryDTO = this.toErrorTypeRepoDto();
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getErrorTypes().stream().filter(errorType -> !errorType.getNamespace().equals("MULE")).count(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getInternalErrorTypes().stream().filter(errorType -> !errorType.getNamespace().equals("MULE")).count(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat(errorTypeRepositoryDTO.getErrorNamespaces().stream().filter(ns -> !ns.equals("MULE")).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])this.errorTypeRepository.getErrorNamespaces().toArray()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getAnyErrorType(), (Matcher)Matchers.is((Object)this.coreErrorTypeRepo.getAnyErrorType()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getCriticalErrorType(), (Matcher)Matchers.is((Object)this.coreErrorTypeRepo.getCriticalErrorType()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getSourceErrorType(), (Matcher)Matchers.is((Object)this.coreErrorTypeRepo.getSourceErrorType()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getSourceResponseErrorType(), (Matcher)Matchers.is((Object)this.coreErrorTypeRepo.getSourceResponseErrorType()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.lookupErrorType(componentIdentifier), (Matcher)Matchers.is((Object)this.errorTypeRepository.lookupErrorType(componentIdentifier)));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.lookupErrorType(componentIdentifier2), (Matcher)Matchers.is((Object)this.errorTypeRepository.lookupErrorType(componentIdentifier2)));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.lookupErrorType(internalComponentIdentifier), (Matcher)Matchers.is((Object)this.errorTypeRepository.lookupErrorType(internalComponentIdentifier)));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.lookupErrorType(internalComponentIdentifier2), (Matcher)Matchers.is((Object)this.errorTypeRepository.lookupErrorType(internalComponentIdentifier2)));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getErrorType(componentIdentifier), (Matcher)Matchers.is((Object)this.errorTypeRepository.getErrorType(componentIdentifier)));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getErrorType(componentIdentifier2), (Matcher)Matchers.is((Object)this.errorTypeRepository.getErrorType(componentIdentifier2)));
    }

    @Test
    public void testBuildReturnsErrorTypeRepositoryDTOWithSameCharacteristicsAsComposite_WhenBuildingFromACompositeErrorTypeRepositoryWithTwoErrorTypesAndTwoInternalErrorTypes() {
        ArrayList<DefaultErrorTypeRepository> children = new ArrayList<DefaultErrorTypeRepository>();
        DefaultErrorTypeRepository defaultErrorTypeRepository1 = new DefaultErrorTypeRepository();
        children.add(defaultErrorTypeRepository1);
        DefaultErrorTypeRepository defaultErrorTypeRepository2 = new DefaultErrorTypeRepository();
        children.add(defaultErrorTypeRepository2);
        ComponentIdentifier componentIdentifier = this.addErrorType("boom", "CHAKA", (ErrorTypeRepository)defaultErrorTypeRepository1);
        ComponentIdentifier componentIdentifier2 = this.addErrorType("UNKNOWN", "EXT", (ErrorTypeRepository)defaultErrorTypeRepository2);
        ComponentIdentifier internalComponentIdentifier = this.addInternalErrorType("int", "ER", (ErrorTypeRepository)defaultErrorTypeRepository1);
        ComponentIdentifier internalComponentIdentifier2 = this.addInternalErrorType("KNOWN", "EXT", (ErrorTypeRepository)defaultErrorTypeRepository2);
        this.errorTypeRepository = new CompositeErrorTypeRepository(children);
        ErrorTypeRepositoryDTO errorTypeRepositoryDTO = this.toErrorTypeRepoDto();
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getErrorTypes().stream().filter(errorType -> !errorType.getNamespace().equals("MULE")).count(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getInternalErrorTypes().stream().filter(errorType -> !errorType.getNamespace().equals("MULE")).count(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat(errorTypeRepositoryDTO.getErrorNamespaces().stream().filter(ns -> !ns.equals("MULE")).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])this.errorTypeRepository.getErrorNamespaces().toArray()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getAnyErrorType(), (Matcher)Matchers.is((Object)this.coreErrorTypeRepo.getAnyErrorType()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getCriticalErrorType(), (Matcher)Matchers.is((Object)this.coreErrorTypeRepo.getCriticalErrorType()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getSourceErrorType(), (Matcher)Matchers.is((Object)this.coreErrorTypeRepo.getSourceErrorType()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getSourceResponseErrorType(), (Matcher)Matchers.is((Object)this.coreErrorTypeRepo.getSourceResponseErrorType()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.lookupErrorType(componentIdentifier), (Matcher)Matchers.is((Object)this.errorTypeRepository.lookupErrorType(componentIdentifier)));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.lookupErrorType(componentIdentifier2), (Matcher)Matchers.is((Object)this.errorTypeRepository.lookupErrorType(componentIdentifier2)));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.lookupErrorType(internalComponentIdentifier), (Matcher)Matchers.is((Object)this.errorTypeRepository.lookupErrorType(internalComponentIdentifier)));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.lookupErrorType(internalComponentIdentifier2), (Matcher)Matchers.is((Object)this.errorTypeRepository.lookupErrorType(internalComponentIdentifier2)));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getErrorType(componentIdentifier), (Matcher)Matchers.is((Object)this.errorTypeRepository.getErrorType(componentIdentifier)));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getErrorType(componentIdentifier2), (Matcher)Matchers.is((Object)this.errorTypeRepository.getErrorType(componentIdentifier2)));
    }

    @Test
    public void testBuildReturnsErrorTypeRepositoryDTOWithSameCharacteristicsAsMuleCore_WhenBuildingFromAMuleCoreErrorTypeRepository() {
        this.errorTypeRepository = CORE_ERROR_TYPE_REPOSITORY;
        ErrorTypeRepositoryDTO errorTypeRepositoryDTO = this.toErrorTypeRepoDto();
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getErrorTypes().size(), (Matcher)Matchers.is((Object)this.errorTypeRepository.getErrorTypes().size()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getInternalErrorTypes().size(), (Matcher)Matchers.is((Object)this.errorTypeRepository.getInternalErrorTypes().size()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getErrorNamespaces(), (Matcher)Matchers.containsInAnyOrder((Object[])this.errorTypeRepository.getErrorNamespaces().toArray()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getAnyErrorType(), (Matcher)Matchers.is((Object)this.errorTypeRepository.getAnyErrorType()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getCriticalErrorType(), (Matcher)Matchers.is((Object)this.errorTypeRepository.getCriticalErrorType()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getSourceErrorType(), (Matcher)Matchers.is((Object)this.errorTypeRepository.getSourceErrorType()));
        MatcherAssert.assertThat((Object)errorTypeRepositoryDTO.getSourceResponseErrorType(), (Matcher)Matchers.is((Object)this.errorTypeRepository.getSourceResponseErrorType()));
    }

    @Test
    @Issue(value="MULE-19683")
    public void errorTypeNamespaceCaseInsensitive() {
        ComponentIdentifier componentIdentifier = this.addErrorType("boom", "CHAKA", this.errorTypeRepository);
        ErrorTypeRepositoryDTO errorTypeRepositoryDTO = this.toErrorTypeRepoDto();
        Optional lookupErrorType = errorTypeRepositoryDTO.lookupErrorType(ComponentIdentifier.builder().name("boom").namespace("CHAKA".toLowerCase()).build());
        MatcherAssert.assertThat((Object)((ErrorType)lookupErrorType.get()).getNamespace(), (Matcher)Matchers.is((Object)componentIdentifier.getNamespace()));
        MatcherAssert.assertThat((Object)((ErrorType)lookupErrorType.get()).getIdentifier(), (Matcher)Matchers.is((Object)componentIdentifier.getName()));
    }

    @Test
    @Issue(value="W-16237424")
    public void errorTypeNamespaceWithTrailingWhiteSpace() {
        this.addErrorType("   boom     ", "    CHAKA    ", this.errorTypeRepository);
        ErrorTypeRepositoryDTO errorTypeRepositoryDTO = this.toErrorTypeRepoDto();
        Optional lookupErrorType = errorTypeRepositoryDTO.lookupErrorType(ComponentIdentifier.builder().name("boom").namespace("CHAKA".toLowerCase()).build());
        MatcherAssert.assertThat((Object)((ErrorType)lookupErrorType.get()).getNamespace(), (Matcher)Matchers.is((Object)"CHAKA"));
        MatcherAssert.assertThat((Object)((ErrorType)lookupErrorType.get()).getIdentifier(), (Matcher)Matchers.is((Object)"boom"));
    }

    @Test
    @Issue(value="W-16237424")
    public void errorTypeNamespaceWithInvalidString_ShouldThrowIllegalStateException() {
        Exception exception = (Exception)Assert.assertThrows(IllegalStateException.class, () -> this.addErrorType("", "", this.errorTypeRepository));
        MatcherAssert.assertThat((Object)exception, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"Prefix URI must be not blank"));
    }

    protected ErrorTypeRepositoryDTO toErrorTypeRepoDto() {
        return this.errorTypeRepositoryDTOFactory.from((ErrorTypeRepository)new CompositeErrorTypeRepository(Arrays.asList(this.coreErrorTypeRepo, this.errorTypeRepository)));
    }

    private ComponentIdentifier addErrorType(String name, String namespace, ErrorTypeRepository errorTypeRepository) {
        ComponentIdentifier componentIdentifier = ComponentIdentifier.builder().name(name).namespace(namespace).build();
        errorTypeRepository.addErrorType(componentIdentifier, this.coreErrorTypeRepo.getAnyErrorType());
        return componentIdentifier;
    }

    private ComponentIdentifier addInternalErrorType(String name, String namespace, ErrorTypeRepository errorTypeRepository) {
        ComponentIdentifier componentIdentifier = ComponentIdentifier.builder().name(name).namespace(namespace).build();
        errorTypeRepository.addInternalErrorType(componentIdentifier, this.coreErrorTypeRepo.getAnyErrorType());
        return componentIdentifier;
    }
}

