/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.serialization.dto.factory;

import org.mule.runtime.ast.internal.serialization.ArtifactAstSerializerMetadata;

public class AstDTOFactoryProvider {

  private final ArtifactAstSerializerMetadata serializerMetadata;

  public AstDTOFactoryProvider(ArtifactAstSerializerMetadata serializerMetadata) {
    this.serializerMetadata = serializerMetadata;
  }

  public ArtifactAstDTOFactory getArtifactAstDTOFactory() {
    return new ArtifactAstDTOFactory(this);
  }

  public ExtensionModelDTOFactory getExtensionModelDTOFactory() {
    return new ExtensionModelDTOFactory();
  }

  public ComponentAstDTOFactory getComponentAstDTOFactory() {
    return new ComponentAstDTOFactory(this);
  }

  public ComponentMetadataAstDTOFactory getComponentMetadataAstDTOFactory() {
    return new ComponentMetadataAstDTOFactory(this);
  }

  public ComponentParameterAstDTOFactory getComponentParameterAstDTOFactory() {
    return new ComponentParameterAstDTOFactory(this);
  }

  public ErrorTypeRepositoryDTOFactory getErrorRepositoryDTOFactory() {
    return new ErrorTypeRepositoryDTOFactory();
  }

  public ImportedResourceDTOFactory getImportedResourceDTOFactory() {
    return new ImportedResourceDTOFactory(this);
  }

  public ArtifactAstSerializerMetadata getSerializerMetadata() {
    return serializerMetadata;
  }
}
