/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.serialization.visitor;

import static org.mule.runtime.ast.internal.builder.adapter.MetadataTypeModelAdapter.createMetadataTypeModelAdapterWithStereotype;
import static org.mule.runtime.ast.internal.builder.adapter.MetadataTypeModelAdapter.createParameterizedTypeModelAdapter;

import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.ast.api.model.ExtensionModelHelper;
import org.mule.runtime.ast.internal.builder.adapter.MetadataTypeModelAdapter;
import org.mule.runtime.ast.internal.serialization.dto.ComponentAstDTO;

/**
 * Resolves models when encountering an ObjectType
 */
public class DTOMetadataTypeVisitor extends MetadataTypeVisitor {

  private final ExtensionModelHelper extensionModelHelper;
  private final ComponentAstDTO componentAstDTO;

  public DTOMetadataTypeVisitor(ComponentAstDTO componentAstDTO, ExtensionModelHelper extensionModelHelper) {
    this.extensionModelHelper = extensionModelHelper;
    this.componentAstDTO = componentAstDTO;
  }

  @Override
  public void visitObject(ObjectType objectType) {
    final MetadataTypeModelAdapter model = createMetadataTypeModelAdapterWithStereotype(objectType, extensionModelHelper)
        .orElseGet(() -> createParameterizedTypeModelAdapter(objectType, extensionModelHelper));
    componentAstDTO.setParameterizedModel(model);
  }

  @Override
  public void visitUnion(UnionType unionType) {
    unionType.getTypes().forEach(type -> type.accept(this));
  }

  @Override
  public void visitObjectField(ObjectFieldType objectFieldType) {
    super.visitObjectField(objectFieldType);
  }

}
