/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.serialization.dto;

import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.extension.api.loader.util.InfrastructureTypeUtils;

/**
 * Indicates what kind of model a components represents. This is used to avoid walking the whole model during the enrichment, and
 * instead query the kind of models directly, resulting in better performance of the enrichment/deserialization.
 */
public enum ComponentAstDTOModelType {

  /**
   * @see ConfigurationModel
   */
  CONFIGURATION,

  /**
   * @see ConnectionProviderModel
   */
  CONNECTION_PROVIDER,

  /**
   * @see OperationModel
   */
  OPERATION,

  /**
   * @see SourceModel
   */
  SOURCE,

  /**
   * @see ConstructModel
   */
  CONSTRUCT,

  /**
   * @see NestedComponentModel
   * @see NestedChainModel
   */
  NESTED_COMPONENT,

  /**
   * @see NestedRouteModel
   */
  NESTED_ROUTE,

  /**
   * @see ExtensionModel#getTypes()
   * @see ExtensionModel#getSubTypes()
   */
  TYPE,

  /**
   * @see InfrastructureTypeUtils
   */
  INFRASTRUCTURE
}
