/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.testobjects;

import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

import static java.util.Optional.empty;

public class DummyConfigurationModel implements ConfigurationModel {

  private final List<OperationModel> operationModels;
  private final List<SourceModel> sourceModels;
  private final String name;
  private final List<ParameterGroupModel> parameterGroupModels;
  private final ConnectionProviderModel connectionProviderModel;

  DummyConfigurationModel(String name, List<ParameterGroupModel> parameterGroupModels, List<OperationModel> operationModels) {
    this(name, parameterGroupModels, operationModels, new ArrayList<>(), null);
  }

  public DummyConfigurationModel(String name, List<ParameterGroupModel> parameterGroupModels,
                                 List<OperationModel> operationModels, List<SourceModel> sourceModels,
                                 ConnectionProviderModel connectionProviderModel) {
    this.name = name;
    this.parameterGroupModels = parameterGroupModels;
    this.operationModels = operationModels;
    this.sourceModels = sourceModels;
    this.connectionProviderModel = connectionProviderModel;
  }

  @Override
  public List<ParameterGroupModel> getParameterGroupModels() {
    return parameterGroupModels;
  }

  @Override
  public String getDescription() {
    return "Dummy configuration model description";
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public <T extends ModelProperty> Optional<T> getModelProperty(Class<T> aClass) {
    return empty();
  }

  @Override
  public Set<ModelProperty> getModelProperties() {
    return new HashSet<>();
  }

  @Override
  public Set<ExternalLibraryModel> getExternalLibraryModels() {
    return new HashSet<>();
  }

  @Override
  public List<ConnectionProviderModel> getConnectionProviders() {
    return new ArrayList<>();
  }

  @Override
  public Optional<ConnectionProviderModel> getConnectionProviderModel(String s) {
    return Optional.ofNullable(connectionProviderModel);
  }

  @Override
  public Optional<DeprecationModel> getDeprecationModel() {
    return empty();
  }

  @Override
  public Optional<DisplayModel> getDisplayModel() {
    return empty();
  }

  @Override
  public List<OperationModel> getOperationModels() {
    return operationModels;
  }

  @Override
  public Optional<OperationModel> getOperationModel(String s) {
    return empty();
  }

  @Override
  public List<SourceModel> getSourceModels() {
    return sourceModels;
  }

  @Override
  public Optional<SourceModel> getSourceModel(String s) {
    return empty();
  }

  @Override
  public StereotypeModel getStereotype() {
    return null;
  }

  @Override
  public Optional<MuleVersion> getMinMuleVersion() {
    return empty();
  }
}
