/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.xml.resolver;

import static java.lang.String.format;

import org.xml.sax.SAXException;

public interface ResolveEntityFailStrategy {

  void execute(String publicId, String systemId) throws SAXException;

  static void fail(String publicId, String systemId) throws SAXException {
    String namespaceNotFound = publicId == null
        ? format("Can't resolve %s", systemId)
        : format("Can't resolve %s (%s)", publicId, systemId);
    throw new SAXException(format("%s, A dependency or plugin might be missing", namespaceNotFound));
  }
}
