/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.xml.resolver;

import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;

/**
 * Decorator for {@link ExtensionSchemaGenerator} that caches the values returned by the
 * {@link #generate(ExtensionModel, DslResolvingContext)} method, using the {@link ExtensionModel} as key.
 *
 * @since 1.0
 */
public class CachingExtensionSchemaGenerator implements ExtensionSchemaGenerator {

  private final ExtensionSchemaGenerator delegate;
  private final Cache<ExtensionModel, String> schemasCache;

  public CachingExtensionSchemaGenerator(ExtensionSchemaGenerator delegate) {
    this.delegate = delegate;
    this.schemasCache = Caffeine.newBuilder().build();
  }

  @Override
  public String generate(ExtensionModel extensionModel, DslResolvingContext context) {
    return schemasCache.get(extensionModel, em -> delegate.generate(em, context));
  }

}
