/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.xml;

import io.qameta.allure.Issue;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.api.xml.AstXmlParser;

public class DefaultAstXmlParserTestCase {
    private static final XmlDslModel XML_DSL_MODEL = XmlDslModel.builder().setPrefix("mule").setNamespace("http://mockns").build();
    private ClassLoader classLoader;
    private AstXmlParser parser;
    private final Map<String, String> properties = new HashMap<String, String>();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final ExtensionModel mockedExtensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);

    @Before
    public void before() {
        this.properties.clear();
        this.classLoader = DefaultAstXmlParserTestCase.class.getClassLoader();
        ConstructModel topLevelSimpleConstruct = (ConstructModel)Mockito.mock(ConstructModel.class);
        Mockito.when((Object)topLevelSimpleConstruct.getName()).thenReturn((Object)"top-level-simple");
        ConstructModel topLevelSimpleOtherConstruct = (ConstructModel)Mockito.mock(ConstructModel.class);
        Mockito.when((Object)topLevelSimpleOtherConstruct.getName()).thenReturn((Object)"top-level-simple-other");
        ConstructModel topLevelImportConstruct = (ConstructModel)Mockito.mock(ConstructModel.class);
        Mockito.when((Object)topLevelImportConstruct.getName()).thenReturn((Object)"top-level-import");
        Mockito.when((Object)this.mockedExtensionModel.getName()).thenReturn((Object)"Mock Extension Model");
        Mockito.when((Object)this.mockedExtensionModel.getXmlDslModel()).thenReturn((Object)XML_DSL_MODEL);
        Mockito.when((Object)this.mockedExtensionModel.getConstructModels()).thenReturn(Arrays.asList(topLevelSimpleConstruct, topLevelImportConstruct, topLevelSimpleOtherConstruct));
        this.parser = AstXmlParser.builder().withSchemaValidationsDisabled().withExtensionModel(this.mockedExtensionModel).withPropertyResolver(propertyKey -> this.properties.getOrDefault(propertyKey, propertyKey)).build();
    }

    @Test
    public void simple() {
        ArtifactAst simpleAst = this.parser.parse(new URL[]{this.classLoader.getResource("simple.xml")});
        List components = simpleAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-simple"}));
    }

    @Test
    public void imports() {
        ArtifactAst importAst = this.parser.parse(new URL[]{this.classLoader.getResource("import.xml")});
        List components = importAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-import", "top-level-simple"}));
        List imports = importAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(imports, (Matcher)Matchers.contains((Object[])new String[]{"simple.xml"}));
    }

    @Test
    public void importsWithProperty() {
        this.properties.put("${prop}", "simple.xml");
        ArtifactAst importAst = this.parser.parse(new URL[]{this.classLoader.getResource("import-property.xml")});
        List components = importAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-import", "top-level-simple"}));
        List imports = importAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(imports, (Matcher)Matchers.contains((Object[])new String[]{"simple.xml"}));
    }

    @Test
    public void importsWithPropertyChangingValue() {
        this.properties.put("${prop}", "simple.xml");
        ArtifactAst importAst = this.parser.parse(new URL[]{this.classLoader.getResource("import-property.xml")});
        List components = importAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-import", "top-level-simple"}));
        List imports = importAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(imports, (Matcher)Matchers.contains((Object[])new String[]{"simple.xml"}));
        importAst.updatePropertiesResolver(key -> {
            if (key.equals("${prop}")) {
                return "alternativeValue";
            }
            return null;
        });
        List changedImports = importAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(changedImports, (Matcher)Matchers.contains((Object[])new String[]{"alternativeValue"}));
    }

    @Test
    public void twoConfigs() {
        ArtifactAst importAst = this.parser.parse(new URL[]{this.classLoader.getResource("simple.xml"), this.classLoader.getResource("simple-other.xml")});
        List components = importAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-simple", "top-level-simple-other"}));
        List imports = importAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(imports, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void twoConfigsAndImport() {
        ArtifactAst importAst = this.parser.parse(new URL[]{this.classLoader.getResource("import.xml"), this.classLoader.getResource("simple-other.xml")});
        List components = importAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-import", "top-level-simple-other", "top-level-simple"}));
        List imports = importAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(imports, (Matcher)Matchers.contains((Object[])new String[]{"simple.xml"}));
    }

    @Test
    public void twoConfigsAndImportSame() {
        ArtifactAst importAst = this.parser.parse(new URL[]{this.classLoader.getResource("import.xml"), this.classLoader.getResource("simple.xml")});
        List components = importAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-import", "top-level-simple"}));
        List imports = importAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(imports, (Matcher)Matchers.contains((Object[])new String[]{"simple.xml"}));
    }

    @Test
    public void twoConfigsAndImportSameInverse() {
        ArtifactAst importAst = this.parser.parse(new URL[]{this.classLoader.getResource("simple.xml"), this.classLoader.getResource("import.xml")});
        List components = importAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-simple", "top-level-import"}));
        List imports = importAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(imports, (Matcher)Matchers.contains((Object[])new String[]{"simple.xml"}));
    }

    @Test
    @Issue(value="MULE-19534")
    public void legacyFailStrategy() {
        this.expectedException.expect(MuleRuntimeException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Invalid content was found"));
        this.parser = AstXmlParser.builder().withPropertyResolver(propertyKey -> this.properties.getOrDefault(propertyKey, propertyKey)).withLegacyFailStrategy().build();
        this.parser.parse(new URL[]{this.classLoader.getResource("mule-config-schema-missing.xml")});
    }

    @Test
    @Issue(value="MULE-19534")
    public void newFailStrategy() {
        this.expectedException.expect(MuleRuntimeException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Can't resolve http://www.mulesoft.org/schema/mule/invalid-namespace/current/invalid-schema.xsd, A dependency or plugin might be missing"));
        this.parser = AstXmlParser.builder().withPropertyResolver(propertyKey -> this.properties.getOrDefault(propertyKey, propertyKey)).build();
        this.parser.parse(new URL[]{this.classLoader.getResource("mule-config-schema-missing.xml")});
    }
}

