/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.xml.metadata;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.net.URL;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.ast.internal.xml.DefaultAstXmlParserTestCase;

@Feature(value="Mule Artifact AST")
@Story(value="Source Location")
public class LocationMetadataTestCase {
    private ClassLoader classLoader;
    private AstXmlParser parser;

    @Before
    public void before() {
        this.classLoader = DefaultAstXmlParserTestCase.class.getClassLoader();
        this.parser = AstXmlParser.builder().withSchemaValidationsDisabled().withPropertyResolver(propertyKey -> propertyKey).build();
    }

    @Test
    @Issue(value="MULE-19634")
    public void propertyLocationMetadata() {
        ArtifactAst simpleAst = this.parser.parse(new URL[]{this.classLoader.getResource("metadata/flow-with-source-and-operations.xml")});
        ComponentAst globalProperty = (ComponentAst)simpleAst.topLevelComponents().get(0);
        ComponentMetadataAst metadata = globalProperty.getMetadata();
        MatcherAssert.assertThat((Object)metadata.getStartLine().getAsInt(), (Matcher)Is.is((Object)11));
        MatcherAssert.assertThat((Object)metadata.getStartColumn().getAsInt(), (Matcher)Is.is((Object)5));
    }

    @Test
    public void configLocationMetadata() {
        ArtifactAst simpleAst = this.parser.parse(new URL[]{this.classLoader.getResource("metadata/flow-with-source-and-operations.xml")});
        ComponentAst httpConfig = (ComponentAst)simpleAst.topLevelComponents().get(1);
        ComponentMetadataAst metadata = httpConfig.getMetadata();
        MatcherAssert.assertThat((Object)metadata.getStartLine().getAsInt(), (Matcher)Is.is((Object)12));
        MatcherAssert.assertThat((Object)metadata.getStartColumn().getAsInt(), (Matcher)Is.is((Object)5));
    }

    @Test
    public void flowLocationMetadata() {
        ArtifactAst simpleAst = this.parser.parse(new URL[]{this.classLoader.getResource("metadata/flow-with-source-and-operations.xml")});
        ComponentAst flow = (ComponentAst)simpleAst.topLevelComponents().get(2);
        ComponentMetadataAst metadata = flow.getMetadata();
        MatcherAssert.assertThat((Object)metadata.getStartLine().getAsInt(), (Matcher)Is.is((Object)16));
        MatcherAssert.assertThat((Object)metadata.getStartColumn().getAsInt(), (Matcher)Is.is((Object)5));
    }

    @Test
    @Issue(value="MULE-19634")
    public void sourceLocationMetadata() {
        ArtifactAst simpleAst = this.parser.parse(new URL[]{this.classLoader.getResource("metadata/flow-with-source-and-operations.xml")});
        ComponentAst flow = (ComponentAst)simpleAst.topLevelComponents().get(2);
        ComponentAst source = (ComponentAst)flow.directChildren().get(0);
        ComponentMetadataAst metadata = source.getMetadata();
        MatcherAssert.assertThat((Object)metadata.getStartLine().getAsInt(), (Matcher)Is.is((Object)17));
        MatcherAssert.assertThat((Object)metadata.getStartColumn().getAsInt(), (Matcher)Is.is((Object)9));
    }

    @Test
    public void operationTransformLocationMetadata() {
        ArtifactAst simpleAst = this.parser.parse(new URL[]{this.classLoader.getResource("metadata/flow-with-source-and-operations.xml")});
        ComponentAst flow = (ComponentAst)simpleAst.topLevelComponents().get(2);
        ComponentAst transform = (ComponentAst)flow.directChildren().get(1);
        ComponentMetadataAst metadata = transform.getMetadata();
        MatcherAssert.assertThat((Object)metadata.getStartLine().getAsInt(), (Matcher)Is.is((Object)18));
        MatcherAssert.assertThat((Object)metadata.getStartColumn().getAsInt(), (Matcher)Is.is((Object)9));
    }

    @Test
    public void operationLoggerLocationMetadata() {
        ArtifactAst simpleAst = this.parser.parse(new URL[]{this.classLoader.getResource("metadata/flow-with-source-and-operations.xml")});
        ComponentAst flow = (ComponentAst)simpleAst.topLevelComponents().get(2);
        ComponentAst logger = (ComponentAst)flow.directChildren().get(2);
        ComponentMetadataAst metadata = logger.getMetadata();
        MatcherAssert.assertThat((Object)metadata.getStartLine().getAsInt(), (Matcher)Is.is((Object)28));
        MatcherAssert.assertThat((Object)metadata.getStartColumn().getAsInt(), (Matcher)Is.is((Object)9));
    }

    @Test
    public void choiceRouterLocationMetadata() {
        ArtifactAst simpleAst = this.parser.parse(new URL[]{this.classLoader.getResource("metadata/flow-with-source-and-operations.xml")});
        ComponentAst flow = (ComponentAst)simpleAst.topLevelComponents().get(2);
        ComponentAst choice = (ComponentAst)flow.directChildren().get(4);
        ComponentMetadataAst metadata = choice.getMetadata();
        MatcherAssert.assertThat((Object)metadata.getStartLine().getAsInt(), (Matcher)Is.is((Object)30));
        MatcherAssert.assertThat((Object)metadata.getStartColumn().getAsInt(), (Matcher)Is.is((Object)9));
    }

    @Test
    public void operationRouteLocationMetadata() {
        ArtifactAst simpleAst = this.parser.parse(new URL[]{this.classLoader.getResource("metadata/flow-with-source-and-operations.xml")});
        ComponentAst flow = (ComponentAst)simpleAst.topLevelComponents().get(2);
        ComponentAst choice = (ComponentAst)flow.directChildren().get(4);
        ComponentAst firstRoute = (ComponentAst)choice.directChildren().get(0);
        ComponentMetadataAst metadata = firstRoute.getMetadata();
        MatcherAssert.assertThat((Object)metadata.getStartLine().getAsInt(), (Matcher)Is.is((Object)31));
        MatcherAssert.assertThat((Object)metadata.getStartColumn().getAsInt(), (Matcher)Is.is((Object)13));
    }

    @Test
    public void operationInChoiceRouteLocationMetadata() {
        ArtifactAst simpleAst = this.parser.parse(new URL[]{this.classLoader.getResource("metadata/flow-with-source-and-operations.xml")});
        ComponentAst flow = (ComponentAst)simpleAst.topLevelComponents().get(2);
        ComponentAst choice = (ComponentAst)flow.directChildren().get(4);
        ComponentAst firstRoute = (ComponentAst)choice.directChildren().get(0);
        ComponentAst componentInChoiceRoute = (ComponentAst)firstRoute.directChildren().get(0);
        ComponentMetadataAst metadata = componentInChoiceRoute.getMetadata();
        MatcherAssert.assertThat((Object)metadata.getStartLine().getAsInt(), (Matcher)Is.is((Object)32));
        MatcherAssert.assertThat((Object)metadata.getStartColumn().getAsInt(), (Matcher)Is.is((Object)17));
    }
}

