/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.xml.resolver;

import static org.mule.runtime.ast.internal.xml.resolver.ResolveEntityFailStrategy.fail;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

import org.xml.sax.SAXException;

public class FailAfterTenErrorsResolveEntityFailStrategy implements ResolveEntityFailStrategy {

  private static final int MAX_RESOLUTION_FAILURE_THRESHOLD = 10;

  /**
   * Saves already checked entities so that if the resolution fails more than {@link #MAX_RESOLUTION_FAILURE_THRESHOLD} it will
   * raise and exception instead of looping in failure over and over again.
   */
  private final Map<String, AtomicInteger> checkedEntities = new HashMap<>();

  @Override
  public void execute(String publicId, String systemId) throws SAXException {
    AtomicInteger failures = checkedEntities.get(systemId);
    if (failures != null) {
      if (failures.incrementAndGet() > MAX_RESOLUTION_FAILURE_THRESHOLD) {
        fail(publicId, systemId);
      }
    } else {
      checkedEntities.put(systemId, new AtomicInteger(1));
    }
  }
}
