/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.xml;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.dsl.api.ConfigResource;
import org.mule.runtime.dsl.api.xml.parser.XmlConfigurationDocumentLoader;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.helpers.DefaultHandler;

@Feature(value="Mule Artifact AST")
@Story(value="Artifact XML config parsing")
public class DefaultAstXmlParserTestCase {
    private static final XmlDslModel XML_DSL_MODEL = XmlDslModel.builder().setPrefix("mule").setNamespace("http://mockns").build();
    private ClassLoader classLoader;
    private AstXmlParser parser;
    private final Map<String, String> properties = new HashMap<String, String>();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final ExtensionModel mockedExtensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);

    @Before
    public void before() {
        this.properties.clear();
        this.classLoader = DefaultAstXmlParserTestCase.class.getClassLoader();
        ConstructModel topLevelSimpleConstruct = (ConstructModel)Mockito.mock(ConstructModel.class);
        Mockito.when((Object)topLevelSimpleConstruct.getName()).thenReturn((Object)"top-level-simple");
        ConstructModel topLevelSimpleOtherConstruct = (ConstructModel)Mockito.mock(ConstructModel.class);
        Mockito.when((Object)topLevelSimpleOtherConstruct.getName()).thenReturn((Object)"top-level-simple-other");
        ConstructModel topLevelImportConstruct = (ConstructModel)Mockito.mock(ConstructModel.class);
        Mockito.when((Object)topLevelImportConstruct.getName()).thenReturn((Object)"top-level-import");
        Mockito.when((Object)this.mockedExtensionModel.getName()).thenReturn((Object)"Mock Extension Model");
        Mockito.when((Object)this.mockedExtensionModel.getXmlDslModel()).thenReturn((Object)XML_DSL_MODEL);
        Mockito.when((Object)this.mockedExtensionModel.getConstructModels()).thenReturn(Arrays.asList(topLevelSimpleConstruct, topLevelImportConstruct, topLevelSimpleOtherConstruct));
        this.parser = AstXmlParser.builder().withSchemaValidationsDisabled().withExtensionModel(this.mockedExtensionModel).withPropertyResolver(propertyKey -> this.properties.getOrDefault(propertyKey, propertyKey)).build();
    }

    @Test
    public void simple() {
        ArtifactAst simpleAst = this.parser.parse(new URL[]{this.classLoader.getResource("simple.xml")});
        List components = simpleAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-simple"}));
    }

    @Test
    public void twoConfigs() {
        ArtifactAst twoConfigsAst = this.parser.parse(new URL[]{this.classLoader.getResource("simple.xml"), this.classLoader.getResource("simple-other.xml")});
        List components = twoConfigsAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-simple", "top-level-simple-other"}));
        List imports = twoConfigsAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(imports, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    @Story(value="Artifact XML config DOM processong")
    public void simpleDocuments() {
        Document document = XmlConfigurationDocumentLoader.noValidationDocumentLoader().loadDocument(() -> XMLSecureFactories.createDefault().getSAXParserFactory(), (EntityResolver)new DefaultHandler(), "simple.xml", this.classLoader.getResourceAsStream("simple.xml"), null);
        ArtifactAst simpleAst = this.parser.parseDocument(Arrays.asList(new Pair((Object)"simple.xml", (Object)document)));
        List components = simpleAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-simple"}));
    }

    @Test
    @Story(value="Artifact XML config DOM processong")
    public void twoConfigsDocuments() {
        Document simpleDocument = XmlConfigurationDocumentLoader.noValidationDocumentLoader().loadDocument(() -> XMLSecureFactories.createDefault().getSAXParserFactory(), (EntityResolver)new DefaultHandler(), "simple.xml", this.classLoader.getResourceAsStream("simple.xml"), null);
        Document otherDocument = XmlConfigurationDocumentLoader.noValidationDocumentLoader().loadDocument(() -> XMLSecureFactories.createDefault().getSAXParserFactory(), (EntityResolver)new DefaultHandler(), "simple-other.xml", this.classLoader.getResourceAsStream("simple-other.xml"), null);
        ArtifactAst twoConfigsAst = this.parser.parseDocument(Arrays.asList(new Pair((Object)"simple.xml", (Object)simpleDocument), new Pair((Object)"simple-other.xml", (Object)otherDocument)));
        List components = twoConfigsAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-simple", "top-level-simple-other"}));
        List imports = twoConfigsAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(imports, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void parseFromConfigResource() {
        URL resourceURL = this.classLoader.getResource("simple.xml");
        MatcherAssert.assertThat((Object)resourceURL, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        ConfigResource configResource = new ConfigResource(resourceURL);
        ArtifactAst simpleAst = this.parser.parse(new ConfigResource[]{configResource});
        List components = simpleAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-simple"}));
    }

    @Test
    @Issue(value="MULE-19534")
    public void legacyFailStrategy() {
        this.expectedException.expect(MuleRuntimeException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Invalid content was found"));
        this.parser = AstXmlParser.builder().withPropertyResolver(propertyKey -> this.properties.getOrDefault(propertyKey, propertyKey)).withLegacyFailStrategy().build();
        this.parser.parse(new URL[]{this.classLoader.getResource("mule-config-schema-missing.xml")});
    }

    @Test
    @Issue(value="MULE-19534")
    public void newFailStrategy() {
        this.expectedException.expect(MuleRuntimeException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Can't resolve http://www.mulesoft.org/schema/mule/invalid-namespace/current/invalid-schema.xsd, A dependency or plugin might be missing"));
        this.parser = AstXmlParser.builder().withPropertyResolver(propertyKey -> this.properties.getOrDefault(propertyKey, propertyKey)).build();
        this.parser.parse(new URL[]{this.classLoader.getResource("mule-config-schema-missing.xml")});
    }
}

