/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.xml.reader;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.collection.IsMapContaining.hasEntry;
import static org.mule.runtime.ast.AllureConstants.ArtifactAst.ARTIFACT_AST;
import static org.mule.runtime.ast.AllureConstants.ArtifactAst.Metadata.ANNOTATIONS;
import static org.mule.runtime.ast.api.xml.AstXmlParser.builder;

import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.xml.AstXmlParser;

import java.util.HashMap;
import java.util.Map;

import org.junit.Before;
import org.junit.Test;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;

@Feature(ARTIFACT_AST)
@Story(ANNOTATIONS)
public class XmlAnnotationsTestCase {

  private ClassLoader classLoader;
  private AstXmlParser parser;

  private final Map<String, String> properties = new HashMap<>();

  @Before
  public void before() {
    properties.clear();
    classLoader = XmlAnnotationsTestCase.class.getClassLoader();

    parser = builder()
        .withSchemaValidationsDisabled()
        .withPropertyResolver(propertyKey -> properties.getOrDefault(propertyKey, propertyKey))
        .build();
  }

  @Test
  public void annotationsOnCoreElement() {
    ArtifactAst artifact = parser.parse(classLoader.getResource("mule-config-annotations.xml"));

    ComponentAst flow = artifact.topLevelComponents().get(1);
    assertThat(flow.getAnnotations().toString(), flow.getAnnotations(),
               hasEntry("{http://www.mulesoft.org/schema/mule/other-ns}annotation", "anotherAnnotation"));
  }

  @Test
  @Issue("MULE-19683")
  public void annotationsOnSameNamespaceElement() {
    ArtifactAst artifact = parser.parse(classLoader.getResource("mule-config-annotations.xml"));

    ComponentAst someConfig = artifact.topLevelComponents().get(0);
    assertThat(someConfig.getAnnotations().toString(), someConfig.getAnnotations(),
               hasEntry("{http://www.mulesoft.org/schema/mule/other-ns}meta", "someAnnotation"));
  }

  @Test
  public void documentationWithTag() {
    ArtifactAst artifact = parser.parse(classLoader.getResource("with-descriptions.xml"));

    ComponentAst documentedFlow = artifact.topLevelComponents().get(0);
    assertThat(documentedFlow.getMetadata().getDocAttributes().get("description"), is("A flow"));
  }

}
