/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.xml.resolver;

import static org.junit.Assert.assertThrows;

import org.junit.Test;
import org.xml.sax.SAXException;

public class FailOnFirstErrorResolveEntityFailStrategyTestCase {

  ResolveEntityFailStrategy failStrategy = new FailOnFirstErrorResolveEntityFailStrategy();

  @Test
  public void failOnFirstAttempt() throws SAXException {
    assertThrows("Can't resolve notExists (notExists), A dependency or plugin might be missing", SAXException.class,
                 () -> failStrategy.execute("notExists", "notExists"));
  }
}
